/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsProjectLog
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsProjectLog.class);
    public static final Topic<ProjectLogListener> VCS_PROJECT_LOG_CHANGED = Topic.create((String)"Project Vcs Log Created or Disposed", ProjectLogListener.class);
    private static final int RECREATE_LOG_TRIES = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @NotNull
    private final VcsLogTabsManager myTabsManager;
    @NotNull
    private final LazyVcsLogManager myLogManager;
    private int myRecreatedLogCount;

    public VcsProjectLog(@NotNull Project project, @NotNull MessageBus messageBus, @NotNull VcsLogProjectTabsProperties uiProperties) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            VcsProjectLog.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsProjectLog.$$$reportNull$$$0(2);
        }
        this.myLogManager = new LazyVcsLogManager();
        this.myRecreatedLogCount = 0;
        this.myProject = project;
        this.myMessageBus = messageBus;
        this.myUiProperties = uiProperties;
        this.myTabsManager = new VcsLogTabsManager(project, messageBus, uiProperties, this);
    }

    @Nullable
    public VcsLogData getDataManager() {
        VcsLogManager cached = this.myLogManager.getCached();
        if (cached == null) {
            return null;
        }
        return cached.getDataManager();
    }

    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        VcsLogContentProvider logContentProvider = VcsLogContentProvider.getInstance(this.myProject);
        if (logContentProvider == null) {
            return null;
        }
        return logContentProvider.getUi();
    }

    @Nullable
    public VcsLogManager getLogManager() {
        return this.myLogManager.getCached();
    }

    @NotNull
    public VcsLogTabsManager getTabsManager() {
        VcsLogTabsManager vcsLogTabsManager = this.myTabsManager;
        if (vcsLogTabsManager == null) {
            VcsProjectLog.$$$reportNull$$$0(3);
        }
        return vcsLogTabsManager;
    }

    private void recreateLog() {
        UIUtil.invokeLaterIfNeeded(() -> this.myLogManager.drop(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.createLog(false);
        }));
    }

    private void recreateOnError(@NotNull Throwable t) {
        if (t == null) {
            VcsProjectLog.$$$reportNull$$$0(4);
        }
        if (++this.myRecreatedLogCount % 5 == 0) {
            String message = String.format("VCS Log was recreated %d times due to data corruption\nDelete %s directory and restart %s if this happens often.\n%s", this.myRecreatedLogCount, PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName(), t.getMessage());
            LOG.error(message, t);
            VcsLogManager manager = this.getLogManager();
            if (manager != null && manager.isLogVisible()) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
            }
        } else {
            LOG.debug("Recreating VCS Log after storage corruption", t);
        }
        this.recreateLog();
    }

    @Nullable
    VcsLogManager createLog(boolean forceInit) {
        Map<VirtualFile, VcsLogProvider> logProviders = this.getLogProviders();
        if (!logProviders.isEmpty()) {
            return this.createLog(logProviders, forceInit);
        }
        return null;
    }

    private VcsLogManager createLog(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, boolean forceInit) {
        if (logProviders == null) {
            VcsProjectLog.$$$reportNull$$$0(5);
        }
        VcsLogManager logManager = this.myLogManager.getValue(logProviders);
        ApplicationManager.getApplication().invokeLater(() -> {
            VcsLogCachesInvalidator invalidator;
            if (logManager.isLogVisible() || forceInit) {
                logManager.scheduleInitialization();
            } else if (PostponableLogRefresher.keepUpToDate() && (invalidator = (VcsLogCachesInvalidator)((Object)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class)))).isValid()) {
                HeavyAwareExecutor.executeOutOfHeavyProcessLater(logManager::scheduleInitialization, 5000);
            }
        });
        return logManager;
    }

    @NotNull
    private Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map2 = VcsLogManager.findLogProviders(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcsRoots()), this.myProject);
        if (map2 == null) {
            VcsProjectLog.$$$reportNull$$$0(6);
        }
        return map2;
    }

    public static VcsProjectLog getInstance(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(7);
        }
        return (VcsProjectLog)ServiceManager.getService((Project)project, VcsProjectLog.class);
    }

    public void addProjectLogListener(@NotNull ProjectLogListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            VcsProjectLog.$$$reportNull$$$0(8);
        }
        if (disposable == null) {
            VcsProjectLog.$$$reportNull$$$0(9);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            LazyVcsLogManager lazyVcsLogManager = this.myLogManager;
            synchronized (lazyVcsLogManager) {
                VcsLogManager cached = this.myLogManager.getCached();
                this.myMessageBus.connect(disposable).subscribe(VCS_PROJECT_LOG_CHANGED, (Object)listener);
                if (cached != null) {
                    listener.logCreated(cached);
                }
            }
        });
    }

    public void dispose() {
        this.myLogManager.drop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recreateOnError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLog";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addProjectLogListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProjectLogListener {
        public void logCreated(@NotNull VcsLogManager var1);

        default public void logDisposed(@NotNull VcsLogManager manager) {
            if (manager == null) {
                ProjectLogListener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/impl/VcsProjectLog$ProjectLogListener", "logDisposed"));
        }
    }

    public static class InitLogStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                InitLogStartupActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
                connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> projectLog.recreateLog());
                projectLog.createLog(false);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog$InitLogStartupActivity", "runActivity"));
        }
    }

    private class LazyVcsLogManager {
        @Nullable
        private VcsLogManager myValue;

        private LazyVcsLogManager() {
        }

        @NotNull
        public synchronized VcsLogManager getValue(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
            if (logProviders == null) {
                LazyVcsLogManager.$$$reportNull$$$0(0);
            }
            if (this.myValue == null) {
                VcsLogManager value;
                this.myValue = value = this.compute(logProviders);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!VcsProjectLog.this.myProject.isDisposed()) {
                        ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logCreated(value);
                    }
                });
            }
            VcsLogManager vcsLogManager = this.myValue;
            if (vcsLogManager == null) {
                LazyVcsLogManager.$$$reportNull$$$0(1);
            }
            return vcsLogManager;
        }

        @NotNull
        protected VcsLogManager compute(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
            if (logProviders == null) {
                LazyVcsLogManager.$$$reportNull$$$0(2);
            }
            VcsLogManager vcsLogManager = new VcsLogManager(VcsProjectLog.this.myProject, VcsProjectLog.this.myUiProperties, logProviders, false, (Consumer<? super Throwable>)((Consumer)x$0 -> VcsProjectLog.this.recreateOnError(x$0)));
            if (vcsLogManager == null) {
                LazyVcsLogManager.$$$reportNull$$$0(3);
            }
            return vcsLogManager;
        }

        public synchronized void drop() {
            LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
            this.drop(null);
        }

        public synchronized void drop(@Nullable Runnable callback2) {
            if (this.myValue != null) {
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logDisposed(this.myValue);
                this.myValue.dispose(callback2);
                this.myValue = null;
            } else if (callback2 != null) {
                ApplicationManager.getApplication().executeOnPooledThread(callback2);
            }
        }

        @Nullable
        public synchronized VcsLogManager getCached() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logProviders";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

