/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.actions.IntelliSortChooserPopupAction;
import com.intellij.vcs.log.ui.actions.ShowPreviewEditorAction;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.VcsLogChangeProcessor;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.BekUtil;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements DataProvider,
Disposable {
    private static final String DIFF_SPLITTER_PROPORTION = "vcs.log.diff.splitter.proportion";
    private static final String DETAILS_SPLITTER_PROPORTION = "vcs.log.details.splitter.proportion";
    private static final String CHANGES_SPLITTER_PROPORTION = "vcs.log.changes.splitter.proportion";
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final VcsLogClassicFilterUi myFilterUi;
    @NotNull
    private final SearchTextField myTextFilter;
    @NotNull
    private final VcsLogChangesBrowser myChangesBrowser;
    @NotNull
    private final Splitter myChangesBrowserSplitter;
    @NotNull
    private final VcsLogChangeProcessor myPreviewDiff;
    @NotNull
    private final Splitter myPreviewDiffSplitter;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;

    public MainFrame(@NotNull VcsLogData logData, final @NotNull VcsLogUiImpl logUi, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePack initialDataPack, @Nullable VcsLogFilterCollection filters) {
        if (logData == null) {
            MainFrame.$$$reportNull$$$0(0);
        }
        if (logUi == null) {
            MainFrame.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            MainFrame.$$$reportNull$$$0(2);
        }
        if (initialDataPack == null) {
            MainFrame.$$$reportNull$$$0(3);
        }
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myFilterUi = new VcsLogClassicFilterUi(logUi, logData, this.myUiProperties, initialDataPack, filters);
        this.myGraphTable = new MyVcsLogGraphTable(logUi, logData, initialDataPack);
        this.myGraphTable.setCompactReferencesView(this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
        this.myGraphTable.setShowTagNames(this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        this.myDetailsPanel = new DetailsPanel(logData, logUi.getColorManager(), this){

            @Override
            protected void navigate(@NotNull CommitId commit2) {
                if (commit2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                logUi.jumpToCommit(commit2.getHash(), commit2.getRoot());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/frame/MainFrame$1", "navigate"));
            }
        };
        this.myChangesBrowser = new VcsLogChangesBrowser(logData.getProject(), this.myUiProperties, (Function<? super CommitId, ? extends VcsShortCommitDetails>)((Function)commitId -> {
            int index = this.myLogData.getCommitIndex(commitId.getHash(), commitId.getRoot());
            return this.myLogData.getMiniDetailsGetter().getCommitData(index, Collections.singleton(index));
        }), this);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        JBLoadingPanel changesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        changesLoadingPane.add((Component)this.myChangesBrowser);
        this.myPreviewDiff = new VcsLogChangeProcessor(logData.getProject(), this.myChangesBrowser, false, this);
        this.myTextFilter = this.myFilterUi.createTextFilter();
        this.myToolbar = this.createActionsToolbar();
        this.myChangesBrowser.setToolbarHeightReferent(this.myToolbar);
        this.myPreviewDiff.getToolbarWrapper().setVerticalSizeReferent(this.myToolbar);
        MyCommitSelectionListenerForDiff listenerForDiff = new MyCommitSelectionListenerForDiff(changesLoadingPane);
        this.myGraphTable.getSelectionModel().addListSelectionListener(listenerForDiff);
        Disposer.register((Disposable)this, () -> this.myGraphTable.getSelectionModel().removeListSelectionListener(listenerForDiff));
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, this.myLogData, this);
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.myToolbar, "North");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        toolbarsAndTable.add((Component)VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 2), this.myLogData, logUi.getId(), this), "Center");
        this.myDetailsSplitter = new OnePixelSplitter(true, DETAILS_SPLITTER_PROPORTION, 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)changesLoadingPane);
        this.showDetails(this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        this.myChangesBrowserSplitter = new OnePixelSplitter(false, CHANGES_SPLITTER_PROPORTION, 0.7f);
        this.myChangesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        this.myChangesBrowserSplitter.setSecondComponent((JComponent)this.myDetailsSplitter);
        this.myPreviewDiffSplitter = new OnePixelSplitter(false, DIFF_SPLITTER_PROPORTION, 0.7f);
        this.myPreviewDiffSplitter.setHonorComponentsMinimumSize(false);
        this.myPreviewDiffSplitter.setFirstComponent((JComponent)this.myChangesBrowserSplitter);
        this.showDiffPreview(this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
        this.setLayout(new BorderLayout());
        this.add((Component)this.myPreviewDiffSplitter);
        Disposer.register((Disposable)logUi, (Disposable)this);
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyFocusPolicy()));
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        if (dataPack == null) {
            MainFrame.$$$reportNull$$$0(4);
        }
        this.myFilterUi.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
        this.myChangesBrowser.setAffectedPaths(VcsLogUtil.getAffectedPaths(dataPack));
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            MainFrame.$$$reportNull$$$0(5);
        }
        return vcsLogGraphTable;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogClassicFilterUi vcsLogClassicFilterUi = this.myFilterUi;
        if (vcsLogClassicFilterUi == null) {
            MainFrame.$$$reportNull$$$0(6);
        }
        return vcsLogClassicFilterUi;
    }

    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.copyFromGroup((DefaultActionGroup)ActionManager.getInstance().getAction("Vcs.Log.Toolbar.Internal"));
        if (BekUtil.isBekEnabled()) {
            Constraints constraint = new Constraints(Anchor.BEFORE, "Vcs.Log.PresentationSettings");
            if (BekUtil.isLinearBekEnabled()) {
                toolbarGroup.add((AnAction)new IntelliSortChooserPopupAction(), constraint);
            } else {
                toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.IntelliSortChooser"), constraint);
            }
        }
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.TextFilterSettings"));
        mainGroup.add((AnAction)new Separator());
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar = this.createActionsToolbar(mainGroup);
        Wrapper textFilter = new Wrapper((JComponent)this.myTextFilter);
        textFilter.setVerticalSizeReferent(toolbar.getComponent());
        textFilter.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        DefaultActionGroup rightCornerGroup = new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.Toolbar.RightCorner")});
        ActionToolbar rightCornerToolbar = this.createActionsToolbar(rightCornerGroup);
        rightCornerToolbar.setReservePlaceAutoPopupIcon(false);
        rightCornerToolbar.setLayoutPolicy(0);
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[left]0[left, fill]push[right]", "center"));
        panel2.add((Component)textFilter);
        panel2.add(toolbar.getComponent());
        panel2.add(rightCornerToolbar.getComponent());
        return panel2;
    }

    @NotNull
    private ActionToolbar createActionsToolbar(@NotNull DefaultActionGroup mainGroup) {
        if (mainGroup == null) {
            MainFrame.$$$reportNull$$$0(7);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Vcs.Log.Toolbar", (ActionGroup)mainGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            MainFrame.$$$reportNull$$$0(8);
        }
        return actionToolbar;
    }

    @NotNull
    public JComponent getMainComponent() {
        MainFrame mainFrame = this;
        if (mainFrame == null) {
            MainFrame.$$$reportNull$$$0(9);
        }
        return mainFrame;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            MainFrame.$$$reportNull$$$0(10);
        }
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return this.myChangesBrowser.getDirectChanges().toArray(new Change[0]);
        }
        if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
            return this.myUiProperties;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            return VfsUtilCore.toVirtualFileArray(roots);
        }
        if (VcsLogInternalDataKeys.LOG_DIFF_HANDLER.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            if (roots.size() != 1) {
                return null;
            }
            return this.myLogData.getLogProvider((VirtualFile)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(roots))).getDiffHandler();
        }
        if (ShowPreviewEditorAction.DATA_KEY.is(dataId)) {
            return new ShowPreviewEditorAction.DiffPreviewProvider(){

                @Override
                @NotNull
                public DiffRequestProcessor createDiffRequestProcessor() {
                    VcsLogChangeProcessor preview2 = new VcsLogChangeProcessor(MainFrame.this.myLogData.getProject(), MainFrame.this.myChangesBrowser, true, MainFrame.this.myChangesBrowser);
                    preview2.updatePreview(true);
                    VcsLogChangeProcessor vcsLogChangeProcessor = preview2;
                    if (vcsLogChangeProcessor == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return vcsLogChangeProcessor;
                }

                @Override
                @NotNull
                public Object getOwner() {
                    MainFrame mainFrame = MainFrame.this;
                    if (mainFrame == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return mainFrame;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/vcs/log/ui/frame/MainFrame$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createDiffRequestProcessor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getOwner";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }
        return null;
    }

    @NotNull
    private Collection<VirtualFile> getSelectedRoots() {
        Collection<VirtualFile> roots = this.myLogData.getRoots();
        if (roots.size() == 1) {
            Collection<VirtualFile> collection = roots;
            if (collection == null) {
                MainFrame.$$$reportNull$$$0(11);
            }
            return collection;
        }
        int[] selectedRows = this.myGraphTable.getSelectedRows();
        if (selectedRows.length == 0 || selectedRows.length > 1000) {
            Set<VirtualFile> set = VcsLogUtil.getAllVisibleRoots(roots, this.myFilterUi.getFilters());
            if (set == null) {
                MainFrame.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set set = ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row2 -> this.myGraphTable.getModel().getRoot((int)row2));
        if (set == null) {
            MainFrame.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myToolbar;
        if (jComponent == null) {
            MainFrame.$$$reportNull$$$0(14);
        }
        return jComponent;
    }

    @NotNull
    public SearchTextField getTextFilter() {
        SearchTextField searchTextField = this.myTextFilter;
        if (searchTextField == null) {
            MainFrame.$$$reportNull$$$0(15);
        }
        return searchTextField;
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    public void showDiffPreview(boolean state) {
        this.myPreviewDiff.updatePreview(state);
        this.myPreviewDiffSplitter.setSecondComponent(state ? this.myPreviewDiff.getComponent() : null);
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
        this.myChangesBrowserSplitter.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialDataPack";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainGroup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsToolbar";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createActionsToolbar";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVcsLogGraphTable
    extends VcsLogGraphTable {
        MyVcsLogGraphTable(@NotNull VcsLogUiImpl ui2, @NotNull VcsLogData logData, VisiblePack initialDataPack) {
            if (ui2 == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(0);
            }
            if (logData == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(1);
            }
            if (initialDataPack == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(2);
            }
            super(ui2, logData, initialDataPack, (Consumer<Runnable>)((Consumer)ui2::requestMore));
        }

        @Override
        protected void updateEmptyText() {
            StatusText statusText = this.getEmptyText();
            VisiblePack visiblePack = this.getModel().getVisiblePack();
            if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
                if (visiblePack.getFilters().isEmpty()) {
                    statusText.setText("No changes committed.").appendSecondaryText("Commit local changes", VcsLogUiUtil.getLinkAttributes(), ActionUtil.createActionListener((String)"CheckinProject", (Component)((Object)this), (String)"unknown"));
                    String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"CheckinProject");
                    if (!shortcutText.isEmpty()) {
                        statusText.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
                    }
                } else {
                    statusText.setText("No commits matching filters.").appendSecondaryText("Reset filters", VcsLogUiUtil.getLinkAttributes(), e -> MainFrame.this.myFilterUi.setFilter(null));
                }
            } else {
                statusText.setText("Changes log");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "initialDataPack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/frame/MainFrame$MyVcsLogGraphTable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            List<Component> list = Arrays.asList(new Component[]{MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent(), MainFrame.this.myPreviewDiff.getPreferredFocusedComponent(), MainFrame.this.myTextFilter.getTextEditor()});
            if (list == null) {
                MyFocusPolicy.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$MyFocusPolicy", "getOrderedComponents"));
        }
    }

    private class MyCommitSelectionListenerForDiff
    extends CommitSelectionListener<VcsFullCommitDetails> {
        @NotNull
        private final JBLoadingPanel myChangesLoadingPane;

        protected MyCommitSelectionListenerForDiff(JBLoadingPanel changesLoadingPane) {
            if (changesLoadingPane == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(0);
            }
            super(MainFrame.this.myGraphTable, MainFrame.this.myLogData.getCommitDetailsGetter());
            this.myChangesLoadingPane = changesLoadingPane;
        }

        @Override
        protected void onEmptySelection() {
            MainFrame.this.myChangesBrowser.setSelectedDetails(Collections.emptyList());
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
            int maxSize;
            if (detailsList == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(1);
            }
            if ((maxSize = VcsLogUtil.getMaxSize(detailsList)) > VcsLogUtil.getShownChangesLimit()) {
                String commitText = detailsList.size() == 1 ? "This commit" : "One of the selected commits";
                String sizeText = VcsLogUtil.getSizeText(maxSize);
                MainFrame.this.myChangesBrowser.showText(statusText -> {
                    statusText.setText(commitText + " has " + sizeText + " changes");
                    statusText.appendSecondaryText("Show anyway", VcsLogUiUtil.getLinkAttributes(), e -> MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList));
                });
            } else {
                MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList);
            }
        }

        @Override
        protected void onSelection(@NotNull int[] selection) {
            if (selection == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(2);
            }
            MainFrame.this.myChangesBrowser.resetSelectedDetails();
        }

        @Override
        protected void startLoading() {
            this.myChangesLoadingPane.startLoading();
        }

        @Override
        protected void stopLoading() {
            this.myChangesLoadingPane.stopLoading();
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            if (error == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(3);
            }
            MainFrame.this.myChangesBrowser.showText(statusText -> statusText.setText("Error loading commits"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesLoadingPane";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/MainFrame$MyCommitSelectionListenerForDiff";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDetailsLoaded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSelection";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

