/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitVcs;
import git4idea.util.GitFileUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class GitAdd
extends ScheduleForAdditionAction {
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GitAdd.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return false;
        }
        if (!UtilKt.isEmpty((Stream)GitAdd.getUnversionedFiles((AnActionEvent)e, (Project)project))) {
            return true;
        }
        Stream changeStream = UtilKt.stream((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        if (!UtilKt.isEmpty(GitAdd.collectPathsFromChanges(project, changeStream))) {
            return true;
        }
        Stream filesStream = UtilKt.notNullize((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)));
        return !UtilKt.isEmpty(GitAdd.collectPathsFromFiles(project, filesStream));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GitAdd.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        HashSet toAdd = new HashSet();
        Stream changeStream = UtilKt.stream((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        ContainerUtil.addAll(toAdd, GitAdd.collectPathsFromChanges(project, changeStream).iterator());
        Stream filesStream = UtilKt.notNullize((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)));
        ContainerUtil.addAll(toAdd, GitAdd.collectPathsFromFiles(project, filesStream).iterator());
        List unversionedFiles = GitAdd.getUnversionedFiles((AnActionEvent)e, (Project)project).collect(Collectors.toList());
        GitAdd.addUnversioned((Project)project, unversionedFiles, (ChangesBrowserBase)((ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY)), !toAdd.isEmpty() ? (indicator, exceptions) -> GitAdd.addPathsToVcs(project, toAdd, exceptions) : null);
    }

    private static void addPathsToVcs(@NotNull Project project, @NotNull Collection<? extends FilePath> toAdd, @NotNull List<? super VcsException> exceptions) {
        if (project == null) {
            GitAdd.$$$reportNull$$$0(2);
        }
        if (toAdd == null) {
            GitAdd.$$$reportNull$$$0(3);
        }
        if (exceptions == null) {
            GitAdd.$$$reportNull$$$0(4);
        }
        VcsUtil.groupByRoots((Project)project, toAdd, (Function)Functions.identity()).forEach((vcsRoot, paths) -> {
            try {
                if (!(vcsRoot.getVcs() instanceof GitVcs)) {
                    return;
                }
                VirtualFile root = vcsRoot.getPath();
                if (root == null) {
                    return;
                }
                GitFileUtils.addPaths(project, root, paths);
                VcsFileUtil.markFilesDirty((Project)project, (List)paths);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
            }
        });
    }

    @NotNull
    private static Stream<FilePath> collectPathsFromChanges(@NotNull Project project, @NotNull Stream<? extends Change> allChanges) {
        if (project == null) {
            GitAdd.$$$reportNull$$$0(5);
        }
        if (allChanges == null) {
            GitAdd.$$$reportNull$$$0(6);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        Stream<FilePath> stream = allChanges.filter(change -> {
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            return vcsManager.getVcsFor(filePath) instanceof GitVcs && GitAdd.isStatusForAddition(change.getFileStatus());
        }).map(ChangesUtil::getFilePath);
        if (stream == null) {
            GitAdd.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @NotNull
    private static Stream<FilePath> collectPathsFromFiles(@NotNull Project project, @NotNull Stream<? extends VirtualFile> allFiles) {
        if (project == null) {
            GitAdd.$$$reportNull$$$0(8);
        }
        if (allFiles == null) {
            GitAdd.$$$reportNull$$$0(9);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Stream<FilePath> stream = allFiles.filter(file -> vcsManager.getVcsFor(file) instanceof GitVcs && (file.isDirectory() || GitAdd.isStatusForAddition(changeListManager.getStatus(file)))).map(VcsUtil::getFilePath);
        if (stream == null) {
            GitAdd.$$$reportNull$$$0(10);
        }
        return stream;
    }

    private static boolean isStatusForAddition(FileStatus status) {
        return status == FileStatus.MODIFIED || status == FileStatus.MERGED_WITH_CONFLICTS || status == FileStatus.ADDED || status == FileStatus.DELETED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allChanges";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitAdd";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitAdd";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPathsFromChanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPathsFromFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPathsToVcs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectPathsFromChanges";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectPathsFromFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

