/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.push.GitPushParamsImpl;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDeleteRemoteBranchOperation
extends GitBranchOperation {
    private final String myBranchName;

    GitDeleteRemoteBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler handler, @NotNull List<? extends GitRepository> repositories, @NotNull String name) {
        if (project == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(3);
        }
        if (name == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(4);
        }
        super(project, git, handler, repositories);
        this.myBranchName = name;
    }

    @Override
    protected void execute() {
        boolean deletedSuccessfully;
        Collection<GitRepository> repositories = this.getRepositories();
        Collection<String> commonTrackingBranches = GitDeleteRemoteBranchOperation.getCommonTrackingBranches(this.myBranchName, repositories);
        for (GitRepository repository : repositories) {
            String currentBranch = repository.getCurrentBranchName();
            if (currentBranch == null) continue;
            commonTrackingBranches.remove(currentBranch);
        }
        Ref decision = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> decision.set((Object)this.myUiHandler.confirmRemoteBranchDeletion(this.myBranchName, commonTrackingBranches, repositories)));
        if (decision.get() != GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL && (deletedSuccessfully = this.doDeleteRemote(this.myBranchName, repositories))) {
            final ArrayList<String> successfullyDeletedLocalBranches = new ArrayList<String>(1);
            if (decision.get() == GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE_WITH_TRACKING) {
                for (final String branch : commonTrackingBranches) {
                    this.getIndicator().setText("Deleting " + branch);
                    new GitDeleteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branch){

                        @Override
                        protected void notifySuccess(@NotNull String message) {
                            if (message == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            successfullyDeletedLocalBranches.add(branch);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/branch/GitDeleteRemoteBranchOperation$1", "notifySuccess"));
                        }
                    }.execute();
                }
            }
            this.notifySuccessfulDeletion(this.myBranchName, successfullyDeletedLocalBranches);
        }
    }

    @Override
    protected void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static Collection<String> getCommonTrackingBranches(@NotNull String remoteBranch, @NotNull Collection<? extends GitRepository> repositories) {
        if (remoteBranch == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(5);
        }
        if (repositories == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(6);
        }
        Collection<String> collection = new GitMultiRootBranchConfig(repositories).getCommonTrackingBranches(remoteBranch);
        if (collection == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private boolean doDeleteRemote(@NotNull String branchName, @NotNull Collection<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(8);
        }
        if (repositories == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(9);
        }
        Couple<String> pair = GitDeleteRemoteBranchOperation.splitNameOfRemoteBranch(branchName);
        String remoteName = (String)pair.getFirst();
        String branch = (String)pair.getSecond();
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository gitRepository : repositories) {
            GitCommandResult res;
            GitRemote remote = GitDeleteRemoteBranchOperation.getRemoteByName(gitRepository, remoteName);
            if (remote == null) {
                String error = "Couldn't find remote by name: " + remoteName;
                LOG.error(error);
                res = GitCommandResult.error(error);
            } else {
                res = this.pushDeletion(gitRepository, remote, branch);
                if (!res.success() && GitDeleteRemoteBranchOperation.isAlreadyDeletedError(res.getErrorOutputAsJoinedString())) {
                    res = this.myGit.remotePrune(gitRepository, remote);
                }
            }
            result2.append(gitRepository, res);
            gitRepository.update();
        }
        if (!result2.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Failed to delete remote branch " + branchName, result2.getErrorOutputWithReposIndication());
        }
        return result2.totalSuccess();
    }

    private static boolean isAlreadyDeletedError(@NotNull String errorOutput) {
        if (errorOutput == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(10);
        }
        return errorOutput.contains("remote ref does not exist");
    }

    private static Couple<String> splitNameOfRemoteBranch(String branchName) {
        int firstSlash = branchName.indexOf(47);
        String remoteName = firstSlash > -1 ? branchName.substring(0, firstSlash) : branchName;
        String remoteBranchName = branchName.substring(firstSlash + 1);
        return Couple.of((Object)remoteName, (Object)remoteBranchName);
    }

    @NotNull
    private GitCommandResult pushDeletion(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        if (repository == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(11);
        }
        if (remote == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(12);
        }
        if (branchName == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(13);
        }
        GitCommandResult gitCommandResult = this.myGit.push(repository, new GitPushParamsImpl(remote, ":" + branchName, false, false, false, null, Collections.emptyList()), new GitLineHandlerListener[0]);
        if (gitCommandResult == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(14);
        }
        return gitCommandResult;
    }

    @Nullable
    private static GitRemote getRemoteByName(@NotNull GitRepository repository, @NotNull String remoteName) {
        if (repository == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(15);
        }
        if (remoteName == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(16);
        }
        for (GitRemote remote : repository.getRemotes()) {
            if (!remote.getName().equals(remoteName)) continue;
            return remote;
        }
        return null;
    }

    private void notifySuccessfulDeletion(@NotNull String remoteBranchName, @NotNull Collection<String> localBranches) {
        if (remoteBranchName == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(17);
        }
        if (localBranches == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(18);
        }
        String message = "";
        if (!localBranches.isEmpty()) {
            message = "Also deleted local " + StringUtil.pluralize((String)"branch", (int)localBranches.size()) + ": " + StringUtil.join(localBranches, (String)", ");
        }
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Deleted remote branch " + remoteBranchName, message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranch";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitDeleteRemoteBranchOperation";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorOutput";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranchName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitDeleteRemoteBranchOperation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTrackingBranches";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "pushDeletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTrackingBranches";
                break;
            }
            case 7: 
            case 14: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doDeleteRemote";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyDeletedError";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pushDeletion";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteByName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccessfulDeletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

