/*
 * Decompiled with CFR 0.152.
 */
package git4idea.crlf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.attributes.GitAttribute;
import git4idea.attributes.GitCheckAttrParser;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitCrlfProblemsDetector {
    private static final Logger LOG = Logger.getInstance(GitCrlfProblemsDetector.class);
    private static final String CRLF = "\r\n";
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    private final boolean myShouldWarn;

    @NotNull
    public static GitCrlfProblemsDetector detect(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(1);
        }
        if (files == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(2);
        }
        GitCrlfProblemsDetector gitCrlfProblemsDetector = new GitCrlfProblemsDetector(project, git, files);
        if (gitCrlfProblemsDetector == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(3);
        }
        return gitCrlfProblemsDetector;
    }

    private GitCrlfProblemsDetector(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> files) {
        Map<VirtualFile, Collection<VirtualFile>> crlfFilesByRoots;
        if (project == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(4);
        }
        if (git == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(5);
        }
        if (files == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(6);
        }
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
        this.myGit = git;
        Map<VirtualFile, List<VirtualFile>> filesByRoots = GitUtil.sortFilesByGitRootIgnoringMissing(project, files);
        boolean shouldWarn = false;
        Collection<VirtualFile> rootsWithIncorrectAutoCrlf = this.getRootsWithIncorrectAutoCrlf(filesByRoots);
        if (!rootsWithIncorrectAutoCrlf.isEmpty() && !(crlfFilesByRoots = GitCrlfProblemsDetector.findFilesWithCrlf(filesByRoots, rootsWithIncorrectAutoCrlf)).isEmpty()) {
            Map<VirtualFile, Collection<VirtualFile>> crlfFilesWithoutAttrsByRoots = this.findFilesWithoutAttrs(crlfFilesByRoots);
            shouldWarn = !crlfFilesWithoutAttrsByRoots.isEmpty();
        }
        this.myShouldWarn = shouldWarn;
    }

    private Map<VirtualFile, Collection<VirtualFile>> findFilesWithoutAttrs(Map<VirtualFile, Collection<VirtualFile>> filesByRoots) {
        HashMap<VirtualFile, Collection<VirtualFile>> filesWithoutAttrsByRoot = new HashMap<VirtualFile, Collection<VirtualFile>>();
        for (Map.Entry<VirtualFile, Collection<VirtualFile>> entry : filesByRoots.entrySet()) {
            Collection<VirtualFile> files;
            VirtualFile root = entry.getKey();
            Collection<VirtualFile> filesWithoutAttrs = this.findFilesWithoutAttrs(root, files = entry.getValue());
            if (filesWithoutAttrs.isEmpty()) continue;
            filesWithoutAttrsByRoot.put(root, filesWithoutAttrs);
        }
        return filesWithoutAttrsByRoot;
    }

    @NotNull
    private Collection<VirtualFile> findFilesWithoutAttrs(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) {
        GitRepository repository;
        if (root == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(7);
        }
        if (files == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(8);
        }
        if ((repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root)) == null) {
            LOG.warn("Repository is null for " + root);
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GitCrlfProblemsDetector.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> interestingAttributes = Arrays.asList(GitAttribute.TEXT.getName(), GitAttribute.CRLF.getName());
        GitCommandResult result2 = this.myGit.checkAttr(repository, interestingAttributes, files);
        if (!result2.success()) {
            LOG.warn(String.format("Couldn't git check-attr. Attributes: %s, files: %s", interestingAttributes, files));
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GitCrlfProblemsDetector.$$$reportNull$$$0(10);
            }
            return list;
        }
        GitCheckAttrParser parser = GitCheckAttrParser.parse(result2.getOutput());
        Map<String, Collection<GitAttribute>> attributes = parser.getAttributes();
        ArrayList<VirtualFile> filesWithoutAttrs = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            ProgressIndicatorProvider.checkCanceled();
            String relativePath = FileUtil.getRelativePath((String)root.getPath(), (String)virtualFile.getPath(), (char)'/');
            Collection<GitAttribute> attrs = attributes.get(relativePath);
            if (attrs != null && (attrs.contains((Object)GitAttribute.TEXT) || attrs.contains((Object)GitAttribute.CRLF))) continue;
            filesWithoutAttrs.add(virtualFile);
        }
        ArrayList<VirtualFile> arrayList = filesWithoutAttrs;
        if (arrayList == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static Map<VirtualFile, Collection<VirtualFile>> findFilesWithCrlf(@NotNull Map<VirtualFile, List<VirtualFile>> allFilesByRoots, @NotNull Collection<VirtualFile> rootsWithIncorrectAutoCrlf) {
        if (allFilesByRoots == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(12);
        }
        if (rootsWithIncorrectAutoCrlf == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(13);
        }
        HashMap<VirtualFile, Collection<VirtualFile>> filesWithCrlfByRoots = new HashMap<VirtualFile, Collection<VirtualFile>>();
        for (Map.Entry<VirtualFile, List<VirtualFile>> entry : allFilesByRoots.entrySet()) {
            Collection<VirtualFile> filesWithCrlf;
            VirtualFile root = entry.getKey();
            List<VirtualFile> files = entry.getValue();
            if (!rootsWithIncorrectAutoCrlf.contains(root) || (filesWithCrlf = GitCrlfProblemsDetector.findFilesWithCrlf(files)).isEmpty()) continue;
            filesWithCrlfByRoots.put(root, filesWithCrlf);
        }
        HashMap<VirtualFile, Collection<VirtualFile>> hashMap = filesWithCrlfByRoots;
        if (hashMap == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    @NotNull
    private static Collection<VirtualFile> findFilesWithCrlf(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(15);
        }
        ArrayList<VirtualFile> filesWithCrlf = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            ProgressIndicatorProvider.checkCanceled();
            String separator = LoadTextUtil.detectLineSeparator((VirtualFile)virtualFile, (boolean)true);
            if (!CRLF.equals(separator)) continue;
            filesWithCrlf.add(virtualFile);
        }
        ArrayList<VirtualFile> arrayList = filesWithCrlf;
        if (arrayList == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private Collection<VirtualFile> getRootsWithIncorrectAutoCrlf(@NotNull Map<VirtualFile, List<VirtualFile>> filesByRoots) {
        if (filesByRoots == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(17);
        }
        ArrayList<VirtualFile> rootsWithIncorrectAutoCrlf = new ArrayList<VirtualFile>();
        for (Map.Entry<VirtualFile, List<VirtualFile>> entry : filesByRoots.entrySet()) {
            VirtualFile root = entry.getKey();
            boolean autocrlf = this.isAutoCrlfSetRight(root);
            if (autocrlf) continue;
            rootsWithIncorrectAutoCrlf.add(root);
        }
        ArrayList<VirtualFile> arrayList = rootsWithIncorrectAutoCrlf;
        if (arrayList == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private boolean isAutoCrlfSetRight(@NotNull VirtualFile root) {
        GitRepository repository;
        if (root == null) {
            GitCrlfProblemsDetector.$$$reportNull$$$0(19);
        }
        if ((repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root)) == null) {
            LOG.warn("Repository is null for " + root);
            return true;
        }
        GitCommandResult result2 = this.myGit.config(repository, "core.autocrlf");
        String value = result2.getOutputAsJoinedString();
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("input");
    }

    public boolean shouldWarn() {
        return this.myShouldWarn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/crlf/GitCrlfProblemsDetector";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFilesByRoots";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsWithIncorrectAutoCrlf";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesByRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/crlf/GitCrlfProblemsDetector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithoutAttrs";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithCrlf";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsWithIncorrectAutoCrlf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithoutAttrs";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithCrlf";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRootsWithIncorrectAutoCrlf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAutoCrlfSetRight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

