/*
 * Decompiled with CFR 0.152.
 */
package git4idea.diff;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitVcs;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitDiffProvider
implements DiffProvider,
DiffMixin {
    private final Project myProject;

    public GitDiffProvider(@NotNull Project project) {
        if (project == null) {
            GitDiffProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(VirtualFile file) {
        if (file.isDirectory()) {
            return null;
        }
        try {
            return GitHistoryUtils.getCurrentRevision(this.myProject, VcsUtil.getFilePath((String)file.getPath()), "HEAD");
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public VcsRevisionDescription getCurrentRevisionDescription(VirtualFile file) {
        if (file.isDirectory()) {
            return null;
        }
        try {
            return GitHistoryUtils.getCurrentRevisionDescription(this.myProject, VcsUtil.getFilePath((String)file.getPath()));
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public ItemLatestState getLastRevision(VirtualFile file) {
        if (file.isDirectory()) {
            return null;
        }
        if (!this.hasGoodFileStatus(file)) {
            return null;
        }
        try {
            return GitHistoryUtils.getLastRevision(this.myProject, VcsUtil.getFilePath((String)file.getPath()));
        }
        catch (VcsException e) {
            return null;
        }
    }

    private boolean hasGoodFileStatus(VirtualFile file) {
        FileStatus status = ChangeListManager.getInstance((Project)this.myProject).getStatus(file);
        return status == FileStatus.NOT_CHANGED || status == FileStatus.DELETED || status == FileStatus.MODIFIED || status == FileStatus.MERGED_WITH_CONFLICTS;
    }

    @Nullable
    public ContentRevision createCurrentFileContent(@NotNull VirtualFile file) {
        if (file == null) {
            GitDiffProvider.$$$reportNull$$$0(1);
        }
        if (file.isDirectory()) {
            return null;
        }
        if (GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(file) == null) {
            return null;
        }
        VcsRevisionNumber revisionNumber = this.getCurrentRevision(file);
        FilePath filePath = VcsUtil.getLastCommitPath((Project)this.myProject, (FilePath)VcsUtil.getFilePath((String)file.getPath()));
        return GitContentRevision.createRevision(filePath, revisionNumber, this.myProject, file.getCharset());
    }

    @Nullable
    public ContentRevision createFileContent(VcsRevisionNumber revisionNumber, VirtualFile selectedFile) {
        if (selectedFile.isDirectory()) {
            return null;
        }
        if (GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(selectedFile) == null) {
            return null;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)selectedFile);
        try {
            CommittedChangesProvider committedChangesProvider = GitVcs.getInstance(this.myProject).getCommittedChangesProvider();
            Pair pair = committedChangesProvider.getOneList(selectedFile, revisionNumber);
            if (pair != null) {
                return GitContentRevision.createRevision((FilePath)pair.getSecond(), revisionNumber, this.myProject, selectedFile.getCharset());
            }
        }
        catch (VcsException e) {
            GitVcs.getInstance(this.myProject).showErrors(Collections.singletonList(e), GitBundle.message("diff.find.error", selectedFile.getPresentableUrl()));
        }
        try {
            for (VcsFileRevision f : GitFileHistory.collectHistory(this.myProject, filePath, new String[0])) {
                GitFileRevision gitRevision = (GitFileRevision)f;
                if (!f.getRevisionNumber().equals(revisionNumber)) continue;
                return GitContentRevision.createRevision(gitRevision.getPath(), revisionNumber, this.myProject, selectedFile.getCharset());
            }
            GitContentRevision candidate = (GitContentRevision)GitContentRevision.createRevision(filePath, revisionNumber, this.myProject, selectedFile.getCharset());
            try {
                candidate.getContent();
                return candidate;
            }
            catch (VcsException vcsException) {
            }
        }
        catch (VcsException e) {
            GitVcs.getInstance(this.myProject).showErrors(Collections.singletonList(e), GitBundle.message("diff.find.error", selectedFile.getPresentableUrl()));
        }
        return null;
    }

    public ItemLatestState getLastRevision(FilePath filePath) {
        if (filePath.isDirectory()) {
            return null;
        }
        VirtualFile vf = filePath.getVirtualFile();
        if (vf != null && !this.hasGoodFileStatus(vf)) {
            return null;
        }
        try {
            return GitHistoryUtils.getLastRevision(this.myProject, filePath);
        }
        catch (VcsException e) {
            return null;
        }
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "git4idea/diff/GitDiffProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createCurrentFileContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

