/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.rt.execution;

import org.jetbrains.annotations.Nullable;

public class ForkedDebuggerConfiguration {
    private final int myForkSocketPort;
    private final int myDebugPort;

    private ForkedDebuggerConfiguration(int forkSocketPort, int debugPort) {
        this.myForkSocketPort = forkSocketPort;
        this.myDebugPort = debugPort;
    }

    public int getForkSocketPort() {
        return this.myForkSocketPort;
    }

    public int getDebugPort() {
        return this.myDebugPort;
    }

    @Nullable
    public static ForkedDebuggerConfiguration parse(@Nullable String jvmAgentSetup) {
        int forkSocketIndex;
        if (jvmAgentSetup != null && jvmAgentSetup.startsWith("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=") && (forkSocketIndex = jvmAgentSetup.indexOf("-forkSocket")) > 0) {
            try {
                int forkSocketPort = Integer.parseInt(jvmAgentSetup.substring(forkSocketIndex + "-forkSocket".length()));
                int debugPort = Integer.parseInt(jvmAgentSetup.substring("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=".length(), forkSocketIndex - 1));
                return new ForkedDebuggerConfiguration(forkSocketPort, debugPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getJvmAgentSetup(boolean isJdk9orLater) {
        return "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + (isJdk9orLater ? "127.0.0.1:" : "") + this.myDebugPort;
    }
}

