/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.statistic.eventLog;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventsKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.components.ReportValue;
import com.intellij.openapi.project.Project;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0002J,\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0011H\u0014JJ\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\"\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ$\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\t2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\"\u0010 \u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0002J\u0019\u0010!\u001a\u0004\u0018\u00010\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\b\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/configurationStore/statistic/eventLog/FeatureUsageSettingsEventPrinter;", "", "recordDefault", "", "(Z)V", "addProjectOptions", "", "content", "Ljava/util/HashMap;", "", "isDefaultProject", "projectHash", "logConfig", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "data", "", "logConfigValue", "accessor", "Lcom/intellij/serialization/MutableAccessor;", "state", "type", "reportValue", "hash", "componentName", "logConfigurationState", "project", "Lcom/intellij/openapi/project/Project;", "logDefaultConfigurationState", "clazz", "Ljava/lang/Class;", "logSettingCollectorWasInvoked", "toHash", "toHash$intellij_platform_configurationStore_impl", "intellij.platform.configurationStore.impl"})
public class FeatureUsageSettingsEventPrinter {
    private final boolean recordDefault;

    public final void logDefaultConfigurationState(@NotNull String componentName, @NotNull Class<?> clazz, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        try {
            if (this.recordDefault) {
                Object object = XmlSerializer.getJdomSerializer().getDefaultSerializationFilter().getDefaultValue(clazz);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jdomSerializer.getDefaul\u2026().getDefaultValue(clazz)");
                Object object2 = object;
                this.logConfigurationState(componentName, object2, project);
            } else if (Intrinsics.areEqual(clazz, Element.class) ^ true && PluginInfoDetectorKt.getPluginInfo(clazz).isDevelopedByJetBrains()) {
                FeatureUsageSettingsEventsKt.access$getRecordedComponents$p().add(componentName);
                Project project2 = project;
                boolean isDefaultProject = project2 != null && project2.isDefault();
                String hash = !isDefaultProject ? this.toHash$intellij_platform_configurationStore_impl(project) : null;
                this.logSettingCollectorWasInvoked(componentName, isDefaultProject, hash);
            }
        }
        catch (Exception e) {
            FeatureUsageSettingsEventsKt.access$getLOG$p().warn("Cannot initialize default settings for '" + componentName + '\'');
        }
    }

    public final void logConfigurationState(@NotNull String componentName, @Nullable Object state, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        if (state == null || state instanceof Element) {
            return;
        }
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(state.getClass());
        if (!pluginInfo.isDevelopedByJetBrains()) {
            return;
        }
        List list = BeanBinding.getAccessors(state.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"BeanBinding.getAccessors(state.javaClass)");
        List accessors = list;
        if (accessors.isEmpty()) {
            return;
        }
        FeatureUsageSettingsEventsKt.access$getRecordedComponents$p().add(componentName);
        String eventId = this.recordDefault ? "option" : "not.default";
        Project project2 = project;
        boolean isDefaultProject = project2 != null && project2.isDefault();
        String hash = !isDefaultProject ? this.toHash$intellij_platform_configurationStore_impl(project) : null;
        Iterator iterator = accessors.iterator();
        while (iterator.hasNext()) {
            boolean reportValue;
            Type type;
            MutableAccessor accessor;
            MutableAccessor mutableAccessor = accessor = (MutableAccessor)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)mutableAccessor, (String)"accessor");
            Intrinsics.checkExpressionValueIsNotNull((Object)mutableAccessor.getGenericType(), (String)"accessor.genericType");
            if (type == Boolean.TYPE) {
                this.logConfigValue(accessor, state, "bool", eventId, isDefaultProject, true, hash, componentName);
                continue;
            }
            if (type == Integer.TYPE || type == Long.TYPE) {
                reportValue = accessor.getAnnotation(ReportValue.class) != null;
                this.logConfigValue(accessor, state, "int", eventId, isDefaultProject, reportValue, hash, componentName);
                continue;
            }
            if (type != Float.TYPE && type != Double.TYPE) continue;
            reportValue = accessor.getAnnotation(ReportValue.class) != null;
            this.logConfigValue(accessor, state, "float", eventId, isDefaultProject, reportValue, hash, componentName);
        }
        if (!this.recordDefault) {
            this.logSettingCollectorWasInvoked(componentName, isDefaultProject, hash);
        }
    }

    private final void logConfigValue(MutableAccessor accessor, Object state, String type, String eventId, boolean isDefaultProject, boolean reportValue, String hash, String componentName) {
        boolean isDefault;
        Object value = accessor.readUnsafe(state);
        boolean bl = isDefault = !XmlSerializer.getJdomSerializer().getDefaultSerializationFilter().accepts((Accessor)accessor, state);
        if (!isDefault || this.recordDefault) {
            Set set = FeatureUsageSettingsEventsKt.access$getRecordedOptionNames$p();
            String string = accessor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"accessor.name");
            set.add(string);
            HashMap<String, Object> content = new HashMap<String, Object>();
            ((Map)content).put("type", type);
            ((Map)content).put("component", componentName);
            Map map = content;
            String string2 = accessor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"accessor.name");
            map.put("name", string2);
            if (reportValue) {
                Map map2 = content;
                Object object = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"value");
                map2.put("value", object);
            }
            if (this.recordDefault) {
                ((Map)content).put("default", isDefault);
            }
            this.addProjectOptions(content, isDefaultProject, hash);
            this.logConfig(FeatureUsageSettingsEventsKt.access$getGROUP$p(), eventId, (Map<String, ? extends Object>)content);
        }
    }

    private final void addProjectOptions(HashMap<String, Object> content, boolean isDefaultProject, String projectHash) {
        block1: {
            block0: {
                if (!isDefaultProject) break block0;
                ((Map)content).put("default_project", true);
                break block1;
            }
            String string = projectHash;
            if (string == null) break block1;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            ((Map)content).put("project", projectHash);
        }
    }

    protected void logConfig(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        FeatureUsageLogger.INSTANCE.logState(group, eventId, data);
    }

    private final void logSettingCollectorWasInvoked(String componentName, boolean isDefaultProject, String projectHash) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        ((Map)content).put("component", componentName);
        this.addProjectOptions(content, isDefaultProject, projectHash);
        this.logConfig(FeatureUsageSettingsEventsKt.access$getGROUP$p(), "invoked", (Map<String, ? extends Object>)content);
    }

    @Nullable
    public final String toHash$intellij_platform_configurationStore_impl(@Nullable Project project) {
        Project project2 = project;
        if (project2 != null) {
            Project project3 = project2;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project3;
            boolean bl3 = false;
            return StatisticsUtilKt.getProjectId((Project)project);
        }
        return null;
    }

    public FeatureUsageSettingsEventPrinter(boolean recordDefault) {
        this.recordDefault = recordDefault;
    }
}

