/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubParseException;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Tag(value="server")
public class GithubServerPath {
    public static final String DEFAULT_HOST = "github.com";
    public static final GithubServerPath DEFAULT_SERVER = new GithubServerPath("github.com");
    private static final String API_PREFIX = "api.";
    private static final String ENTERPRISE_API_SUFFIX = "/api/v3";
    @Attribute(value="useHttp")
    @Nullable
    private final Boolean myUseHttp;
    @Attribute(value="host")
    @NotNull
    private final String myHost;
    @Attribute(value="port")
    @Nullable
    private final Integer myPort;
    @Attribute(value="suffix")
    @Nullable
    private final String mySuffix;
    private static final Pattern URL_REGEX = Pattern.compile("^(https?://)?([^/?:]+)(:(\\d+))?((/[^/?#]+)*)?/?", 2);

    public GithubServerPath() {
        this(null, "", null, null);
    }

    public GithubServerPath(@NonNls @NotNull String host) {
        if (host == null) {
            GithubServerPath.$$$reportNull$$$0(0);
        }
        this(null, host, null, null);
    }

    public GithubServerPath(@Nullable Boolean useHttp, @NonNls @NotNull String host, @Nullable Integer port, @NonNls @Nullable String suffix) {
        if (host == null) {
            GithubServerPath.$$$reportNull$$$0(1);
        }
        this.myUseHttp = useHttp;
        this.myHost = StringUtil.toLowerCase((String)host);
        this.myPort = port;
        this.mySuffix = suffix;
    }

    @NotNull
    public String getSchema() {
        String string = this.myUseHttp == null || this.myUseHttp == false ? "https" : "http";
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Integer getPort() {
        return this.myPort;
    }

    @Nullable
    public String getSuffix() {
        return this.mySuffix;
    }

    public boolean matches(@NotNull String gitRemoteUrl) {
        if (gitRemoteUrl == null) {
            GithubServerPath.$$$reportNull$$$0(4);
        }
        String url = GithubUrlUtil.removePort(GithubUrlUtil.removeProtocolPrefix(gitRemoteUrl));
        return StringUtil.startsWithIgnoreCase((String)url, (String)(this.myHost + StringUtil.notNullize((String)this.mySuffix)));
    }

    @NotNull
    public static GithubServerPath from(@NotNull String uri) throws GithubParseException {
        Integer port;
        Matcher matcher;
        if (uri == null) {
            GithubServerPath.$$$reportNull$$$0(5);
        }
        if (!(matcher = URL_REGEX.matcher(uri)).matches()) {
            throw new GithubParseException("Not a valid URL");
        }
        String schema = matcher.group(1);
        Boolean httpSchema = schema == null || schema.isEmpty() ? null : Boolean.valueOf(schema.equalsIgnoreCase("http://"));
        String host = matcher.group(2);
        if (host == null) {
            throw new GithubParseException("Empty host");
        }
        String portGroup = matcher.group(4);
        if (portGroup == null) {
            port = null;
        } else {
            try {
                port = Integer.parseInt(portGroup);
            }
            catch (NumberFormatException e) {
                throw new GithubParseException("Invalid port format");
            }
        }
        String path = StringUtil.nullize((String)matcher.group(5));
        GithubServerPath githubServerPath = new GithubServerPath(httpSchema, host, port, path);
        if (githubServerPath == null) {
            GithubServerPath.$$$reportNull$$$0(6);
        }
        return githubServerPath;
    }

    @NotNull
    public String toUrl() {
        String string = this.getSchemaUrlPart() + this.myHost + this.getPortUrlPart() + StringUtil.notNullize((String)this.mySuffix);
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String toApiUrl() {
        StringBuilder builder = new StringBuilder(this.getSchemaUrlPart());
        if (this.myHost.equalsIgnoreCase(DEFAULT_HOST)) {
            builder.append(API_PREFIX).append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix));
        } else {
            builder.append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix)).append(ENTERPRISE_API_SUFFIX);
        }
        String string = builder.toString();
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String toString() {
        String schema = this.myUseHttp != null ? this.getSchemaUrlPart() : "";
        return schema + this.myHost + this.getPortUrlPart() + StringUtil.notNullize((String)this.mySuffix);
    }

    @NotNull
    private String getPortUrlPart() {
        String string = this.myPort != null ? ":" + this.myPort.toString() : "";
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private String getSchemaUrlPart() {
        String string = this.getSchema() + "://";
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubServerPath)) {
            return false;
        }
        GithubServerPath path = (GithubServerPath)o;
        return Objects.equals(this.myUseHttp, path.myUseHttp) && Objects.equals(this.myHost, path.myHost) && Objects.equals(this.myPort, path.myPort) && Objects.equals(this.mySuffix, path.mySuffix);
    }

    public int hashCode() {
        return Objects.hash(this.myUseHttp, this.myHost, this.myPort, this.mySuffix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/api/GithubServerPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRemoteUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/api/GithubServerPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toApiUrl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPortUrlPart";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaUrlPart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

