/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.accounts.AccountRemovedListener;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManagerKt;

@State(name="GithubAccounts", storages={@Storage(value="github.xml"), @Storage(deprecated=true, value="github_settings.xml")})
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0001\u0018\u0000 \u001c2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0003J\u001b\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016R7\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "passwordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "(Lcom/intellij/ide/passwordSafe/PasswordSafe;)V", "<set-?>", "", "accounts", "getAccounts", "()Ljava/util/Set;", "setAccounts", "(Ljava/util/Set;)V", "accounts$delegate", "Lkotlin/properties/ReadWriteProperty;", "accountRemoved", "", "account", "getState", "()[Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getTokenForAccount", "", "loadState", "state", "([Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;)V", "updateAccountToken", "token", "Companion", "intellij.vcs.github"})
public final class GithubAccountManager
implements PersistentStateComponent<GithubAccount[]> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadWriteProperty accounts$delegate;
    private final PasswordSafe passwordSafe;
    private static final Logger LOG;
    @NotNull
    private static final Topic<AccountRemovedListener> ACCOUNT_REMOVED_TOPIC;
    @NotNull
    private static final Topic<AccountTokenChangedListener> ACCOUNT_TOKEN_CHANGED_TOPIC;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GithubAccountManager.class), "accounts", "getAccounts()Ljava/util/Set;"))};
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GithubAccountManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Githu\u2026countManager::class.java)");
        LOG = logger;
        ACCOUNT_REMOVED_TOPIC = new Topic("GITHUB_ACCOUNT_REMOVED", AccountRemovedListener.class);
        ACCOUNT_TOKEN_CHANGED_TOPIC = new Topic("GITHUB_ACCOUNT_TOKEN_CHANGED", AccountTokenChangedListener.class);
    }

    @NotNull
    public final Set<GithubAccount> getAccounts() {
        return (Set)this.accounts$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setAccounts(@NotNull Set<? extends GithubAccount> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.accounts$delegate.setValue((Object)this, $$delegatedProperties[0], set);
    }

    private final void accountRemoved(GithubAccount account) {
        this.updateAccountToken(account, null);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ((AccountRemovedListener)application.getMessageBus().syncPublisher(ACCOUNT_REMOVED_TOPIC)).accountRemoved(account);
    }

    public final void updateAccountToken(@NotNull GithubAccount account, @Nullable String token) {
        Credentials credentials;
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        PasswordSafe passwordSafe = this.passwordSafe;
        String string = account.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"account.id");
        CredentialAttributes credentialAttributes = GithubAccountManagerKt.access$createCredentialAttributes(string);
        String string2 = token;
        if (string2 != null) {
            String string3 = string2;
            CredentialAttributes credentialAttributes2 = credentialAttributes;
            PasswordSafe passwordSafe2 = passwordSafe;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            String string4 = account.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"account.id");
            Credentials credentials2 = GithubAccountManagerKt.access$createCredentials(string4, it);
            passwordSafe = passwordSafe2;
            credentialAttributes = credentialAttributes2;
            credentials = credentials2;
        } else {
            credentials = null;
        }
        passwordSafe.set(credentialAttributes, credentials);
        LOG.debug((token == null ? "Cleared" : "Updated") + " OAuth token for account: " + account);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ((AccountTokenChangedListener)application.getMessageBus().syncPublisher(ACCOUNT_TOKEN_CHANGED_TOPIC)).tokenChanged(account);
    }

    @Nullable
    public final String getTokenForAccount(@NotNull GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        String string = account.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"account.id");
        Credentials credentials = this.passwordSafe.get(GithubAccountManagerKt.access$createCredentialAttributes(string));
        return credentials != null ? credentials.getPasswordAsString() : null;
    }

    @NotNull
    public GithubAccount[] getState() {
        Collection $this$toTypedArray$iv = this.getAccounts();
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        GithubAccount[] githubAccountArray = thisCollection$iv.toArray(new GithubAccount[0]);
        if (githubAccountArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return githubAccountArray;
    }

    public void loadState(@NotNull GithubAccount[] state2) {
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        this.setAccounts(ArraysKt.toHashSet((Object[])state2));
    }

    /*
     * WARNING - void declaration
     */
    public GithubAccountManager(@NotNull PasswordSafe passwordSafe) {
        void initialValue$iv;
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)passwordSafe, (String)"passwordSafe");
        this.passwordSafe = passwordSafe;
        Delegates delegates = Delegates.INSTANCE;
        GithubAccountManager githubAccountManager = this;
        boolean bl = false;
        Set set2 = set = SetsKt.emptySet();
        boolean $i$f$observable = false;
        set = (ReadWriteProperty)new ObservableProperty<Set<? extends GithubAccount>>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ GithubAccountManager this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = githubAccountManager;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void $this$forEach$iv;
                void newValue2;
                void $this$filterTo$iv$iv;
                void oldValue2;
                Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                Set set = (Set)newValue;
                Set set2 = (Set)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                Iterable $this$filter$iv = (Iterable)oldValue2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    GithubAccount it = (GithubAccount)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!newValue2.contains(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                GithubAccountManager githubAccountManager = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    GithubAccount p1 = (GithubAccount)element$iv;
                    boolean bl3 = false;
                    GithubAccountManager.access$accountRemoved(githubAccountManager, p1);
                }
                GithubAccountManager.access$getLOG$cp().debug("Account list changed to: " + newValue2.toString());
            }
        };
        githubAccountManager.accounts$delegate = set;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(PasswordSafeSettings.TOPIC, (Object)new PasswordSafeSettingsListener(){

            public void credentialStoreCleared() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                Object object = application.getMessageBus().syncPublisher(Companion.getACCOUNT_TOKEN_CHANGED_TOPIC());
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026OUNT_TOKEN_CHANGED_TOPIC)");
                AccountTokenChangedListener publisher = (AccountTokenChangedListener)object;
                Iterable $this$forEach$iv = this.getAccounts();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GithubAccount p1 = (GithubAccount)element$iv;
                    boolean bl = false;
                    publisher.tokenChanged(p1);
                }
            }
        });
    }

    public static final /* synthetic */ void access$accountRemoved(GithubAccountManager $this, GithubAccount account) {
        $this.accountRemoved(account);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @NotNull
    public static final Topic<AccountRemovedListener> getACCOUNT_REMOVED_TOPIC() {
        Companion companion = Companion;
        return ACCOUNT_REMOVED_TOPIC;
    }

    @NotNull
    public static final Topic<AccountTokenChangedListener> getACCOUNT_TOKEN_CHANGED_TOPIC() {
        Companion companion = Companion;
        return ACCOUNT_TOKEN_CHANGED_TOPIC;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R*\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR*\u0010\n\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\tR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager$Companion;", "", "()V", "ACCOUNT_REMOVED_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/jetbrains/plugins/github/authentication/accounts/AccountRemovedListener;", "kotlin.jvm.PlatformType", "ACCOUNT_REMOVED_TOPIC$annotations", "getACCOUNT_REMOVED_TOPIC", "()Lcom/intellij/util/messages/Topic;", "ACCOUNT_TOKEN_CHANGED_TOPIC", "Lorg/jetbrains/plugins/github/authentication/accounts/AccountTokenChangedListener;", "ACCOUNT_TOKEN_CHANGED_TOPIC$annotations", "getACCOUNT_TOKEN_CHANGED_TOPIC", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createAccount", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "name", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void ACCOUNT_REMOVED_TOPIC$annotations() {
        }

        @NotNull
        public final Topic<AccountRemovedListener> getACCOUNT_REMOVED_TOPIC() {
            return ACCOUNT_REMOVED_TOPIC;
        }

        @JvmStatic
        public static /* synthetic */ void ACCOUNT_TOKEN_CHANGED_TOPIC$annotations() {
        }

        @NotNull
        public final Topic<AccountTokenChangedListener> getACCOUNT_TOKEN_CHANGED_TOPIC() {
            return ACCOUNT_TOKEN_CHANGED_TOPIC;
        }

        @NotNull
        public final GithubAccount createAccount(@NotNull String name, @NotNull GithubServerPath server) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            return new GithubAccount(name, server);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

