/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonWidgetSuppressor;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.widget.JsonSchemaStatusPopup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaStatusWidget
extends EditorBasedStatusBarPopup {
    private static final String JSON_SCHEMA_BAR = "JSON: ";
    private static final String JSON_SCHEMA_BAR_OTHER_FILES = "Schema: ";
    private static final String JSON_SCHEMA_TOOLTIP = "JSON Schema: ";
    private static final String JSON_SCHEMA_TOOLTIP_OTHER_FILES = "Validated by JSON Schema: ";
    private final SynchronizedClearableLazy<JsonSchemaService> myServiceLazy;
    private static final String ID = "JSONSchemaSelector";
    private static final AtomicBoolean myIsNotified = new AtomicBoolean(false);
    private final Runnable myUpdateCallback = () -> {
        this.update();
        myIsNotified.set(false);
    };

    JsonSchemaStatusWidget(Project project) {
        super(project);
        this.myServiceLazy = new SynchronizedClearableLazy(() -> {
            if (!project.isDisposed()) {
                JsonSchemaService myService = JsonSchemaService.Impl.get(project);
                myService.registerRemoteUpdateCallback(this.myUpdateCallback);
                myService.registerResetAction(this.myUpdateCallback);
                return myService;
            }
            return null;
        });
    }

    @Nullable
    private JsonSchemaService getService() {
        return (JsonSchemaService)this.myServiceLazy.getValue();
    }

    private boolean hasAccessToSymbols() {
        return !DumbService.getInstance((Project)this.myProject).isDumb();
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        String bar;
        if (file == null) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(0);
            }
            return widgetState;
        }
        List enablers = JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensionList();
        if (enablers.stream().noneMatch(e -> e.isEnabledForFile(file) && e.shouldShowSwitcherWidget(file))) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(1);
            }
            return widgetState;
        }
        FileType fileType = file.getFileType();
        Language language = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
        boolean isJsonFile = language instanceof JsonLanguage;
        if (!this.hasAccessToSymbols()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.getDumbModeState((String)"JSON schema service", (String)(isJsonFile ? JSON_SCHEMA_BAR : JSON_SCHEMA_BAR_OTHER_FILES));
            if (widgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(2);
            }
            return widgetState;
        }
        List suppressors = JsonWidgetSuppressor.EXTENSION_POINT_NAME.getExtensionList();
        if (suppressors.stream().anyMatch(s -> s.suppressSwitcherWidget(file, this.myProject))) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(3);
            }
            return widgetState;
        }
        JsonSchemaService service = this.getService();
        if (service == null) {
            EditorBasedStatusBarPopup.WidgetState widgetState = JsonSchemaStatusWidget.getNoSchemaState();
            if (widgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(4);
            }
            return widgetState;
        }
        Collection<VirtualFile> schemaFiles = service.getSchemaFilesForFile(file);
        if (schemaFiles.size() == 0) {
            EditorBasedStatusBarPopup.WidgetState widgetState = JsonSchemaStatusWidget.getNoSchemaState();
            if (widgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(5);
            }
            return widgetState;
        }
        if (schemaFiles.size() != 1) {
            ArrayList<VirtualFile> userSchemas = new ArrayList<VirtualFile>();
            if (JsonSchemaStatusWidget.hasConflicts(userSchemas, service, file)) {
                MyWidgetState state = new MyWidgetState(JsonSchemaStatusWidget.createMessage(schemaFiles, service, "<br/>", "There are several JSON Schemas mapped to this file:<br/>", ""), schemaFiles.size() + " schemas (!)", true);
                state.setWarning(true);
                state.setConflict();
                MyWidgetState myWidgetState = state;
                if (myWidgetState == null) {
                    JsonSchemaStatusWidget.$$$reportNull$$$0(6);
                }
                return myWidgetState;
            }
            schemaFiles = userSchemas;
            if (schemaFiles.size() == 0) {
                EditorBasedStatusBarPopup.WidgetState widgetState = JsonSchemaStatusWidget.getNoSchemaState();
                if (widgetState == null) {
                    JsonSchemaStatusWidget.$$$reportNull$$$0(7);
                }
                return widgetState;
            }
        }
        VirtualFile schemaFile = schemaFiles.iterator().next();
        schemaFile = ((JsonSchemaServiceImpl)service).replaceHttpFileWithBuiltinIfNeeded(schemaFile);
        String tooltip = isJsonFile ? JSON_SCHEMA_TOOLTIP : JSON_SCHEMA_TOOLTIP_OTHER_FILES;
        String string = bar = isJsonFile ? JSON_SCHEMA_BAR : JSON_SCHEMA_BAR_OTHER_FILES;
        if (schemaFile instanceof HttpVirtualFile) {
            RemoteFileInfo info = ((HttpVirtualFile)schemaFile).getFileInfo();
            if (info == null) {
                EditorBasedStatusBarPopup.WidgetState widgetState = JsonSchemaStatusWidget.getDownloadErrorState(null);
                if (widgetState == null) {
                    JsonSchemaStatusWidget.$$$reportNull$$$0(8);
                }
                return widgetState;
            }
            switch (info.getState()) {
                case DOWNLOADING_NOT_STARTED: {
                    this.addDownloadingUpdateListener(info);
                    MyWidgetState myWidgetState = new MyWidgetState(tooltip + JsonSchemaStatusWidget.getSchemaFileDesc(schemaFile), bar + JsonSchemaStatusWidget.getPresentableNameForFile(schemaFile), true);
                    if (myWidgetState == null) {
                        JsonSchemaStatusWidget.$$$reportNull$$$0(9);
                    }
                    return myWidgetState;
                }
                case DOWNLOADING_IN_PROGRESS: {
                    this.addDownloadingUpdateListener(info);
                    MyWidgetState myWidgetState = new MyWidgetState("Download is scheduled or in progress", "Downloading JSON schema", false);
                    if (myWidgetState == null) {
                        JsonSchemaStatusWidget.$$$reportNull$$$0(10);
                    }
                    return myWidgetState;
                }
                case ERROR_OCCURRED: {
                    EditorBasedStatusBarPopup.WidgetState widgetState = JsonSchemaStatusWidget.getDownloadErrorState(info.getErrorMessage());
                    if (widgetState == null) {
                        JsonSchemaStatusWidget.$$$reportNull$$$0(11);
                    }
                    return widgetState;
                }
            }
        }
        if (!this.isValidSchemaFile(schemaFile)) {
            MyWidgetState state = new MyWidgetState("File is not a schema", "JSON schema error", true);
            state.setWarning(true);
            MyWidgetState myWidgetState = state;
            if (myWidgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(12);
            }
            return myWidgetState;
        }
        JsonSchemaFileProvider provider = service.getSchemaProvider(schemaFile);
        if (provider != null) {
            boolean preferRemoteSchemas = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isPreferRemoteSchemas();
            String remoteSource = provider.getRemoteSource();
            boolean useRemoteSource = preferRemoteSchemas && remoteSource != null && !JsonFileResolver.isSchemaUrl(remoteSource) && !remoteSource.endsWith("!");
            String providerName = useRemoteSource ? remoteSource : provider.getPresentableName();
            String shortName = StringUtil.trimEnd((String)StringUtil.trimEnd((String)providerName, (String)".json"), (String)"-schema");
            String name = useRemoteSource ? bar + new JsonSchemaInfo(remoteSource).getDescription() : (shortName.startsWith("JSON schema") ? shortName : bar + shortName);
            String kind = !useRemoteSource && (provider.getSchemaType() == SchemaType.embeddedSchema || provider.getSchemaType() == SchemaType.schema) ? " (bundled)" : "";
            MyWidgetState myWidgetState = new MyWidgetState(tooltip + providerName + kind, name, true);
            if (myWidgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(13);
            }
            return myWidgetState;
        }
        MyWidgetState myWidgetState = new MyWidgetState(tooltip + JsonSchemaStatusWidget.getSchemaFileDesc(schemaFile), bar + JsonSchemaStatusWidget.getPresentableNameForFile(schemaFile), true);
        if (myWidgetState == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(14);
        }
        return myWidgetState;
    }

    private void addDownloadingUpdateListener(@NotNull RemoteFileInfo info) {
        if (info == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(15);
        }
        info.addDownloadingListener((FileDownloadingListener)new FileDownloadingAdapter(){

            public void fileDownloaded(@NotNull VirtualFile localFile) {
                if (localFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                JsonSchemaStatusWidget.this.update();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                JsonSchemaStatusWidget.this.update();
            }

            public void downloadingCancelled() {
                JsonSchemaStatusWidget.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/jsonSchema/widget/JsonSchemaStatusWidget$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDownloaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private boolean isValidSchemaFile(@Nullable VirtualFile schemaFile) {
        if (schemaFile == null) {
            return false;
        }
        JsonSchemaService service = this.getService();
        return service != null && service.isSchemaFile(schemaFile) && service.isApplicableToFile(schemaFile);
    }

    @Nullable
    private static String extractNpmPackageName(@Nullable String path) {
        int trimIndex;
        if (path == null) {
            return null;
        }
        int idx = path.indexOf("node_modules");
        if (idx != -1 && (trimIndex = idx + "node_modules".length() + 1) < path.length()) {
            idx = StringUtil.indexOfAny((String)(path = path.substring(trimIndex)), (String)"\\/");
            if (idx != -1 && path.startsWith("@")) {
                idx = StringUtil.indexOfAny((String)path, (String)"\\/", (int)(idx + 1), (int)path.length());
            }
            if (idx != -1) {
                return path.substring(0, idx);
            }
        }
        return null;
    }

    @NotNull
    private static String getPresentableNameForFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(16);
        }
        if (schemaFile instanceof HttpVirtualFile) {
            String string = new JsonSchemaInfo(schemaFile.getUrl()).getDescription();
            if (string == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(17);
            }
            return string;
        }
        String nameWithoutExtension = schemaFile.getNameWithoutExtension();
        if (!JsonSchemaInfo.isVeryDumbName(nameWithoutExtension)) {
            String string = nameWithoutExtension;
            if (string == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(18);
            }
            return string;
        }
        String path = schemaFile.getPath();
        String npmPackageName = JsonSchemaStatusWidget.extractNpmPackageName(path);
        String string = npmPackageName != null ? npmPackageName : schemaFile.getName();
        if (string == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static EditorBasedStatusBarPopup.WidgetState getDownloadErrorState(@Nullable String message) {
        MyWidgetState state = new MyWidgetState("Error downloading schema" + (message == null ? "" : ": <br/>" + message), "JSON schema error", true);
        state.setWarning(true);
        MyWidgetState myWidgetState = state;
        if (myWidgetState == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(20);
        }
        return myWidgetState;
    }

    @NotNull
    private static EditorBasedStatusBarPopup.WidgetState getNoSchemaState() {
        MyWidgetState myWidgetState = new MyWidgetState("No JSON Schema defined", "No JSON schema", true);
        if (myWidgetState == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(21);
        }
        return myWidgetState;
    }

    @NotNull
    private static String getSchemaFileDesc(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(22);
        }
        if (schemaFile instanceof HttpVirtualFile) {
            String string = schemaFile.getPresentableUrl();
            if (string == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(23);
            }
            return string;
        }
        String npmPackageName = JsonSchemaStatusWidget.extractNpmPackageName(schemaFile.getPath());
        String string = schemaFile.getName() + (npmPackageName == null ? "" : " (Package: " + npmPackageName + ")");
        if (string == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    protected ListPopup createPopup(DataContext context) {
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (virtualFile == null) {
            return null;
        }
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        EditorBasedStatusBarPopup.WidgetState state = this.getWidgetState(virtualFile);
        if (!(state instanceof MyWidgetState)) {
            return null;
        }
        JsonSchemaService service = this.getService();
        if (service == null) {
            return null;
        }
        return JsonSchemaStatusPopup.createPopup(service, project, virtualFile, ((MyWidgetState)state).isWarning());
    }

    protected void registerCustomListeners() {
        class Listener
        implements DumbService.DumbModeListener {
            volatile boolean isDumbMode;

            Listener() {
            }

            public void enteredDumbMode() {
                this.isDumbMode = true;
                JsonSchemaStatusWidget.this.update();
            }

            public void exitDumbMode() {
                this.isDumbMode = false;
                JsonSchemaStatusWidget.this.update();
            }
        }
        Listener listener = new Listener();
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)listener);
    }

    protected void handleFileChange(VirtualFile file) {
        myIsNotified.set(false);
    }

    @NotNull
    protected StatusBarWidget createInstance(Project project) {
        JsonSchemaStatusWidget jsonSchemaStatusWidget = new JsonSchemaStatusWidget(project);
        if (jsonSchemaStatusWidget == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(25);
        }
        return jsonSchemaStatusWidget;
    }

    @NotNull
    public String ID() {
        if (ID == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(26);
        }
        return ID;
    }

    public void dispose() {
        JsonSchemaService service;
        JsonSchemaService jsonSchemaService = service = this.myServiceLazy.isInitialized() ? (JsonSchemaService)this.myServiceLazy.getValue() : null;
        if (service != null) {
            service.unregisterRemoteUpdateCallback(this.myUpdateCallback);
            service.unregisterResetAction(this.myUpdateCallback);
        }
        super.dispose();
    }

    private static String createMessage(@NotNull Collection<? extends VirtualFile> schemaFiles, @NotNull JsonSchemaService jsonSchemaService, @NotNull String separator, @NotNull String prefix, @NotNull String suffix) {
        if (schemaFiles == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(27);
        }
        if (jsonSchemaService == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(28);
        }
        if (separator == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(29);
        }
        if (prefix == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(30);
        }
        if (suffix == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(31);
        }
        List pairList = schemaFiles.stream().map(file -> jsonSchemaService.getSchemaProvider((VirtualFile)file)).filter(Objects::nonNull).map(provider -> Pair.create((Object)SchemaType.userSchema.equals((Object)provider.getSchemaType()), (Object)provider.getName())).collect(Collectors.toList());
        long numOfSystemSchemas = pairList.stream().filter(pair -> (Boolean)pair.getFirst() == false).count();
        if (pairList.size() == 2 && numOfSystemSchemas == 1L) {
            return null;
        }
        boolean withTypes = numOfSystemSchemas > 0L;
        return pairList.stream().map(pair -> JsonSchemaStatusWidget.formatName(withTypes, (Pair<Boolean, String>)pair)).collect(Collectors.joining(separator, prefix, suffix));
    }

    private static String formatName(boolean withTypes, Pair<Boolean, String> pair) {
        return "&nbsp;&nbsp;- " + (withTypes ? String.format("%s schema '%s'", Boolean.TRUE.equals(pair.getFirst()) ? "user" : "system", pair.getSecond()) : (String)pair.getSecond());
    }

    private static boolean hasConflicts(@NotNull Collection<VirtualFile> files, @NotNull JsonSchemaService service, @NotNull VirtualFile file) {
        if (files == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(32);
        }
        if (service == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(33);
        }
        if (file == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(34);
        }
        List<JsonSchemaFileProvider> providers = ((JsonSchemaServiceImpl)service).getProvidersForFile(file);
        for (JsonSchemaFileProvider provider : providers) {
            VirtualFile schemaFile;
            if (provider.getSchemaType() != SchemaType.userSchema || (schemaFile = provider.getSchemaFile()) == null) continue;
            files.add(schemaFile);
        }
        return files.size() > 1;
    }

    protected void afterVisibleUpdate(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        if (state == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(35);
        }
        if (!(state instanceof MyWidgetState) || !((MyWidgetState)state).conflict) {
            myIsNotified.set(false);
            return;
        }
        if (myIsNotified.get()) {
            return;
        }
        myIsNotified.set(true);
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        alarm.addRequest(() -> {
            JComponent label = HintUtil.createErrorLabel((String)("<b>JSON Schema conflicting mappings</b><br/><br/>" + ((MyWidgetState)state).getTooltip()));
            BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder(label);
            JComponent statusBarComponent = this.getComponent();
            Balloon balloon = builder.setCalloutShift(statusBarComponent.getHeight() / 2).setDisposable((Disposable)this).setFillColor(HintUtil.getErrorColor()).setHideOnClickOutside(true).createBalloon();
            balloon.showInCenterOf(statusBarComponent);
        }, 500, ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/widget/JsonSchemaStatusWidget";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFiles";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonSchemaService";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/widget/JsonSchemaStatusWidget";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameForFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadErrorState";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoSchemaState";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFileDesc";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDownloadingUpdateListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableNameForFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFileDesc";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createMessage";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasConflicts";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "afterVisibleUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyWidgetState
    extends EditorBasedStatusBarPopup.WidgetState {
        boolean warning = false;
        boolean conflict = false;

        MyWidgetState(String toolTip, String text, boolean actionEnabled) {
            super(toolTip, text, actionEnabled);
        }

        public boolean isWarning() {
            return this.warning;
        }

        public void setWarning(boolean warning) {
            this.warning = warning;
            this.setIcon(warning ? AllIcons.General.Warning : null);
        }

        private void setConflict() {
            this.conflict = true;
        }

        private String getTooltip() {
            return this.toolTip;
        }
    }
}

