/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unused;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorInspection;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.findUsages.PropertySearcher;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedPropertyInspection
extends PropertiesInspectionBase
implements ResourceBundleEditorInspection {
    private static final Logger LOG = Logger.getInstance(UnusedPropertyInspection.class);

    @NotNull
    public String getDisplayName() {
        String string = PropertiesBundle.message("unused.property.inspection.display.name", new Object[0]);
        if (string == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("UnusedProperty" == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(1);
        }
        return "UnusedProperty";
    }

    @Nullable
    private static GlobalSearchScope getWidestUseScope(@Nullable String key, @NotNull Project project, @NotNull Module ownModule) {
        if (project == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(2);
        }
        if (ownModule == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(3);
        }
        if (key == null) {
            return null;
        }
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (IProperty property : PropertiesImplUtil.findPropertiesByKey(project, key)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)property.getPsiElement());
            if (module == null) {
                return GlobalSearchScope.allScope((Project)project);
            }
            if (module == ownModule) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return null;
        }
        return GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])modules.stream().map(Module::getModuleWithDependentsScope).toArray(GlobalSearchScope[]::new)));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiFile file;
        Module module;
        if (holder == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(4);
        }
        if (session == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(file = session.getFile()))) == null) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            if (psiElementVisitor == null) {
                UnusedPropertyInspection.$$$reportNull$$$0(6);
            }
            return psiElementVisitor;
        }
        final UnusedPropertiesSearchHelper helper = new UnusedPropertiesSearchHelper(module);
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!(element instanceof Property)) {
                    return;
                }
                Property property = (Property)element;
                if (UnusedPropertyInspection.isPropertyUsed(property, helper, isOnTheFly)) {
                    return;
                }
                ASTNode propertyNode = property.getNode();
                assert (propertyNode != null);
                ASTNode[] nodes = propertyNode.getChildren(null);
                Property key = nodes.length == 0 ? property : nodes[0].getPsi();
                LocalQuickFix fix = PropertiesQuickFixFactory.getInstance().createRemovePropertyLocalFix();
                holder.registerProblem((PsiElement)key, PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
            }
        };
        if (psiElementVisitor == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(7);
        }
        return psiElementVisitor;
    }

    @Override
    @NotNull
    public Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> buildPropertyGroupVisitor(@NotNull ResourceBundle resourceBundle) {
        Module module;
        if (resourceBundle == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(8);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)resourceBundle.getDefaultPropertiesFile().getContainingFile())) == null) {
            Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> function = x -> null;
            if (function == null) {
                UnusedPropertyInspection.$$$reportNull$$$0(9);
            }
            return function;
        }
        UnusedPropertiesSearchHelper helper = new UnusedPropertiesSearchHelper(module);
        Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> function = properties -> {
            ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray;
            if (!UnusedPropertyInspection.isPropertyUsed((Property)properties[0], helper, true)) {
                ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray2 = new ResourceBundleEditorProblemDescriptor[1];
                resourceBundleEditorProblemDescriptorArray = resourceBundleEditorProblemDescriptorArray2;
                resourceBundleEditorProblemDescriptorArray2[0] = new ResourceBundleEditorProblemDescriptor(ProblemHighlightType.LIKE_UNUSED_SYMBOL, PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]), new RemovePropertiesFromAllLocalesFix((Property)properties[0]));
            } else {
                resourceBundleEditorProblemDescriptorArray = null;
            }
            return resourceBundleEditorProblemDescriptorArray;
        };
        if (function == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(10);
        }
        return function;
    }

    private static boolean isPropertyUsed(@NotNull Property property, @NotNull UnusedPropertiesSearchHelper helper, boolean isOnTheFly) {
        ProgressIndicator original;
        if (property == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(11);
        }
        if (helper == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(12);
        }
        if ((original = ProgressManager.getInstance().getProgressIndicator()) != null) {
            if (original.isCanceled()) {
                return true;
            }
            original.setText(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
        }
        if (ImplicitPropertyUsageProvider.isImplicitlyUsed(property)) {
            return true;
        }
        String name = property.getName();
        if (name == null) {
            return true;
        }
        if (helper.getSearcher() != null && (name = helper.getSearcher().getKeyToSearch(name, property.getProject())) == null) {
            return true;
        }
        PsiSearchHelper searchHelper = helper.getSearchHelper();
        if (UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, helper.getOwnUseScope(), isOnTheFly, original)) {
            return true;
        }
        GlobalSearchScope widerScope = UnusedPropertyInspection.getWidestUseScope(property.getKey(), property.getProject(), helper.getModule());
        return widerScope != null && UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, widerScope, isOnTheFly, original);
    }

    private static boolean mayHaveUsages(@NotNull PsiElement property, @NotNull String name, @NotNull PsiSearchHelper psiSearchHelper, @NotNull GlobalSearchScope searchScope, boolean onTheFly, @Nullable ProgressIndicator indicator) {
        PsiSearchHelper.SearchCostResult cheapEnough;
        if (property == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(13);
        }
        if (name == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(14);
        }
        if (psiSearchHelper == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(16);
        }
        if ((cheapEnough = psiSearchHelper.isCheapEnoughToSearch(name, searchScope, null, indicator)) == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
            return false;
        }
        if (onTheFly && cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return true;
        }
        return ReferencesSearch.search((PsiElement)property, (SearchScope)searchScope, (boolean)false).findFirst() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unused/UnusedPropertyInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiSearchHelper";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unused/UnusedPropertyInspection";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPropertyGroupVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWidestUseScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildPropertyGroupVisitor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyUsed";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemovePropertiesFromAllLocalesFix
    implements QuickFix<ResourceBundleEditorProblemDescriptor> {
        private final SmartPsiElementPointer<Property> myRepresentativePointer;

        private RemovePropertiesFromAllLocalesFix(Property property) {
            this.myRepresentativePointer = SmartPointerManager.getInstance((Project)property.getProject()).createSmartPsiElementPointer((PsiElement)property);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("remove.property.intention.text", new Object[0]);
            if (string == null) {
                RemovePropertiesFromAllLocalesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ResourceBundleEditorProblemDescriptor descriptor) {
            Property element;
            if (project == null) {
                RemovePropertiesFromAllLocalesFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemovePropertiesFromAllLocalesFix.$$$reportNull$$$0(2);
            }
            if ((element = (Property)this.myRepresentativePointer.getElement()) == null) {
                return;
            }
            String key = element.getKey();
            if (key == null) {
                return;
            }
            PropertiesFile file = PropertiesImplUtil.getPropertiesFile(this.myRepresentativePointer.getContainingFile());
            LOG.assertTrue(file != null);
            file.getResourceBundle().getPropertiesFiles().stream().flatMap(f -> f.findPropertiesByKey(key).stream()).filter(Objects::nonNull).map(IProperty::getPsiElement).filter(arg_0 -> ((FileModificationService)FileModificationService.getInstance()).preparePsiElementForWrite(arg_0)).forEach(PsiElement::delete);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unused/UnusedPropertyInspection$RemovePropertiesFromAllLocalesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unused/UnusedPropertyInspection$RemovePropertiesFromAllLocalesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnusedPropertiesSearchHelper {
        private final GlobalSearchScope myOwnUseScope;
        private final Module myModule;
        private final PropertySearcher mySearcher;
        private final PsiSearchHelper mySearchHelper;

        UnusedPropertiesSearchHelper(Module module) {
            this.myOwnUseScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
            this.myModule = module;
            this.mySearcher = (PropertySearcher)ContainerUtil.find((Object[])Extensions.getRootArea().getExtensionPoint("com.intellij.referencesSearch").getExtensions(), (Condition)new FilteringIterator.InstanceOf(PropertySearcher.class));
            this.mySearchHelper = PsiSearchHelper.getInstance((Project)module.getProject());
        }

        public Module getModule() {
            return this.myModule;
        }

        GlobalSearchScope getOwnUseScope() {
            return this.myOwnUseScope;
        }

        public PropertySearcher getSearcher() {
            return this.mySearcher;
        }

        PsiSearchHelper getSearchHelper() {
            return this.mySearchHelper;
        }
    }
}

