/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.editor.PropertiesValueHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PropertiesAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PropertiesAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PropertiesAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof Property)) {
            return;
        }
        Property property = (Property)element;
        PropertiesFile propertiesFile = property.getPropertiesFile();
        List<IProperty> others = propertiesFile.findPropertiesByKey(property.getUnescapedKey());
        ASTNode keyNode = ((PropertyImpl)property).getKeyNode();
        if (others.size() != 1) {
            Annotation annotation = holder.createErrorAnnotation(keyNode, PropertiesBundle.message("duplicate.property.key.error.message", new Object[0]));
            annotation.registerFix(PropertiesQuickFixFactory.getInstance().createRemovePropertyFix(property));
        }
        PropertiesAnnotator.highlightTokens(property, keyNode, holder, new PropertiesHighlighter());
        ASTNode valueNode = ((PropertyImpl)property).getValueNode();
        if (valueNode != null) {
            PropertiesAnnotator.highlightTokens(property, valueNode, holder, new PropertiesValueHighlighter());
        }
    }

    private static void highlightTokens(final Property property, ASTNode node, AnnotationHolder holder, PropertiesHighlighter highlighter) {
        Lexer lexer = highlighter.getHighlightingLexer();
        String s = node.getText();
        lexer.start((CharSequence)s);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            IElementType elementType = lexer.getTokenType();
            for (TextAttributesKey key : keys = highlighter.getTokenHighlights(elementType)) {
                Pair<String, HighlightSeverity> pair = PropertiesHighlighter.DISPLAY_NAMES.get(key);
                String displayName = (String)pair.getFirst();
                HighlightSeverity severity = (HighlightSeverity)pair.getSecond();
                if (severity == null) continue;
                int start = lexer.getTokenStart() + node.getTextRange().getStartOffset();
                int end = lexer.getTokenEnd() + node.getTextRange().getStartOffset();
                TextRange textRange = new TextRange(start, end);
                final Annotation annotation = severity == HighlightSeverity.WARNING ? holder.createWarningAnnotation(textRange, displayName) : (severity == HighlightSeverity.ERROR ? holder.createErrorAnnotation(textRange, displayName) : holder.createInfoAnnotation(textRange, displayName));
                TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key);
                annotation.setEnforcedTextAttributes(attributes);
                if (key != PropertiesHighlighter.PROPERTIES_INVALID_STRING_ESCAPE) continue;
                annotation.registerFix(new IntentionAction(){

                    @NotNull
                    public String getText() {
                        String string = PropertiesBundle.message("unescape", new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    @NotNull
                    public String getFamilyName() {
                        String string = this.getText();
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (!property.isValid() || !property.getManager().isInProject((PsiElement)property)) {
                            return false;
                        }
                        String text = property.getPropertiesFile().getContainingFile().getText();
                        int startOffset = annotation.getStartOffset();
                        return text.length() > startOffset && text.charAt(startOffset) == '\\';
                    }

                    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        int offset = annotation.getStartOffset();
                        if (property.getPropertiesFile().getContainingFile().getText().charAt(offset) == '\\') {
                            editor.getDocument().deleteString(offset, offset + 1);
                        }
                    }

                    public boolean startInWriteAction() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 2: 
                            case 3: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 2: 
                            case 3: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/lang/properties/PropertiesAnnotator$1";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "project";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getText";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getFamilyName";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/lang/properties/PropertiesAnnotator$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "isAvailable";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "invoke";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 2: 
                            case 3: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            }
            lexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/properties/PropertiesAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

