/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.fileStatus;

import com.intellij.application.options.colors.fileStatus.FileStatusColorDescriptor;
import com.intellij.application.options.colors.fileStatus.FileStatusColorsTable;
import com.intellij.application.options.colors.fileStatus.FileStatusColorsTableModel;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusColorsPanel {
    private static final int TABLE_SIZE = 250;
    private JPanel myTopPanel;
    private JBTable myFileStatusColorsTable;
    private JBCheckBox myFileStatusColorBox;
    private JButton myRestoreButton;
    private ColorPanel myColorPanel;
    private JBScrollPane myTablePane;
    private JPanel myColorSettingsPanel;
    private JLabel myCustomizedLabel;
    private final FileStatusColorsTableModel myModel;

    public FileStatusColorsPanel(@NotNull FileStatus[] fileStatuses) {
        if (fileStatuses == null) {
            FileStatusColorsPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myModel = new FileStatusColorsTableModel(fileStatuses, FileStatusColorsPanel.getCurrentScheme());
        this.myFileStatusColorsTable.setModel((TableModel)this.myModel);
        ((FileStatusColorsTable)this.myFileStatusColorsTable).adjustColumnWidths();
        this.myModel.addTableModelListener((TableModelListener)this.myFileStatusColorsTable);
        this.myFileStatusColorsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileStatusColorsPanel.this.updateColorPanel(FileStatusColorsPanel.this.myModel.getDescriptorAt(FileStatusColorsPanel.this.myFileStatusColorsTable.getSelectedRow()));
            }
        });
        this.myRestoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileStatusColorsPanel.this.restoreDefault(FileStatusColorsPanel.this.myFileStatusColorsTable.getSelectedRow());
            }
        });
        this.myFileStatusColorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileStatusColorsPanel.this.setUseColor(FileStatusColorsPanel.this.myFileStatusColorsTable.getSelectedRow(), FileStatusColorsPanel.this.myFileStatusColorBox.isSelected());
            }
        });
        this.myColorPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileStatusColorsPanel.this.setColor(FileStatusColorsPanel.this.myFileStatusColorsTable.getSelectedRow(), FileStatusColorsPanel.this.myColorPanel.getSelectedColor());
            }
        });
        this.adjustTableSize();
        this.myColorSettingsPanel.setVisible(false);
        this.updateCustomizedLabel();
        this.myModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                FileStatusColorsPanel.this.updateCustomizedLabel();
            }
        });
    }

    private void updateCustomizedLabel() {
        boolean isVisible = this.myModel.containsCustomSettings();
        this.myCustomizedLabel.setForeground((Color)(isVisible ? JBColor.GRAY : UIUtil.getLabelBackground()));
    }

    private void adjustTableSize() {
        Dimension d = this.myFileStatusColorsTable.getPreferredSize();
        d.setSize(JBUIScale.scale((int)250), d.height);
        this.myTablePane.setMinimumSize(new Dimension(JBUIScale.scale((int)250), 0));
        this.myTablePane.setPreferredSize(d);
        this.myTablePane.setMaximumSize(d);
    }

    public JPanel getComponent() {
        return this.myTopPanel;
    }

    private void createUIComponents() {
        this.myFileStatusColorsTable = new FileStatusColorsTable();
    }

    @NotNull
    private static EditorColorsScheme getCurrentScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        if (editorColorsScheme == null) {
            FileStatusColorsPanel.$$$reportNull$$$0(1);
        }
        return editorColorsScheme;
    }

    @NotNull
    public FileStatusColorsTableModel getModel() {
        FileStatusColorsTableModel fileStatusColorsTableModel = this.myModel;
        if (fileStatusColorsTableModel == null) {
            FileStatusColorsPanel.$$$reportNull$$$0(2);
        }
        return fileStatusColorsTableModel;
    }

    private void updateColorPanel(@Nullable FileStatusColorDescriptor descriptor2) {
        if (descriptor2 == null) {
            this.myColorSettingsPanel.setVisible(false);
        } else {
            this.myColorSettingsPanel.setVisible(true);
            this.myFileStatusColorBox.setSelected(descriptor2.getColor() != null);
            this.myRestoreButton.setEnabled(!descriptor2.isDefault());
            this.myColorPanel.setSelectedColor(descriptor2.getColor());
        }
    }

    private void restoreDefault(int row) {
        if (row >= 0) {
            this.myModel.resetToDefault(row);
            this.updateColorPanel(this.myModel.getDescriptorAt(row));
        }
    }

    private void setUseColor(int row, boolean useColor) {
        FileStatusColorDescriptor descriptor2;
        if (row >= 0 && (descriptor2 = this.myModel.getDescriptorAt(row)) != null) {
            Color defaultColor = descriptor2.getDefaultColor();
            Color c2 = useColor ? (defaultColor != null ? defaultColor : UIUtil.getLabelForeground()) : null;
            this.getModel().setValueAt(c2, row, 1);
            this.updateColorPanel(descriptor2);
        }
    }

    private void setColor(int row, @NotNull Color color) {
        if (color == null) {
            FileStatusColorsPanel.$$$reportNull$$$0(3);
        }
        if (row >= 0) {
            this.myModel.setValueAt(color, row, 1);
            FileStatusColorDescriptor descriptor2 = this.myModel.getDescriptorAt(row);
            if (descriptor2 != null) {
                this.updateColorPanel(descriptor2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatuses";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/fileStatus/FileStatusColorsPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/fileStatus/FileStatusColorsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentScheme";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        ColorPanel colorPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBScrollPane jBScrollPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTablePane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 2, 1, 0, 3, 0, 3, null, null, null));
        JBTable jBTable = this.myFileStatusColorsTable;
        jBScrollPane.setViewportView((Component)jBTable);
        this.myColorSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myFileStatusColorBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("File status color:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jBCheckBox, gridBagConstraints);
        this.myColorPanel = colorPanel = new ColorPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        jPanel.add((Component)colorPanel, gridBagConstraints2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1, 0, 18));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.fill = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints3);
        this.myRestoreButton = jButton = new JButton();
        jButton.setHorizontalAlignment(0);
        jButton.setHorizontalTextPosition(0);
        jButton.setText("Restore Default");
        Component component = jPanel3.add(jButton);
        Spacer spacer = new Spacer();
        Component component2 = jPanel3.add((Component)spacer);
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCustomizedLabel = jLabel = new JLabel();
        jLabel.setText("* Customized");
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }
}

