/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputCollector;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacOutputParser
implements BuildOutputParser {
    private static final String COMPILER_MESSAGES_GROUP = "Java compiler";
    private static final char COLON = ':';
    private static final String WARNING_PREFIX = "warning:";
    private static final String ERROR_PREFIX = "error:";

    public boolean parse(@NotNull String line2, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer2) {
        int colonIndex1;
        if (line2 == null) {
            JavacOutputParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            JavacOutputParser.$$$reportNull$$$0(1);
        }
        if (messageConsumer2 == null) {
            JavacOutputParser.$$$reportNull$$$0(2);
        }
        if ((colonIndex1 = line2.indexOf(58)) == 1) {
            colonIndex1 = line2.indexOf(58, colonIndex1 + 1);
        }
        if (colonIndex1 >= 0) {
            File file2;
            String message;
            int javaFileExtensionIndex;
            String part1 = line2.substring(0, colonIndex1).trim();
            if (part1.equalsIgnoreCase("error") || part1.equalsIgnoreCase("Caused by")) {
                String text2 = line2.substring(colonIndex1 + 1).trim();
                messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP, text2, line2));
                return true;
            }
            if (part1.equalsIgnoreCase("warning")) {
                String text3 = line2.substring(colonIndex1 + 1).trim();
                messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.WARNING, COMPILER_MESSAGES_GROUP, text3, line2));
                return true;
            }
            if (part1.equalsIgnoreCase("javac")) {
                messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP, line2, line2));
                return true;
            }
            if (part1.equalsIgnoreCase("Note") && (javaFileExtensionIndex = (message = line2.substring(colonIndex1 + 1).trim()).indexOf(".java")) > 0 && (file2 = new File(message.substring(0, javaFileExtensionIndex + ".java".length()))).isFile()) {
                message = message.substring(javaFileExtensionIndex + ".java".length() + 1);
                String detailedMessage = JavacOutputParser.amendNextInfoLinesIfNeeded(file2.getPath() + ":\n" + message, reader);
                messageConsumer2.accept(new FileMessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.INFO, COMPILER_MESSAGES_GROUP, message, detailedMessage, new FilePosition(file2, 0, 0)));
                return true;
            }
            int colonIndex2 = line2.indexOf(58, colonIndex1 + 1);
            if (colonIndex2 >= 0) {
                File file3 = new File(part1);
                if (!file3.isFile()) {
                    return false;
                }
                try {
                    int column;
                    int lineNumber = Integer.parseInt(line2.substring(colonIndex1 + 1, colonIndex2).trim());
                    String text4 = line2.substring(colonIndex2 + 1).trim();
                    MessageEvent.Kind kind = MessageEvent.Kind.ERROR;
                    if (text4.startsWith(WARNING_PREFIX)) {
                        text4 = text4.substring(WARNING_PREFIX.length()).trim();
                        kind = MessageEvent.Kind.WARNING;
                    } else if (text4.startsWith(ERROR_PREFIX)) {
                        text4 = text4.substring(ERROR_PREFIX.length()).trim();
                        kind = MessageEvent.Kind.ERROR;
                    }
                    if (!file3.getPath().endsWith(".java")) {
                        return false;
                    }
                    BuildOutputCollector outputCollector = new BuildOutputCollector(reader);
                    ArrayList<String> messageList = new ArrayList<String>();
                    messageList.add(text4);
                    String prevLine = null;
                    while (true) {
                        String nextLine;
                        if ((nextLine = outputCollector.readLine()) == null) {
                            return false;
                        }
                        if (nextLine.trim().equals("^")) {
                            column = nextLine.indexOf(94);
                            String messageEnd = outputCollector.readLine();
                            while (JavacOutputParser.isMessageEnd(messageEnd)) {
                                messageList.add(messageEnd.trim());
                                messageEnd = outputCollector.readLine();
                            }
                            if (messageEnd == null) break;
                            outputCollector.pushBack();
                            break;
                        }
                        if (prevLine != null) {
                            messageList.add(prevLine);
                        }
                        prevLine = nextLine;
                    }
                    if (column >= 0) {
                        String message2 = StringUtil.join(JavacOutputParser.convertMessages(messageList), (String)"\n");
                        String detailedMessage = line2 + "\n" + outputCollector.getOutput();
                        messageConsumer2.accept(new FileMessageEventImpl(reader.getParentEventId(), kind, COMPILER_MESSAGES_GROUP, message2, detailedMessage, new FilePosition(file3, lineNumber - 1, column)));
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (line2.endsWith("java.lang.OutOfMemoryError")) {
            messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP, "Out of memory.", line2));
            return true;
        }
        return false;
    }

    private static String amendNextInfoLinesIfNeeded(String str, BuildOutputInstantReader reader) {
        StringBuilder builder2 = new StringBuilder(str);
        String nextLine = reader.readLine();
        while (nextLine != null) {
            int index;
            if (nextLine.startsWith("Note: ") && (index = nextLine.indexOf(".java")) < 0) {
                builder2.append("\n").append(nextLine.substring("Note: ".length()));
                nextLine = reader.readLine();
                continue;
            }
            reader.pushBack();
            break;
        }
        return builder2.toString();
    }

    @Contract(value="null -> false")
    private static boolean isMessageEnd(@Nullable String line2) {
        return line2 != null && line2.length() > 0 && Character.isWhitespace(line2.charAt(0));
    }

    @NotNull
    private static List<String> convertMessages(@NotNull List<String> messages) {
        String part1;
        if (messages == null) {
            JavacOutputParser.$$$reportNull$$$0(3);
        }
        if (messages.size() <= 1) {
            List<String> list2 = messages;
            if (list2 == null) {
                JavacOutputParser.$$$reportNull$$$0(4);
            }
            return list2;
        }
        String line0 = messages.get(0);
        String line1 = messages.get(1);
        int colonIndex = line1.indexOf(58);
        if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
            String symbol = line1.substring(colonIndex + 1).trim();
            messages.remove(1);
            if (messages.size() >= 2) {
                messages.remove(1);
            }
            messages.set(0, line0 + " " + symbol);
        }
        List<String> list3 = messages;
        if (list3 == null) {
            JavacOutputParser.$$$reportNull$$$0(5);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/output/JavacOutputParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/output/JavacOutputParser";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertMessages";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

