/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.CachedAnnotators;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class DefaultHighlightVisitor
implements HighlightVisitor,
DumbAware {
    private static final NotNullLazyKey<CachedAnnotators, Project> CACHED_ANNOTATORS_KEY = ServiceManager.createLazyKey(CachedAnnotators.class);
    private AnnotationHolderImpl myAnnotationHolder;
    private final Project myProject;
    private final boolean myHighlightErrorElements;
    private final boolean myRunAnnotators;
    private final DumbService myDumbService;
    private HighlightInfoHolder myHolder;
    private final boolean myBatchMode;

    DefaultHighlightVisitor(@NotNull Project project) {
        if (project == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(0);
        }
        this(project, true, true, false);
    }

    DefaultHighlightVisitor(@NotNull Project project, boolean highlightErrorElements, boolean runAnnotators, boolean batchMode) {
        if (project == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myHighlightErrorElements = highlightErrorElements;
        this.myRunAnnotators = runAnnotators;
        this.myDumbService = DumbService.getInstance((Project)project);
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        if (file2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(5);
        }
        this.myHolder = holder;
        this.myAnnotationHolder = new AnnotationHolderImpl(holder.getAnnotationSession(), this.myBatchMode);
        try {
            action2.run();
        }
        finally {
            this.myAnnotationHolder.clear();
            this.myAnnotationHolder = null;
            this.myHolder = null;
        }
        return true;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiErrorElement) {
            if (this.myHighlightErrorElements) {
                this.visitErrorElement((PsiErrorElement)element);
            }
        } else if (this.myRunAnnotators) {
            this.runAnnotators(element);
        }
        if (this.myAnnotationHolder.hasAnnotations()) {
            Iterator iterator = this.myAnnotationHolder.iterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                this.myHolder.add(HighlightInfo.fromAnnotation(annotation, this.myBatchMode));
            }
            this.myAnnotationHolder.clear();
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        DefaultHighlightVisitor defaultHighlightVisitor = new DefaultHighlightVisitor(this.myProject, this.myHighlightErrorElements, this.myRunAnnotators, this.myBatchMode);
        if (defaultHighlightVisitor == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(7);
        }
        return defaultHighlightVisitor;
    }

    private void runAnnotators(PsiElement element) {
        List<Annotator> annotators = ((CachedAnnotators)CACHED_ANNOTATORS_KEY.getValue((UserDataHolder)this.myProject)).get(element.getLanguage().getID());
        if (annotators.isEmpty()) {
            return;
        }
        boolean dumb = this.myDumbService.isDumb();
        for (int i = 0; i < annotators.size(); ++i) {
            Annotator annotator = annotators.get(i);
            if (dumb && !DumbService.isDumbAware((Object)annotator)) continue;
            ProgressManager.checkCanceled();
            annotator.annotate(element, (AnnotationHolder)this.myAnnotationHolder);
        }
    }

    private void visitErrorElement(@NotNull PsiErrorElement element) {
        HighlightErrorFilter errorFilter;
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(8);
        }
        Iterator iterator = HighlightErrorFilter.EP_NAME.getIterable((AreaInstance)this.myProject).iterator();
        while (iterator.hasNext() && (errorFilter = (HighlightErrorFilter)iterator.next()) != null) {
            if (errorFilter.shouldHighlightErrorElement(element)) continue;
            return;
        }
        this.myHolder.add(DefaultHighlightVisitor.createErrorElementInfo(element));
    }

    private static HighlightInfo createErrorElementInfo(@NotNull PsiErrorElement element) {
        HighlightInfo info;
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(9);
        }
        if ((info = DefaultHighlightVisitor.createInfoWithoutFixes(element)) != null) {
            for (ErrorQuickFixProvider provider : ErrorQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerErrorQuickFix(element, info);
            }
        }
        return info;
    }

    private static HighlightInfo createInfoWithoutFixes(@NotNull PsiErrorElement element) {
        int end;
        int start2;
        String text2;
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(10);
        }
        TextRange range2 = element.getTextRange();
        String errorDescription = element.getErrorDescription();
        if (!range2.isEmpty()) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range2).descriptionAndTooltip(errorDescription).create();
        }
        int offset = range2.getStartOffset();
        PsiFile containingFile = element.getContainingFile();
        int fileLength = containingFile.getTextLength();
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiElement elementAtOffset = viewProvider.findElementAt(offset, LanguageUtil.getRootLanguage((PsiElement)element));
        String string = text2 = elementAtOffset == null ? null : elementAtOffset.getText();
        if (offset < fileLength && text2 != null && !StringUtil.startsWithChar((CharSequence)text2, (char)'\n') && !StringUtil.startsWithChar((CharSequence)text2, (char)'\r')) {
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(offset, offset + 1);
            builder2.descriptionAndTooltip(errorDescription);
            return builder2.create();
        }
        if (offset > 0) {
            start2 = offset;
            end = offset;
        } else {
            start2 = offset;
            end = offset < fileLength ? offset + 1 : offset;
        }
        HighlightInfo.Builder builder3 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)element, start2, end);
        builder3.descriptionAndTooltip(errorDescription);
        builder3.endOfLine();
        return builder3.create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitErrorElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createErrorElementInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInfoWithoutFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

