/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.BackspaceHandler;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupTypedHandler;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupActionHandler
extends EditorActionHandler {
    protected final EditorActionHandler myOriginalHandler;

    public LookupActionHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
        if (editor == null) {
            LookupActionHandler.$$$reportNull$$$0(0);
        }
        return LookupManager.getActiveLookup(editor) == null;
    }

    public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        LookupImpl lookup;
        if (editor == null) {
            LookupActionHandler.$$$reportNull$$$0(1);
        }
        if ((lookup = (LookupImpl)LookupManager.getActiveLookup(editor)) == null || !lookup.isAvailableToUser()) {
            Project project = editor.getProject();
            if (project != null && lookup != null) {
                LookupManager.getInstance(project).hideActiveLookup();
            }
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        lookup.markSelectionTouched();
        this.executeInLookup(lookup, dataContext, caret);
    }

    protected abstract void executeInLookup(LookupImpl var1, DataContext var2, @Nullable Caret var3);

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        LookupImpl lookup;
        if (editor == null) {
            LookupActionHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            LookupActionHandler.$$$reportNull$$$0(3);
        }
        return (lookup = (LookupImpl)LookupManager.getActiveLookup(editor)) != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    private static void executeUpOrDown(LookupImpl lookup, boolean up) {
        if (!lookup.isFocused()) {
            boolean semiFocused = lookup.getFocusDegree() == LookupImpl.FocusDegree.SEMI_FOCUSED;
            lookup.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            if (!up && !semiFocused) {
                return;
            }
        }
        if (up) {
            ScrollingUtil.moveUp((JList)lookup.getList(), (int)0);
        } else {
            ScrollingUtil.moveDown((JList)lookup.getList(), (int)0);
        }
        lookup.markSelectionTouched();
        lookup.refreshUi(false, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RightHandler
    extends LookupActionHandler {
        public RightHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            Editor editor = lookup.getEditor();
            int offset = editor.getCaretModel().getOffset();
            CharSequence seq = editor.getDocument().getCharsSequence();
            if (seq.length() <= offset || !lookup.isCompletion()) {
                this.myOriginalHandler.execute(editor, caret, context);
                return;
            }
            char c2 = seq.charAt(offset);
            CharFilter.Result lookupAction = LookupTypedHandler.getLookupAction(c2, lookup);
            if (lookupAction != CharFilter.Result.ADD_TO_PREFIX || Character.isWhitespace(c2)) {
                this.myOriginalHandler.execute(editor, caret, context);
                return;
            }
            if (!lookup.performGuardedChange(() -> {
                CaretAction action2 = lookupCaret -> {
                    lookupCaret.removeSelection();
                    int caretOffset = lookupCaret.getOffset();
                    if (caretOffset < seq.length()) {
                        lookupCaret.moveToOffset(caretOffset + 1);
                    }
                };
                if (caret == null) {
                    editor.getCaretModel().runForEachCaret(action2);
                } else {
                    action2.perform(caret);
                }
            })) {
                return;
            }
            lookup.fireBeforeAppendPrefix(c2);
            lookup.appendPrefix(c2);
            CompletionProgressIndicator completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
            if (completion != null) {
                completion.prefixUpdated();
            }
        }
    }

    public static class LeftHandler
    extends LookupActionHandler {
        public LeftHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            if (!lookup.isCompletion()) {
                this.myOriginalHandler.execute(lookup.getEditor(), caret, context);
                return;
            }
            if (!lookup.performGuardedChange(() -> lookup.getEditor().getSelectionModel().removeSelection())) {
                return;
            }
            BackspaceHandler.truncatePrefix(context, lookup, this.myOriginalHandler, lookup.getLookupStart() - 1, caret);
        }
    }

    public static class PageUpHandler
    extends LookupActionHandler {
        public PageUpHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            lookup.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            ScrollingUtil.movePageUp((JList)lookup.getList());
        }
    }

    public static class PageDownHandler
    extends LookupActionHandler {
        public PageDownHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            lookup.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            ScrollingUtil.movePageDown((JList)lookup.getList());
        }
    }

    public static class UpHandler
    extends LookupActionHandler {
        public UpHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            if (!UISettings.getInstance().getCycleScrolling() && !lookup.isFocused() && lookup.getList().getSelectedIndex() == 0) {
                this.myOriginalHandler.execute(lookup.getEditor(), caret, context);
                return;
            }
            LookupActionHandler.executeUpOrDown(lookup, true);
        }
    }

    private static class UpDownInEditorHandler
    extends EditorActionHandler {
        private final boolean myUp;

        private UpDownInEditorHandler(boolean up) {
            this.myUp = up;
        }

        public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
            if (editor == null) {
                UpDownInEditorHandler.$$$reportNull$$$0(0);
            }
            return false;
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                UpDownInEditorHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                UpDownInEditorHandler.$$$reportNull$$$0(2);
            }
            return LookupManager.getActiveLookup(editor) != null;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                UpDownInEditorHandler.$$$reportNull$$$0(3);
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.cancelByControlArrows");
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
            assert (lookup != null) : LookupImpl.getLastLookupDisposeTrace();
            lookup.hideLookup(true);
            EditorActionManager.getInstance().getActionHandler(this.myUp ? "EditorUp" : "EditorDown").execute(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupActionHandler$UpDownInEditorHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeInCommand";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DownAction
    extends EditorAction {
        public DownAction() {
            super((EditorActionHandler)new UpDownInEditorHandler(false));
        }
    }

    public static class UpAction
    extends EditorAction {
        public UpAction() {
            super((EditorActionHandler)new UpDownInEditorHandler(true));
        }
    }

    public static class DownHandler
    extends LookupActionHandler {
        public DownHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            LookupActionHandler.executeUpOrDown(lookup, false);
        }
    }
}

