/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.LineSeparator;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentContentImpl
extends DiffContentBase
implements DocumentContent {
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @Nullable
    private final FileType myType;
    @Nullable
    private final VirtualFile myHighlightFile;
    @Nullable
    private final LineSeparator mySeparator;
    @Nullable
    private final Charset myCharset;
    @Nullable
    private final Boolean myBOM;

    public DocumentContentImpl(@NotNull Document document) {
        if (document == null) {
            DocumentContentImpl.$$$reportNull$$$0(0);
        }
        this(null, document, null, null, null, null, null);
    }

    public DocumentContentImpl(@Nullable Project project, @NotNull Document document, @Nullable FileType type, @Nullable VirtualFile highlightFile, @Nullable LineSeparator separator, @Nullable Charset charset, @Nullable Boolean bom) {
        if (document == null) {
            DocumentContentImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDocument = document;
        this.myType = type;
        this.myHighlightFile = highlightFile;
        this.mySeparator = separator;
        this.myCharset = charset;
        this.myBOM = bom;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            DocumentContentImpl.$$$reportNull$$$0(2);
        }
        return document;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return this.myHighlightFile;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            DocumentContentImpl.$$$reportNull$$$0(3);
        }
        if (!DiffUtil.canNavigateToFile(this.myProject, this.getHighlightFile())) {
            return null;
        }
        return new MyNavigatable(this.myProject, this.getHighlightFile(), this.getDocument(), position);
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(new LineCol(0));
    }

    @Nullable
    public LineSeparator getLineSeparator() {
        return this.mySeparator;
    }

    @Nullable
    public Boolean hasBom() {
        return this.myBOM;
    }

    @Nullable
    public FileType getContentType() {
        return this.myType;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/contents/DocumentContentImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/contents/DocumentContentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNavigatable
    implements Navigatable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myTargetFile;
        @NotNull
        private final Document myDocument;
        @NotNull
        private final LineCol myPosition;

        MyNavigatable(@NotNull Project project, @NotNull VirtualFile targetFile, @NotNull Document document, @NotNull LineCol position) {
            if (project == null) {
                MyNavigatable.$$$reportNull$$$0(0);
            }
            if (targetFile == null) {
                MyNavigatable.$$$reportNull$$$0(1);
            }
            if (document == null) {
                MyNavigatable.$$$reportNull$$$0(2);
            }
            if (position == null) {
                MyNavigatable.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myTargetFile = targetFile;
            this.myDocument = document;
            this.myPosition = position;
        }

        public void navigate(boolean requestFocus) {
            OpenFileDescriptor descriptor2;
            Document targetDocument = FileDocumentManager.getInstance().getDocument(this.myTargetFile);
            LineCol targetPosition = MyNavigatable.translatePosition(this.myDocument, targetDocument, this.myPosition);
            Object object = descriptor2 = targetDocument != null ? PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myTargetFile, targetPosition.toOffset(targetDocument)) : new OpenFileDescriptor(this.myProject, this.myTargetFile, targetPosition.line, targetPosition.column);
            if (descriptor2.canNavigate()) {
                descriptor2.navigate(true);
            }
        }

        public boolean canNavigate() {
            return this.myTargetFile.isValid();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @NotNull
        private static LineCol translatePosition(@NotNull Document fromDocument, @Nullable Document toDocument, @NotNull LineCol position) {
            LineCol lineCol;
            block8: {
                block7: {
                    LineCol lineCol2;
                    if (fromDocument == null) {
                        MyNavigatable.$$$reportNull$$$0(4);
                    }
                    if (position == null) {
                        MyNavigatable.$$$reportNull$$$0(5);
                    }
                    try {
                        if (toDocument != null) break block7;
                        lineCol2 = position;
                    }
                    catch (FilesTooBigForDiffException ignore) {
                        LineCol lineCol3 = position;
                        if (lineCol3 == null) {
                            MyNavigatable.$$$reportNull$$$0(8);
                        }
                        return lineCol3;
                    }
                    if (lineCol2 == null) {
                        MyNavigatable.$$$reportNull$$$0(6);
                    }
                    return lineCol2;
                }
                int targetLine = Diff.translateLine((CharSequence)fromDocument.getCharsSequence(), (CharSequence)toDocument.getCharsSequence(), (int)position.line, (boolean)true);
                lineCol = new LineCol(targetLine, position.column);
                if (lineCol != null) break block8;
                MyNavigatable.$$$reportNull$$$0(7);
            }
            return lineCol;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromDocument";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "translatePosition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "translatePosition";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

