/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffToolUtil {
    public static boolean canCreateFile(@NotNull DiffContent content2) {
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(0);
        }
        if (content2 instanceof EmptyContent) {
            return true;
        }
        if (content2 instanceof DocumentContent) {
            return true;
        }
        if (content2 instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content2).getFile();
            return !(file2 instanceof VirtualFileWithoutContent);
        }
        if (content2 instanceof DirectoryContent) {
            return ((DirectoryContent)content2).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    private static InputFile createFile(@Nullable Project project, @NotNull DiffContent content2, @NotNull FileNameInfo fileName2) throws IOException {
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(1);
        }
        if (fileName2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(2);
        }
        if (content2 instanceof EmptyContent) {
            TempInputFile tempInputFile = new TempInputFile(ExternalDiffToolUtil.createFile(new byte[0], fileName2));
            if (tempInputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(3);
            }
            return tempInputFile;
        }
        if (content2 instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content2).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                LocalInputFile localInputFile = new LocalInputFile(file2);
                if (localInputFile == null) {
                    ExternalDiffToolUtil.$$$reportNull$$$0(4);
                }
                return localInputFile;
            }
            TempInputFile tempInputFile = new TempInputFile(ExternalDiffToolUtil.createTempFile(file2, fileName2));
            if (tempInputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(5);
            }
            return tempInputFile;
        }
        if (content2 instanceof DocumentContent) {
            TempInputFile tempInputFile = new TempInputFile(ExternalDiffToolUtil.createTempFile(project, (DocumentContent)content2, fileName2));
            if (tempInputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(6);
            }
            return tempInputFile;
        }
        if (content2 instanceof DirectoryContent) {
            VirtualFile file3 = ((DirectoryContent)content2).getFile();
            if (file3.isInLocalFileSystem()) {
                LocalInputFile localInputFile = new LocalInputFile(file3);
                if (localInputFile == null) {
                    ExternalDiffToolUtil.$$$reportNull$$$0(7);
                }
                return localInputFile;
            }
            throw new IllegalArgumentException(content2.toString());
        }
        throw new IllegalArgumentException(content2.toString());
    }

    @NotNull
    private static File createTempFile(@Nullable Project project, @NotNull DocumentContent content2, @NotNull FileNameInfo fileName2) throws IOException {
        byte[] bom;
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(8);
        }
        if (fileName2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(9);
        }
        FileDocumentManager.getInstance().saveDocument(content2.getDocument());
        LineSeparator separator = content2.getLineSeparator();
        if (separator == null) {
            separator = LineSeparator.getSystemLineSeparator();
        }
        Charset charset = ExternalDiffToolUtil.getContentCharset(project, content2);
        Boolean hasBom = content2.hasBom();
        if (hasBom == null) {
            hasBom = CharsetToolkit.getMandatoryBom((Charset)charset) != null;
        }
        String contentData = (String)ReadAction.compute(() -> content2.getDocument().getText());
        if (separator != LineSeparator.LF) {
            contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator.getSeparatorString());
        }
        byte[] bytes = contentData.getBytes(charset);
        byte[] byArray = bom = hasBom != false ? CharsetToolkit.getPossibleBom((Charset)charset) : null;
        if (bom != null) {
            bytes = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytes);
        }
        File file2 = ExternalDiffToolUtil.createFile(bytes, fileName2);
        if (file2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(10);
        }
        return file2;
    }

    @NotNull
    private static File createTempFile(@NotNull VirtualFile file2, @NotNull FileNameInfo fileName2) throws IOException {
        if (file2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(11);
        }
        if (fileName2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(12);
        }
        byte[] bytes = file2.contentsToByteArray();
        File file3 = ExternalDiffToolUtil.createFile(bytes, fileName2);
        if (file3 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(13);
        }
        return file3;
    }

    @NotNull
    private static Charset getContentCharset(@Nullable Project project, @NotNull DocumentContent content2) {
        Charset charset;
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(14);
        }
        if ((charset = content2.getCharset()) != null) {
            Charset charset2 = charset;
            if (charset2 == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(15);
            }
            return charset2;
        }
        EncodingManager e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance();
        Charset charset3 = e.getDefaultCharset();
        if (charset3 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(16);
        }
        return charset3;
    }

    @NotNull
    private static OutputFile createOutputFile(@Nullable Project project, @NotNull DiffContent content2, @NotNull FileNameInfo fileName2) throws IOException {
        if (content2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(17);
        }
        if (fileName2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(18);
        }
        if (content2 instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content2).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                LocalOutputFile localOutputFile = new LocalOutputFile(file2);
                if (localOutputFile == null) {
                    ExternalDiffToolUtil.$$$reportNull$$$0(19);
                }
                return localOutputFile;
            }
            File tempFile = ExternalDiffToolUtil.createTempFile(file2, fileName2);
            NonLocalOutputFile nonLocalOutputFile = new NonLocalOutputFile(file2, tempFile);
            if (nonLocalOutputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(20);
            }
            return nonLocalOutputFile;
        }
        if (content2 instanceof DocumentContent) {
            DocumentContent documentContent = (DocumentContent)content2;
            File tempFile = ExternalDiffToolUtil.createTempFile(project, documentContent, fileName2);
            Charset charset = ExternalDiffToolUtil.getContentCharset(project, documentContent);
            DocumentOutputFile documentOutputFile = new DocumentOutputFile(documentContent.getDocument(), charset, tempFile);
            if (documentOutputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(21);
            }
            return documentOutputFile;
        }
        throw new IllegalArgumentException(content2.toString());
    }

    @NotNull
    private static File createFile(@NotNull byte[] bytes, @NotNull FileNameInfo fileName2) throws IOException {
        if (bytes == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(22);
        }
        if (fileName2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(23);
        }
        File tempFile = FileUtil.createTempFile((String)(fileName2.prefix + "_"), (String)("_" + fileName2.name), (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])bytes);
        File file2 = tempFile;
        if (file2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(24);
        }
        return file2;
    }

    public static void execute(@Nullable Project project, @NotNull ExternalDiffSettings settings, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException, ExecutionException {
        if (settings == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(25);
        }
        if (contents == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(26);
        }
        if (titles == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(27);
        }
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        ArrayList<InputFile> files2 = new ArrayList<InputFile>();
        for (int i = 0; i < contents.size(); ++i) {
            DiffContent content2 = contents.get(i);
            FileNameInfo fileName2 = FileNameInfo.create(contents, titles, windowTitle, i);
            files2.add(ExternalDiffToolUtil.createFile(project, content2, fileName2));
        }
        HashMap<String, String> patterns = new HashMap<String, String>();
        if (files2.size() == 2) {
            patterns.put("%1", ((InputFile)files2.get(0)).getPath());
            patterns.put("%2", ((InputFile)files2.get(1)).getPath());
            patterns.put("%3", "");
        } else {
            patterns.put("%1", ((InputFile)files2.get(0)).getPath());
            patterns.put("%2", ((InputFile)files2.get(2)).getPath());
            patterns.put("%3", ((InputFile)files2.get(1)).getPath());
        }
        ExternalDiffToolUtil.execute(settings.getDiffExePath(), settings.getDiffParameters(), patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMerge(@Nullable Project project, @NotNull ExternalDiffSettings settings, @NotNull ThreesideMergeRequest request) throws IOException, ExecutionException {
        if (settings == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(28);
        }
        if (request == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(29);
        }
        boolean success = false;
        InputFile outputFile = null;
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        try {
            DiffContent outputContent = request.getOutputContent();
            List contents = request.getContents();
            List titles = request.getContentTitles();
            String windowTitle = request.getTitle();
            assert (contents.size() == 3);
            assert (titles.size() == contents.size());
            for (int i = 0; i < contents.size(); ++i) {
                DiffContent content2 = (DiffContent)contents.get(i);
                FileNameInfo fileName2 = FileNameInfo.create(contents, titles, windowTitle, i);
                inputFiles.add(ExternalDiffToolUtil.createFile(project, content2, fileName2));
            }
            outputFile = ExternalDiffToolUtil.createOutputFile(project, outputContent, FileNameInfo.createMergeResult(outputContent, windowTitle));
            com.intellij.util.containers.hash.HashMap patterns = new com.intellij.util.containers.hash.HashMap();
            patterns.put("%1", ((InputFile)inputFiles.get(0)).getPath());
            patterns.put("%2", ((InputFile)inputFiles.get(2)).getPath());
            patterns.put("%3", ((InputFile)inputFiles.get(1)).getPath());
            patterns.put("%4", outputFile.getPath());
            final Process process2 = ExternalDiffToolUtil.execute(settings.getMergeExePath(), settings.getMergeParameters(), (Map<String, String>)patterns);
            if (settings.isMergeTrustExitCode()) {
                final Ref resultRef = new Ref();
                ProgressManager.getInstance().run((Task)new Task.Modal(project, "Waiting for External Tool...", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        final Semaphore semaphore = new Semaphore(0);
                        Thread waiter = new Thread("external process waiter"){

                            @Override
                            public void run() {
                                try {
                                    resultRef.set((Object)(process2.waitFor() == 0 ? 1 : 0));
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                finally {
                                    semaphore.release();
                                }
                            }
                        };
                        waiter.start();
                        try {
                            do {
                                indicator.checkCanceled();
                            } while (!semaphore.tryAcquire(200L, TimeUnit.MILLISECONDS));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            waiter.interrupt();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffToolUtil$1", "run"));
                    }
                });
                success = resultRef.get() == Boolean.TRUE;
            } else {
                ProgressManager.getInstance().run((Task)new Task.Modal(project, "Launching External Tool...", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        indicator.setIndeterminate(true);
                        TimeoutUtil.sleep((long)1000L);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffToolUtil$2", "run"));
                    }
                });
                boolean bl = success = Messages.showYesNoDialog((Project)project, (String)"Press \"Mark as Resolved\" when you finish resolving conflicts in the external tool", (String)"Merge In External Tool", (String)"Mark as Resolved", (String)"Revert", null) == 0;
            }
            if (success) {
                outputFile.apply();
            }
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
        }
        catch (Throwable throwable) {
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
            if (outputFile != null) {
                outputFile.cleanup();
            }
            for (InputFile file2 : inputFiles) {
                file2.cleanup();
            }
            throw throwable;
        }
        if (outputFile != null) {
            outputFile.cleanup();
        }
        for (InputFile file3 : inputFiles) {
            file3.cleanup();
        }
    }

    @NotNull
    private static Process execute(@NotNull String exePath, @NotNull String parametersTemplate, @NotNull Map<String, String> patterns) throws ExecutionException {
        if (exePath == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(30);
        }
        if (parametersTemplate == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(31);
        }
        if (patterns == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(32);
        }
        List parameters = ParametersListUtil.parse((String)parametersTemplate, (boolean)true);
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        for (Map.Entry<String, String> entry : patterns.entrySet()) {
            from.add(entry.getKey());
            to.add(entry.getValue());
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String parameter : parameters) {
            String arg = StringUtil.replace((String)parameter, from, to);
            if (StringUtil.isEmptyOrSpaces((String)arg)) continue;
            args.add(arg);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(exePath);
        generalCommandLine.addParameters(args);
        Process process2 = generalCommandLine.createProcess();
        if (process2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(33);
        }
        return process2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersTemplate";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentCharset";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreateFile";
                break;
            }
            case 1: 
            case 2: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 33: {
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContentCharset";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createOutputFile";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "executeMerge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileNameInfo {
        @NotNull
        public final String prefix;
        @NotNull
        public final String name;

        FileNameInfo(@NotNull String prefix, @NotNull String name) {
            if (prefix == null) {
                FileNameInfo.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FileNameInfo.$$$reportNull$$$0(1);
            }
            this.prefix = prefix;
            this.name = name;
        }

        @NotNull
        public static FileNameInfo create(@NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle, int index) {
            if (contents == null) {
                FileNameInfo.$$$reportNull$$$0(2);
            }
            if (titles == null) {
                FileNameInfo.$$$reportNull$$$0(3);
            }
            if (contents.size() == 2) {
                Side side = Side.fromIndex((int)index);
                DiffContent content2 = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"before", (Object)"after");
                String name = FileNameInfo.getFileName(content2, title, windowTitle);
                FileNameInfo fileNameInfo = new FileNameInfo(prefix, name);
                if (fileNameInfo == null) {
                    FileNameInfo.$$$reportNull$$$0(4);
                }
                return fileNameInfo;
            }
            if (contents.size() == 3) {
                ThreeSide side = ThreeSide.fromIndex((int)index);
                DiffContent content3 = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"left", (Object)"base", (Object)"right");
                String name = FileNameInfo.getFileName(content3, title, windowTitle);
                FileNameInfo fileNameInfo = new FileNameInfo(prefix, name);
                if (fileNameInfo == null) {
                    FileNameInfo.$$$reportNull$$$0(5);
                }
                return fileNameInfo;
            }
            throw new IllegalArgumentException(String.valueOf(contents.size()));
        }

        @NotNull
        public static FileNameInfo createMergeResult(@NotNull DiffContent content2, @Nullable String windowTitle) {
            if (content2 == null) {
                FileNameInfo.$$$reportNull$$$0(6);
            }
            String name = FileNameInfo.getFileName(content2, null, windowTitle);
            FileNameInfo fileNameInfo = new FileNameInfo("merge_result", name);
            if (fileNameInfo == null) {
                FileNameInfo.$$$reportNull$$$0(7);
            }
            return fileNameInfo;
        }

        @NotNull
        private static String getFileName(@NotNull DiffContent content2, @Nullable String title, @Nullable String windowTitle) {
            String ext;
            if (content2 == null) {
                FileNameInfo.$$$reportNull$$$0(8);
            }
            if (content2 instanceof EmptyContent) {
                if ("no_content.tmp" == null) {
                    FileNameInfo.$$$reportNull$$$0(9);
                }
                return "no_content.tmp";
            }
            String fileName2 = (String)content2.getUserData(DiffUserDataKeysEx.FILE_NAME);
            if (fileName2 == null && content2 instanceof DocumentContent) {
                VirtualFile highlightFile = ((DocumentContent)content2).getHighlightFile();
                String string = fileName2 = highlightFile != null ? highlightFile.getName() : null;
            }
            if (fileName2 == null && content2 instanceof FileContent) {
                fileName2 = ((FileContent)content2).getFile().getName();
            }
            if (!StringUtil.isEmptyOrSpaces((String)fileName2)) {
                String string = fileName2;
                if (string == null) {
                    FileNameInfo.$$$reportNull$$$0(10);
                }
                return string;
            }
            FileType fileType = content2.getContentType();
            String string = ext = fileType != null ? fileType.getDefaultExtension() : null;
            if (StringUtil.isEmptyOrSpaces((String)ext)) {
                ext = "tmp";
            }
            String name = "";
            if (title != null && windowTitle != null) {
                name = title + "_" + windowTitle;
            } else if (title != null || windowTitle != null) {
                String string2 = name = title != null ? title : windowTitle;
            }
            if (name.length() > 50) {
                name = name.substring(0, 50);
            }
            String string3 = PathUtil.suggestFileName((String)(name + "." + ext), (boolean)true, (boolean)false);
            if (string3 == null) {
                FileNameInfo.$$$reportNull$$$0(11);
            }
            return string3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contents";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titles";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMergeResult";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createMergeResult";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TempInputFile
    implements InputFile {
        @NotNull
        protected final File myLocalFile;

        TempInputFile(@NotNull File localFile) {
            if (localFile == null) {
                TempInputFile.$$$reportNull$$$0(0);
            }
            this.myLocalFile = localFile;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myLocalFile.getPath();
            if (string == null) {
                TempInputFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void cleanup() {
            FileUtil.delete((File)this.myLocalFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LocalInputFile
    implements InputFile {
        @NotNull
        protected final VirtualFile myFile;

        LocalInputFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                LocalInputFile.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myFile.getPath();
            if (string == null) {
                LocalInputFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void cleanup() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DocumentOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final Document myDocument;
        @NotNull
        private final Charset myCharset;

        DocumentOutputFile(@NotNull Document document, @NotNull Charset charset, @NotNull File localFile) {
            if (document == null) {
                DocumentOutputFile.$$$reportNull$$$0(0);
            }
            if (charset == null) {
                DocumentOutputFile.$$$reportNull$$$0(1);
            }
            if (localFile == null) {
                DocumentOutputFile.$$$reportNull$$$0(2);
            }
            super(localFile);
            this.myDocument = document;
            this.myCharset = charset;
        }

        @Override
        public void apply() throws IOException {
            String content2 = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)this.myLocalFile, (Charset)this.myCharset));
            ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)content2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charset";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$DocumentOutputFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NonLocalOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;

        NonLocalOutputFile(@NotNull VirtualFile file2, @NotNull File localFile) {
            if (file2 == null) {
                NonLocalOutputFile.$$$reportNull$$$0(0);
            }
            if (localFile == null) {
                NonLocalOutputFile.$$$reportNull$$$0(1);
            }
            super(localFile);
            this.myFile = file2;
        }

        @Override
        public void apply() throws IOException {
            FileUtil.copy((File)this.myLocalFile, (File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
            VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myFile});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$NonLocalOutputFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LocalOutputFile
    extends LocalInputFile
    implements OutputFile {
        LocalOutputFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                LocalOutputFile.$$$reportNull$$$0(0);
            }
            super(file2);
        }

        @Override
        public void apply() {
            this.myFile.refresh(false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalOutputFile", "<init>"));
        }
    }

    private static interface OutputFile
    extends InputFile {
        public void apply() throws IOException;
    }

    private static interface InputFile {
        @NotNull
        public String getPath();

        public void cleanup();
    }
}

