/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffChange {
    @NotNull
    protected final SimpleDiffViewer myViewer;
    @NotNull
    private final LineFragment myFragment;
    @Nullable
    private final List<DiffFragment> myInnerFragments;
    private final boolean myIsExcluded;
    private final boolean myIsSkipped;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters;
    @NotNull
    protected final List<GutterOperation> myOperations;
    private boolean myIsValid;
    private final int[] myLineStartShifts;
    private final int[] myLineEndShifts;

    public SimpleDiffChange(@NotNull SimpleDiffViewer viewer, @NotNull LineFragment fragment) {
        if (viewer == null) {
            SimpleDiffChange.$$$reportNull$$$0(0);
        }
        if (fragment == null) {
            SimpleDiffChange.$$$reportNull$$$0(1);
        }
        this(viewer, fragment, false, false);
    }

    public SimpleDiffChange(@NotNull SimpleDiffViewer viewer, @NotNull LineFragment fragment, boolean isExcluded, boolean isSkipped) {
        if (viewer == null) {
            SimpleDiffChange.$$$reportNull$$$0(2);
        }
        if (fragment == null) {
            SimpleDiffChange.$$$reportNull$$$0(3);
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<GutterOperation>();
        this.myIsValid = true;
        this.myLineStartShifts = new int[2];
        this.myLineEndShifts = new int[2];
        this.myViewer = viewer;
        this.myFragment = fragment;
        this.myInnerFragments = fragment.getInnerFragments();
        this.myIsExcluded = isExcluded;
        this.myIsSkipped = isSkipped;
    }

    public void installHighlighter(@Nullable LineFragment previousFragment) {
        assert (this.myHighlighters.isEmpty());
        if (this.myInnerFragments != null) {
            this.doInstallHighlighterWithInner();
        } else {
            this.doInstallHighlighterSimple();
        }
        this.doInstallNonSquashedChangesSeparator(previousFragment);
        this.doInstallActionHighlighters();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (GutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    private void doInstallHighlighterSimple() {
        this.createHighlighter(Side.LEFT, false);
        this.createHighlighter(Side.RIGHT, false);
    }

    private void doInstallHighlighterWithInner() {
        assert (this.myInnerFragments != null);
        this.createHighlighter(Side.LEFT, true);
        this.createHighlighter(Side.RIGHT, true);
        for (DiffFragment fragment : this.myInnerFragments) {
            this.createInlineHighlighter(fragment, Side.LEFT);
            this.createInlineHighlighter(fragment, Side.RIGHT);
        }
    }

    private void doInstallNonSquashedChangesSeparator(@Nullable LineFragment previousFragment) {
        this.createNonSquashedChangesSeparator(previousFragment, Side.LEFT);
        this.createNonSquashedChangesSeparator(previousFragment, Side.RIGHT);
    }

    protected void doInstallActionHighlighters() {
        if (this.myIsSkipped) {
            return;
        }
        this.myOperations.add(new AcceptGutterOperation(Side.LEFT));
        this.myOperations.add(new AcceptGutterOperation(Side.RIGHT));
    }

    private void createHighlighter(@NotNull Side side, boolean ignored) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(4);
        }
        EditorEx editor = this.myViewer.getEditor(side);
        TextDiffType type = DiffUtil.getLineDiffType(this.myFragment);
        int startLine = side.getStartLine(this.myFragment);
        int endLine = side.getEndLine(this.myFragment);
        this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withExcludedInEditor(this.myIsSkipped).withExcludedInGutter(this.myIsExcluded).done());
    }

    private void createInlineHighlighter(@NotNull DiffFragment fragment, @NotNull Side side) {
        if (fragment == null) {
            SimpleDiffChange.$$$reportNull$$$0(5);
        }
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(6);
        }
        if (this.myIsSkipped) {
            return;
        }
        int start2 = side.getStartOffset(fragment);
        int end = side.getEndOffset(fragment);
        TextDiffType type = DiffUtil.getDiffType(fragment);
        int startOffset = side.getStartOffset((DiffFragment)this.myFragment);
        EditorEx editor = this.myViewer.getEditor(side);
        this.myHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, start2 += startOffset, end += startOffset, type));
    }

    private void createNonSquashedChangesSeparator(@Nullable LineFragment previousFragment, @NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(7);
        }
        if (previousFragment == null) {
            return;
        }
        int startLine = side.getStartLine(this.myFragment);
        int endLine = side.getEndLine(this.myFragment);
        int prevStartLine = side.getStartLine(previousFragment);
        int prevEndLine = side.getEndLine(previousFragment);
        if (startLine == endLine) {
            return;
        }
        if (prevStartLine == prevEndLine) {
            return;
        }
        if (prevEndLine != startLine) {
            return;
        }
        this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(this.myViewer.getEditor(side), startLine, TextDiffType.MODIFIED));
    }

    public void updateGutterActions(boolean force) {
        for (GutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    public int getStartLine(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(8);
        }
        return side.getStartLine(this.myFragment) + side.select(this.myLineStartShifts);
    }

    public int getEndLine(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(9);
        }
        return side.getEndLine(this.myFragment) + side.select(this.myLineEndShifts);
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getLineDiffType(this.myFragment);
        if (textDiffType == null) {
            SimpleDiffChange.$$$reportNull$$$0(10);
        }
        return textDiffType;
    }

    public boolean isExcluded() {
        return this.myIsExcluded;
    }

    public boolean isSkipped() {
        return this.myIsSkipped;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    @NotNull
    public LineFragment getFragment() {
        LineFragment lineFragment = this.myFragment;
        if (lineFragment == null) {
            SimpleDiffChange.$$$reportNull$$$0(11);
        }
        return lineFragment;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(12);
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        int n = sideIndex;
        this.myLineStartShifts[n] = this.myLineStartShifts[n] + (newRange.startLine - line1);
        int n2 = sideIndex;
        this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + (newRange.endLine - line2);
        if (newRange.damaged) {
            for (GutterOperation operation : this.myOperations) {
                operation.dispose();
            }
            this.myOperations.clear();
            this.myIsValid = false;
        }
        return newRange.damaged;
    }

    public boolean isSelectedByLine(int line2, @NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(13);
        }
        int line1 = this.getStartLine(side);
        int line22 = this.getEndLine(side);
        return DiffUtil.isSelectedByLine(line2, line1, line22);
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(14);
        }
        Icon icon = DiffUtil.getArrowIcon(side);
        String text2 = side == Side.LEFT && this.myViewer.isDiffForLocalChanges() ? "Revert" : "Accept";
        String actionId = (String)side.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide");
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
        String shortcutsText = StringUtil.nullize((String)KeymapUtil.getShortcutsText((Shortcut[])shortcuts));
        String tooltipText = DiffUtil.createTooltipText(text2, shortcutsText);
        return this.createIconRenderer(side, tooltipText, icon, () -> this.myViewer.replaceChange(this, side));
    }

    @Nullable
    private GutterIconRenderer createAppendRenderer(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(15);
        }
        return this.createIconRenderer(side, "Append", DiffUtil.getArrowDownIcon(side), () -> this.myViewer.appendChange(this, side));
    }

    @Nullable
    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull String tooltipText, @NotNull Icon icon, final @NotNull Runnable perform) {
        if (sourceSide == null) {
            SimpleDiffChange.$$$reportNull$$$0(16);
        }
        if (tooltipText == null) {
            SimpleDiffChange.$$$reportNull$$$0(17);
        }
        if (icon == null) {
            SimpleDiffChange.$$$reportNull$$$0(18);
        }
        if (perform == null) {
            SimpleDiffChange.$$$reportNull$$$0(19);
        }
        if (!DiffUtil.isEditable(this.myViewer.getEditor(sourceSide.other()))) {
            return null;
        }
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (!SimpleDiffChange.this.myIsValid) {
                    return;
                }
                Project project = SimpleDiffChange.this.myViewer.getProject();
                DocumentEx document = SimpleDiffChange.this.myViewer.getEditor(sourceSide.other()).getDocument();
                DiffUtil.executeWriteCommand(document, project, "Replace change", perform);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffChange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffChange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInlineHighlighter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNonSquashedChangesSeparator";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStartLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEndLine";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processChange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedByLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createApplyRenderer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAppendRenderer";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AcceptGutterOperation
    extends GutterOperation {
        AcceptGutterOperation(Side side) {
            if (side == null) {
                AcceptGutterOperation.$$$reportNull$$$0(0);
            }
            super(side);
        }

        @Override
        @Nullable
        public GutterIconRenderer createRenderer() {
            boolean isAppendable;
            this.myCtrlPressed = SimpleDiffChange.this.myViewer.getModifierProvider().isCtrlPressed();
            boolean isOtherEditable = DiffUtil.isEditable(SimpleDiffChange.this.myViewer.getEditor(this.mySide.other()));
            boolean bl = isAppendable = SimpleDiffChange.this.myFragment.getStartLine1() != SimpleDiffChange.this.myFragment.getEndLine1() && SimpleDiffChange.this.myFragment.getStartLine2() != SimpleDiffChange.this.myFragment.getEndLine2();
            if (isOtherEditable) {
                if (this.myCtrlPressed && isAppendable) {
                    return SimpleDiffChange.this.createAppendRenderer(this.mySide);
                }
                return SimpleDiffChange.this.createApplyRenderer(this.mySide);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange$AcceptGutterOperation", "<init>"));
        }
    }

    protected abstract class GutterOperation {
        @NotNull
        protected final Side mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;
        protected boolean myCtrlPressed;

        public GutterOperation(Side side) {
            if (side == null) {
                GutterOperation.$$$reportNull$$$0(0);
            }
            this.mySide = side;
            int offset = side.getStartOffset((DiffFragment)SimpleDiffChange.this.myFragment);
            EditorEx editor = SimpleDiffChange.this.myViewer.getEditor(side);
            this.myHighlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
            this.update(true);
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update(boolean force) {
            if (!force && !this.areModifiersChanged()) {
                return;
            }
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        private boolean areModifiersChanged() {
            return this.myCtrlPressed != SimpleDiffChange.this.myViewer.getModifierProvider().isCtrlPressed();
        }

        @Nullable
        public abstract GutterIconRenderer createRenderer();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange$GutterOperation", "<init>"));
        }
    }
}

