/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.pointers.FacetPointerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointerListener;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FacetPointersManagerImpl
extends FacetPointersManager
implements BaseComponent {
    private final Map<String, FacetPointerImpl> myPointers;
    private final Map<Class<? extends Facet>, EventDispatcher<FacetPointerListener>> myDispatchers;
    @NotNull
    private final Project myProject;

    public FacetPointersManagerImpl(@NotNull Project project) {
        if (project == null) {
            FacetPointersManagerImpl.$$$reportNull$$$0(0);
        }
        this.myPointers = new HashMap<String, FacetPointerImpl>();
        this.myDispatchers = new HashMap<Class<? extends Facet>, EventDispatcher<FacetPointerListener>>();
        this.myProject = project;
    }

    public <F extends Facet> FacetPointer<F> create(F facet) {
        String id = FacetPointersManagerImpl.constructId(facet);
        FacetPointerImpl<F> pointer = this.myPointers.get(id);
        if (pointer == null) {
            if (!FacetUtil.isRegistered(facet)) {
                return this.create(id);
            }
            pointer = new FacetPointerImpl<F>(this, facet);
            this.myPointers.put(id, pointer);
        }
        return pointer;
    }

    public <F extends Facet> FacetPointer<F> create(String id) {
        FacetPointerImpl pointer = this.myPointers.get(id);
        if (pointer == null) {
            pointer = new FacetPointerImpl(this, id);
            this.myPointers.put(id, pointer);
        }
        return pointer;
    }

    <F extends Facet> void dispose(FacetPointer<F> pointer) {
        this.myPointers.remove(pointer.getId());
    }

    public void initComponent() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                FacetPointersManagerImpl.this.refreshPointers(module);
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (modules == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (oldNameProvider == null) {
                    1.$$$reportNull$$$0(4);
                }
                for (Module module : modules) {
                    FacetPointersManagerImpl.this.refreshPointers(module);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(0);
                }
                FacetPointersManagerImpl.this.refreshPointers(facet.getModule());
            }

            public void beforeFacetRenamed(@NotNull Facet facet) {
                FacetPointerImpl pointer;
                if (facet == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((pointer = (FacetPointerImpl)FacetPointersManagerImpl.this.myPointers.get(FacetPointersManager.constructId((Facet)facet))) != null) {
                    pointer.refresh();
                }
            }

            public void facetRenamed(@NotNull Facet facet, @NotNull String oldName) {
                if (facet == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (oldName == null) {
                    2.$$$reportNull$$$0(3);
                }
                FacetPointersManagerImpl.this.refreshPointers(facet.getModule());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "facet";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFacetRenamed";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            this.refreshPointers(module);
        }
    }

    private void refreshPointers(@NotNull Module module) {
        if (module == null) {
            FacetPointersManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<Pair> changed = new ArrayList<Pair>();
        for (FacetPointerImpl pointer : this.myPointers.values()) {
            String oldId = pointer.getId();
            pointer.refresh();
            if (oldId.equals(pointer.getId())) continue;
            changed.add(Pair.create((Object)pointer, (Object)oldId));
        }
        for (Pair pair : changed) {
            Class facetClass;
            FacetPointerImpl pointer = (FacetPointerImpl)pair.getFirst();
            Object facet = pointer.getFacet();
            Class clazz = facetClass = facet != null ? facet.getClass() : Facet.class;
            while (facetClass != Object.class) {
                EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
                if (dispatcher != null) {
                    ((FacetPointerListener)dispatcher.getMulticaster()).pointerIdChanged((FacetPointer)pointer, (String)pair.getSecond());
                }
                facetClass = facetClass.getSuperclass();
            }
        }
    }

    public boolean isRegistered(FacetPointer<?> pointer) {
        return this.myPointers.containsKey(pointer.getId());
    }

    public void addListener(FacetPointerListener<Facet> listener2) {
        this.addListener(Facet.class, listener2);
    }

    public void removeListener(FacetPointerListener<Facet> listener2) {
        this.removeListener(Facet.class, listener2);
    }

    public void addListener(FacetPointerListener<Facet> listener2, Disposable parentDisposable) {
        this.addListener(Facet.class, listener2, parentDisposable);
    }

    public <F extends Facet> void addListener(final Class<F> facetClass, final FacetPointerListener<F> listener2, Disposable parentDisposable) {
        this.addListener(facetClass, listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FacetPointersManagerImpl.this.removeListener(facetClass, listener2);
            }
        });
    }

    public <F extends Facet> void addListener(Class<F> facetClass, FacetPointerListener<F> listener2) {
        EventDispatcher dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(FacetPointerListener.class);
            this.myDispatchers.put(facetClass, (EventDispatcher<FacetPointerListener>)dispatcher);
        }
        dispatcher.addListener(listener2);
    }

    public <F extends Facet> void removeListener(Class<F> facetClass, FacetPointerListener<F> listener2) {
        EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher != null) {
            dispatcher.removeListener(listener2);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FacetPointersManagerImpl.$$$reportNull$$$0(2);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshPointers";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

