/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.DetectedFrameworksData;
import com.intellij.framework.detection.impl.FrameworkDetectionContextImpl;
import com.intellij.framework.detection.impl.FrameworkDetectionIndex;
import com.intellij.framework.detection.impl.FrameworkDetectionIndexListener;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.framework.detection.impl.exclude.DetectionExcludesConfigurationImpl;
import com.intellij.framework.detection.impl.ui.ConfigureDetectedFrameworksDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.PlatformModifiableModelsProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class FrameworkDetectionManager
implements FrameworkDetectionIndexListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(FrameworkDetectionManager.class);
    private static final NotificationGroup FRAMEWORK_DETECTION_NOTIFICATION = NotificationGroup.balloonGroup((String)"Framework Detection");
    private final Update myDetectionUpdate;
    private final Set<Integer> myDetectorsToProcess;
    private final Project myProject;
    private MergingUpdateQueue myDetectionQueue;
    private final Object myLock;
    private DetectedFrameworksData myDetectedFrameworksData;

    public static FrameworkDetectionManager getInstance(@NotNull Project project) {
        if (project == null) {
            FrameworkDetectionManager.$$$reportNull$$$0(0);
        }
        return (FrameworkDetectionManager)project.getComponent(FrameworkDetectionManager.class);
    }

    public FrameworkDetectionManager(@NotNull Project project) {
        if (project == null) {
            FrameworkDetectionManager.$$$reportNull$$$0(1);
        }
        this.myDetectionUpdate = new Update("detection"){

            public void run() {
                FrameworkDetectionManager.this.doRunDetection();
            }
        };
        this.myDetectorsToProcess = new HashSet<Integer>();
        this.myLock = new Object();
        this.myProject = project;
        if (!this.myProject.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.doInitialize();
        }
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(() -> {
            Collection<Integer> ids = FrameworkDetectorRegistry.getInstance().getAllDetectorIds();
            Object object = this.myLock;
            synchronized (object) {
                this.myDetectorsToProcess.clear();
                this.myDetectorsToProcess.addAll(ids);
            }
            this.queueDetection();
        });
    }

    public void doInitialize() {
        this.myDetectionQueue = new MergingUpdateQueue("FrameworkDetectionQueue", 500, true, null, (Disposable)this.myProject);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myDetectionQueue.setPassThrough(false);
            this.myDetectionQueue.hideNotify();
        }
        this.myDetectedFrameworksData = new DetectedFrameworksData(this.myProject);
        FrameworkDetectionIndex.getInstance().addListener(this, (Disposable)this.myProject);
        this.myProject.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FrameworkDetectionManager.this.myDetectionQueue.suspend();
            }

            public void exitDumbMode() {
                FrameworkDetectionManager.this.myDetectionQueue.resume();
            }
        });
    }

    public void dispose() {
        this.doDispose();
    }

    public void doDispose() {
        if (this.myDetectedFrameworksData != null) {
            this.myDetectedFrameworksData.saveDetected();
            this.myDetectedFrameworksData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileUpdated(@NotNull VirtualFile file2, @NotNull Integer detectorId) {
        if (file2 == null) {
            FrameworkDetectionManager.$$$reportNull$$$0(2);
        }
        if (detectorId == null) {
            FrameworkDetectionManager.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myDetectorsToProcess.add(detectorId);
        }
        this.queueDetection();
    }

    private void queueDetection() {
        if (this.myDetectionQueue != null) {
            this.myDetectionQueue.queue(this.myDetectionUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunDetection() {
        HashSet<Integer> detectorsToProcess;
        Object object = this.myLock;
        synchronized (object) {
            detectorsToProcess = new HashSet<Integer>(this.myDetectorsToProcess);
            detectorsToProcess.addAll(this.myDetectorsToProcess);
            this.myDetectorsToProcess.clear();
        }
        if (detectorsToProcess.isEmpty()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting framework detectors: " + detectorsToProcess);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        ArrayList<? extends DetectedFrameworkDescription> newDescriptions = new ArrayList<DetectedFrameworkDescription>();
        ArrayList<? extends DetectedFrameworkDescription> oldDescriptions = new ArrayList<DetectedFrameworkDescription>();
        DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)this.myProject);
        for (Integer n : detectorsToProcess) {
            List<? extends DetectedFrameworkDescription> list2 = this.runDetector(n, index, excludesConfiguration, true);
            oldDescriptions.addAll(list2);
            Collection<? extends DetectedFrameworkDescription> updated = this.myDetectedFrameworksData.updateFrameworksList(n, list2);
            newDescriptions.addAll(updated);
            oldDescriptions.removeAll(updated);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(list2.size() + " frameworks detected, " + updated.size() + " changed");
        }
        HashSet<String> frameworkNames = new HashSet<String>();
        for (DetectedFrameworkDescription detectedFrameworkDescription : FrameworkDetectionUtil.removeDisabled(newDescriptions, oldDescriptions)) {
            frameworkNames.add(detectedFrameworkDescription.getDetector().getFrameworkType().getPresentableName());
        }
        if (!frameworkNames.isEmpty()) {
            String string = StringUtil.join(frameworkNames, (String)", ");
            String string2 = ProjectBundle.message((String)"framework.detected.info.text", (Object[])new Object[]{string, frameworkNames.size()});
            FRAMEWORK_DETECTION_NOTIFICATION.createNotification("Frameworks Detected", string2, NotificationType.INFORMATION, null).addAction((AnAction)new NotificationAction("Configure"){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    FrameworkDetectionManager.this.showSetupFrameworksDialog(notification);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/framework/detection/impl/FrameworkDetectionManager$3";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).notify(this.myProject);
        }
    }

    private List<? extends DetectedFrameworkDescription> runDetector(Integer detectorId, FileBasedIndex index, DetectionExcludesConfiguration excludesConfiguration, boolean processNewFilesOnly) {
        Collection acceptedFiles = index.getContainingFiles(FrameworkDetectionIndex.NAME, (Object)detectorId, GlobalSearchScope.projectScope((Project)this.myProject));
        Collection<Object> filesToProcess = processNewFilesOnly ? this.myDetectedFrameworksData.retainNewFiles(detectorId, acceptedFiles) : new ArrayList(acceptedFiles);
        FrameworkDetector detector = FrameworkDetectorRegistry.getInstance().getDetectorById(detectorId);
        if (detector == null) {
            LOG.info("Framework detector not found by id " + detectorId);
            return Collections.emptyList();
        }
        ((DetectionExcludesConfigurationImpl)excludesConfiguration).removeExcluded(filesToProcess, detector.getFrameworkType());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector '" + detector.getDetectorId() + "': " + acceptedFiles.size() + " accepted files, " + filesToProcess.size() + " files to process");
        }
        List frameworks = !filesToProcess.isEmpty() ? detector.detect(filesToProcess, (FrameworkDetectionContext)new FrameworkDetectionContextImpl(this.myProject)) : Collections.emptyList();
        return frameworks;
    }

    private void showSetupFrameworksDialog(Notification notification) {
        List<? extends DetectedFrameworkDescription> descriptions;
        try {
            descriptions = this.getValidDetectedFrameworks();
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification("Information about detected frameworks is not available until indices are built");
            return;
        }
        if (descriptions.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)"No frameworks are detected", (String)"Framework Detection");
            return;
        }
        ConfigureDetectedFrameworksDialog dialog2 = new ConfigureDetectedFrameworksDialog(this.myProject, descriptions);
        if (dialog2.showAndGet()) {
            notification.expire();
            List<DetectedFrameworkDescription> selected2 = dialog2.getSelectedFrameworks();
            FrameworkDetectionUtil.setupFrameworks(selected2, new PlatformModifiableModelsProvider(), (ModulesProvider)new DefaultModulesProvider(this.myProject));
            for (DetectedFrameworkDescription description : selected2) {
                int detectorId = FrameworkDetectorRegistry.getInstance().getDetectorId(description.getDetector());
                this.myDetectedFrameworksData.putExistentFrameworkFiles(detectorId, description.getRelatedFiles());
            }
        }
    }

    private List<? extends DetectedFrameworkDescription> getValidDetectedFrameworks() {
        Set<Integer> detectors = this.myDetectedFrameworksData.getDetectorsForDetectedFrameworks();
        ArrayList<? extends DetectedFrameworkDescription> descriptions = new ArrayList<DetectedFrameworkDescription>();
        FileBasedIndex index = FileBasedIndex.getInstance();
        DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)this.myProject);
        for (Integer id : detectors) {
            List<? extends DetectedFrameworkDescription> frameworks = this.runDetector(id, index, excludesConfiguration, false);
            descriptions.addAll(frameworks);
        }
        return FrameworkDetectionUtil.removeDisabled(descriptions);
    }

    public void runDetection() {
        FrameworkDetectionManager.ensureIndexIsUpToDate(this.myProject, FrameworkDetectorRegistry.getInstance().getAllDetectorIds());
        this.doRunDetection();
    }

    public List<? extends DetectedFrameworkDescription> getDetectedFrameworks() {
        return this.getValidDetectedFrameworks();
    }

    private static void ensureIndexIsUpToDate(@NotNull Project project, Collection<Integer> detectors) {
        if (project == null) {
            FrameworkDetectionManager.$$$reportNull$$$0(4);
        }
        for (Integer detectorId : detectors) {
            FileBasedIndex.getInstance().getValues(FrameworkDetectionIndex.NAME, (Object)detectorId, GlobalSearchScope.projectScope((Project)project));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectorId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileUpdated";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureIndexIsUpToDate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FrameworkDetectionHighlightingPass
    extends TextEditorHighlightingPass {
        private final Collection<Integer> myDetectors;

        FrameworkDetectionHighlightingPass(@NotNull Project project, Editor editor, Collection<Integer> detectors) {
            if (project == null) {
                FrameworkDetectionHighlightingPass.$$$reportNull$$$0(0);
            }
            super(project, editor.getDocument(), false);
            this.myDetectors = detectors;
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                FrameworkDetectionHighlightingPass.$$$reportNull$$$0(1);
            }
            FrameworkDetectionManager.ensureIndexIsUpToDate(this.myProject, this.myDetectors);
        }

        @Override
        public void doApplyInformationToEditor() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionManager$FrameworkDetectionHighlightingPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectInformation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class FrameworkDetectionHighlightingPassFactory
    implements TextEditorHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar {
        FrameworkDetectionHighlightingPassFactory() {
        }

        @Override
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            if (registrar == null) {
                FrameworkDetectionHighlightingPassFactory.$$$reportNull$$$0(0);
            }
            if (project == null) {
                FrameworkDetectionHighlightingPassFactory.$$$reportNull$$$0(1);
            }
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.LAST, -1, false, false);
        }

        @Override
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            Collection<Integer> detectors;
            if (file2 == null) {
                FrameworkDetectionHighlightingPassFactory.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                FrameworkDetectionHighlightingPassFactory.$$$reportNull$$$0(3);
            }
            if (!(detectors = FrameworkDetectorRegistry.getInstance().getDetectorIds(file2.getFileType())).isEmpty()) {
                return new FrameworkDetectionHighlightingPass(file2.getProject(), editor, detectors);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registrar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionManager$FrameworkDetectionHighlightingPassFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerHighlightingPassFactory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHighlightingPass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

