/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.ide.bookmarks.actions.MnemonicChooser;
import com.intellij.ide.bookmarks.actions.ToggleBookmarkAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ToggleBookmarkWithMnemonicAction
extends ToggleBookmarkAction {
    private boolean myPopupShown;

    public ToggleBookmarkWithMnemonicAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"action.bookmark.toggle.mnemonic", (Object[])new Object[0]));
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleBookmarkWithMnemonicAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setEnabled(!this.myPopupShown);
        e.getPresentation().setText(IdeBundle.message((String)"action.bookmark.toggle.mnemonic", (Object[])new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleBookmarkWithMnemonicAction.$$$reportNull$$$0(1);
        }
        super.actionPerformed(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        BookmarksAction.BookmarkInContextInfo info = new BookmarksAction.BookmarkInContextInfo(e.getDataContext(), project).invoke();
        final Bookmark bookmark = info.getBookmarkAtPlace();
        final BookmarkManager bookmarks = BookmarkManager.getInstance(project);
        if (bookmark != null) {
            final JBPopup[] popup2 = new JBPopup[1];
            MnemonicChooser mc = new MnemonicChooser(){

                @Override
                protected void onMnemonicChosen(char c2) {
                    popup2[0].cancel();
                    bookmarks.setMnemonic(bookmark, c2);
                }

                @Override
                protected void onCancelled() {
                    popup2[0].cancel();
                    bookmarks.removeBookmark(bookmark);
                }

                @Override
                protected boolean isOccupied(char c2) {
                    return bookmarks.findBookmarkForMnemonic(c2) != null;
                }
            };
            popup2[0] = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)mc, (JComponent)mc).setTitle("Bookmark Mnemonic").setFocusable(true).setRequestFocus(true).setMovable(false).setCancelKeyEnabled(false).setAdText(bookmarks.hasBookmarksWithMnemonics() ? (UIUtil.isUnderDarcula() ? "Brown" : "Yellow") + " cells are in use" : null).setResizable(false).createPopup();
            popup2[0].addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ToggleBookmarkWithMnemonicAction.this.myPopupShown = false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/bookmarks/actions/ToggleBookmarkWithMnemonicAction$2", "onClosed"));
                }
            });
            popup2[0].showInBestPositionFor(e.getDataContext());
            this.myPopupShown = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/bookmarks/actions/ToggleBookmarkWithMnemonicAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

