/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd.aware;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.dnd.TransferableList;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnDAwareTree
extends Tree
implements DnDAware {
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent component) {
            JTree tree;
            TreePath[] selection;
            if (component instanceof JTree && (selection = (tree = (JTree)component).getSelectionPaths()) != null && selection.length > 1) {
                return new TransferableList<TreePath>(selection){

                    @Override
                    protected String toString(TreePath path) {
                        return String.valueOf(path.getLastPathComponent());
                    }
                };
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c2) {
            return 3;
        }
    };

    public DnDAwareTree() {
        this.initDnD();
    }

    public DnDAwareTree(TreeModel treemodel) {
        super(treemodel);
        this.initDnD();
    }

    public DnDAwareTree(TreeNode root) {
        super(root);
        this.initDnD();
    }

    public void processMouseEvent(MouseEvent e) {
        if (this.getToolTipText() == null && e.getID() == 504) {
            return;
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (SystemInfo.isMac && JBSwingUtilities.isRightMouseButton((MouseEvent)e) && e.getID() == 506) {
            return;
        }
        super.processMouseMotionEvent(e);
    }

    public final boolean isOverSelection(Point point) {
        TreePath path;
        TreePath treePath = path = WideSelectionTreeUI.isWideSelection((JTree)((Object)this)) ? this.getClosestPathForLocation(point.x, point.y) : this.getPathForLocation(point.x, point.y);
        if (path == null) {
            return false;
        }
        return this.isPathSelected(path);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @NotNull
    public final JComponent getComponent() {
        DnDAwareTree dnDAwareTree = this;
        if (dnDAwareTree == null) {
            DnDAwareTree.$$$reportNull$$$0(0);
        }
        return dnDAwareTree;
    }

    @NotNull
    public static Pair<Image, Point> getDragImage(@NotNull Tree dndAwareTree, @NotNull TreePath path, @NotNull Point dragOrigin) {
        if (dndAwareTree == null) {
            DnDAwareTree.$$$reportNull$$$0(1);
        }
        if (path == null) {
            DnDAwareTree.$$$reportNull$$$0(2);
        }
        if (dragOrigin == null) {
            DnDAwareTree.$$$reportNull$$$0(3);
        }
        int row = dndAwareTree.getRowForPath(path);
        Component comp = dndAwareTree.getCellRenderer().getTreeCellRendererComponent((JTree)dndAwareTree, path.getLastPathComponent(), false, true, true, row, false);
        Pair<Image, Point> pair = DnDAwareTree.createDragImage(dndAwareTree, comp, dragOrigin, true);
        if (pair == null) {
            DnDAwareTree.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    public static Pair<Image, Point> getDragImage(@NotNull Tree dndAwareTree, @NotNull String text2, @Nullable Point dragOrigin) {
        if (dndAwareTree == null) {
            DnDAwareTree.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            DnDAwareTree.$$$reportNull$$$0(6);
        }
        Pair<Image, Point> pair = DnDAwareTree.createDragImage(dndAwareTree, new JLabel(text2), dragOrigin, false);
        if (pair == null) {
            DnDAwareTree.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @NotNull
    private static Pair<Image, Point> createDragImage(@NotNull Tree tree, @NotNull Component c2, @Nullable Point dragOrigin, boolean adjustToPathUnderDragOrigin) {
        TreePath path;
        if (tree == null) {
            DnDAwareTree.$$$reportNull$$$0(8);
        }
        if (c2 == null) {
            DnDAwareTree.$$$reportNull$$$0(9);
        }
        if (c2 instanceof JComponent) {
            ((JComponent)c2).setOpaque(true);
        }
        c2.setForeground(tree.getForeground());
        c2.setBackground(tree.getBackground());
        c2.setFont(tree.getFont());
        c2.setSize(c2.getPreferredSize());
        BufferedImage image = UIUtil.createImage((Component)c2, (int)c2.getWidth(), (int)c2.getHeight(), (int)2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
        c2.paint(g2);
        g2.dispose();
        Point point = new Point(image.getWidth(null) / 2, image.getHeight(null) / 2);
        if (adjustToPathUnderDragOrigin && (path = tree.getPathForLocation(dragOrigin.x, dragOrigin.y)) != null) {
            Rectangle bounds2 = tree.getPathBounds(path);
            point = new Point(dragOrigin.x - bounds2.x, dragOrigin.y - bounds2.y);
        }
        Pair pair = new Pair((Object)image, (Object)point);
        if (pair == null) {
            DnDAwareTree.$$$reportNull$$$0(10);
        }
        return pair;
    }

    private void initDnD() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
            this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/aware/DnDAwareTree";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dndAwareTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragOrigin";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/aware/DnDAwareTree";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDragImage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDragImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDragImage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDragImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

