/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.BgProgressIndicator;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.wm.ex.StatusBarEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallPluginInfo {
    public final BgProgressIndicator indicator;
    private final IdeaPluginDescriptor myDescriptor;
    private MyPluginModel myPluginModel;
    public final boolean install;
    public final IdeaPluginDescriptor updateDescriptor;
    private TaskInfo myStatusBarTaskInfo;

    public InstallPluginInfo(@NotNull IdeaPluginDescriptor descriptor2, IdeaPluginDescriptor updateDescriptor, @NotNull MyPluginModel pluginModel, boolean install) {
        if (descriptor2 == null) {
            InstallPluginInfo.$$$reportNull$$$0(0);
        }
        if (pluginModel == null) {
            InstallPluginInfo.$$$reportNull$$$0(1);
        }
        this.indicator = new BgProgressIndicator();
        this.myDescriptor = descriptor2;
        this.updateDescriptor = updateDescriptor;
        this.myPluginModel = pluginModel;
        this.install = install;
    }

    public synchronized void toBackground(@Nullable StatusBarEx statusBar) {
        this.myPluginModel = null;
        this.indicator.removeStateDelegate(null);
        if (statusBar != null) {
            String title = (this.install ? "Installing plugin " : "Update plugin ") + this.myDescriptor.getName();
            this.myStatusBarTaskInfo = OneLineProgressIndicator.task(title);
            statusBar.addProgress(this.indicator, this.myStatusBarTaskInfo);
        }
    }

    public synchronized void fromBackground(@NotNull MyPluginModel pluginModel) {
        if (pluginModel == null) {
            InstallPluginInfo.$$$reportNull$$$0(2);
        }
        this.myPluginModel = pluginModel;
        this.closeStatusBarIndicator();
    }

    public synchronized void finish(boolean success, boolean cancel) {
        if (this.myPluginModel == null) {
            MyPluginModel.finishInstall(this.myDescriptor);
            this.closeStatusBarIndicator();
            if (success) {
                ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0])));
            }
        } else if (!cancel) {
            this.myPluginModel.finishInstall(this.myDescriptor, success, true);
        }
    }

    private void closeStatusBarIndicator() {
        if (this.myStatusBarTaskInfo != null) {
            this.indicator.finish(this.myStatusBarTaskInfo);
            this.myStatusBarTaskInfo = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/InstallPluginInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fromBackground";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

