/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.LinkPanel;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.TagPanel;
import com.intellij.ide.plugins.newui.BaselinePanel;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.ColorButton;
import com.intellij.ide.plugins.newui.ErrorComponent;
import com.intellij.ide.plugins.newui.GridCellPluginComponent;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MyOptionButton;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.NewListPluginComponent;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.TextHorizontalLayout;
import com.intellij.ide.plugins.newui.UpdateButton;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDetailsPageComponent
extends MultiPanel {
    private final MyPluginModel myPluginModel;
    private final LinkListener<Object> mySearchListener;
    private final boolean myMarketplace;
    private JBPanelWithEmptyText myEmptyPanel;
    private OpaquePanel myPanel;
    private JLabel myIconLabel;
    private final JEditorPane myNameComponent;
    private final BaselinePanel myNameAndButtons;
    private JButton myRestartButton;
    private JButton myInstallButton;
    private JButton myUpdateButton;
    private JButton myEnableDisableButton;
    private JBOptionButton myEnableDisableUninstallButton;
    private JButton myUninstallButton;
    private JComponent myErrorComponent;
    private JTextField myVersion;
    private JLabel myVersionSize;
    private TagPanel myTagPanel;
    private JLabel myDate;
    private JLabel myRating;
    private JLabel myDownloads;
    private JLabel mySize;
    private LinkPanel myVendor;
    private LinkPanel myHomePage;
    private JEditorPane myDescriptionComponent;
    private OneLineProgressIndicator myIndicator;
    public IdeaPluginDescriptor myPlugin;
    private IdeaPluginDescriptor myUpdateDescriptor;

    public PluginDetailsPageComponent(@NotNull MyPluginModel pluginModel, @NotNull LinkListener<Object> searchListener, boolean marketplace) {
        if (pluginModel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(0);
        }
        if (searchListener == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(1);
        }
        this.myNameComponent = PluginDetailsPageComponent.createNameComponent();
        this.myNameAndButtons = new BaselinePanel();
        this.myPluginModel = pluginModel;
        this.mySearchListener = searchListener;
        this.myMarketplace = marketplace;
        this.createPluginPanel();
        this.select(1, true);
        this.setEmptyState(false);
    }

    @Override
    protected JComponent create(Integer key) {
        if (key == 0) {
            return this.myPanel;
        }
        if (key == 1) {
            this.myEmptyPanel = new JBPanelWithEmptyText();
            this.myEmptyPanel.setBorder((Border)new CustomLineBorder(PluginManagerConfigurableNew.SEARCH_FIELD_BORDER_COLOR, (Insets)JBUI.insets((int)1, (int)0, (int)0, (int)0)));
            this.myEmptyPanel.setOpaque(true);
            this.myEmptyPanel.setBackground(PluginManagerConfigurableNew.MAIN_BG_COLOR);
            return this.myEmptyPanel;
        }
        return super.create(key);
    }

    private void createPluginPanel() {
        this.myPanel = new OpaquePanel((LayoutManager)new BorderLayout(0, JBUIScale.scale((int)32)), PluginManagerConfigurableNew.MAIN_BG_COLOR);
        this.myPanel.setBorder((Border)new CustomLineBorder((Color)new JBColor(0xC5C5C5, 0x515151), (Insets)JBUI.insets((int)1, (int)0, (int)0, (int)0)){

            public Insets getBorderInsets(Component c2) {
                return JBUI.insets((int)15, (int)20, (int)0, (int)0);
            }
        });
        this.createHeaderPanel().add(this.createCenterPanel());
        this.createBottomPanel();
    }

    @NotNull
    private JPanel createHeaderPanel() {
        NonOpaquePanel header = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUIScale.scale((int)20), 0));
        header.setBorder((Border)JBUI.Borders.emptyRight((int)20));
        this.myPanel.add((Component)header, (Object)"North");
        this.myIconLabel = new JLabel();
        this.myIconLabel.setVerticalAlignment(1);
        this.myIconLabel.setOpaque(false);
        header.add((Component)this.myIconLabel, "West");
        NonOpaquePanel nonOpaquePanel = header;
        if (nonOpaquePanel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(2);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private JPanel createCenterPanel() {
        int offset = PluginManagerConfigurableNew.offset5();
        NonOpaquePanel centerPanel2 = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(offset)));
        this.myNameAndButtons.setYOffset(JBUIScale.scale((int)3));
        this.myNameAndButtons.add(this.myNameComponent);
        this.createButtons();
        centerPanel2.add((Component)((Object)this.myNameAndButtons), "fill_h");
        if (!this.myMarketplace) {
            this.myErrorComponent = ErrorComponent.create((JPanel)centerPanel2, "fill_h");
        }
        this.createMetricsPanel((JPanel)centerPanel2);
        NonOpaquePanel nonOpaquePanel = centerPanel2;
        if (nonOpaquePanel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(3);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private static JEditorPane createNameComponent() {
        JEditorPane editorPane = new JEditorPane(){
            JLabel myBaselineComponent;

            @Override
            public int getBaseline(int width, int height) {
                if (this.myBaselineComponent == null) {
                    this.myBaselineComponent = new JLabel();
                    this.myBaselineComponent.setFont(this.getFont());
                }
                this.myBaselineComponent.setText(this.getText());
                Dimension size = this.myBaselineComponent.getPreferredSize();
                return this.myBaselineComponent.getBaseline(size.width, size.height);
            }
        };
        ErrorComponent.convertToLabel(editorPane);
        editorPane.setEditorKit(UIUtil.getHTMLEditorKit());
        Font font = editorPane.getFont();
        if (font != null) {
            editorPane.setFont(font.deriveFont(1, 25.0f));
        }
        JEditorPane jEditorPane = editorPane;
        if (jEditorPane == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(4);
        }
        return jEditorPane;
    }

    private void createButtons() {
        this.myRestartButton = new RestartButton(this.myPluginModel);
        this.myNameAndButtons.addButtonComponent(this.myRestartButton);
        this.myUpdateButton = new UpdateButton();
        this.myNameAndButtons.addButtonComponent(this.myUpdateButton);
        this.myUpdateButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this.myPlugin, this.myUpdateDescriptor));
        this.myInstallButton = new InstallButton(true);
        this.myNameAndButtons.addButtonComponent(this.myInstallButton);
        this.myInstallButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this.myPlugin, null));
        this.myEnableDisableButton = new JButton();
        this.myEnableDisableButton.addActionListener(e -> this.changeEnableDisable());
        ColorButton.setWidth72(this.myEnableDisableButton);
        this.myNameAndButtons.addButtonComponent(this.myEnableDisableButton);
        AbstractAction enableDisableAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginDetailsPageComponent.this.changeEnableDisable();
            }
        };
        AbstractAction uninstallAction = new AbstractAction("Uninstall"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginDetailsPageComponent.this.doUninstall();
            }
        };
        this.myEnableDisableUninstallButton = new MyOptionButton(enableDisableAction, uninstallAction);
        this.myNameAndButtons.addButtonComponent((JComponent)this.myEnableDisableUninstallButton);
        this.myUninstallButton = new JButton("Uninstall");
        this.myUninstallButton.addActionListener(e -> this.doUninstall());
        ColorButton.setWidth72(this.myUninstallButton);
        this.myNameAndButtons.addButtonComponent(this.myUninstallButton);
        for (Component component : this.myNameAndButtons.getButtonComponents()) {
            component.setBackground(PluginManagerConfigurableNew.MAIN_BG_COLOR);
        }
    }

    private void createMetricsPanel(@NotNull JPanel centerPanel2) {
        if (centerPanel2 == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(5);
        }
        this.myVersion = new JTextField();
        this.myVersion.putClientProperty("TextFieldWithoutMargins", Boolean.TRUE);
        this.myVersion.setEditable(false);
        this.myVersion.setFont(UIUtil.getLabelFont());
        PluginManagerConfigurableNew.installTiny(this.myVersion);
        this.myVersion.setBorder(null);
        this.myVersion.setOpaque(false);
        this.myVersion.setForeground(CellPluginComponent.GRAY_COLOR);
        this.myVersion.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                int caretPosition = PluginDetailsPageComponent.this.myVersion.getCaretPosition();
                PluginDetailsPageComponent.this.myVersion.setSelectionStart(caretPosition);
                PluginDetailsPageComponent.this.myVersion.setSelectionEnd(caretPosition);
            }
        });
        this.myVersionSize = new JLabel();
        this.myVersionSize.setFont(UIUtil.getLabelFont());
        PluginManagerConfigurableNew.installTiny(this.myVersionSize);
        int offset = JBUIScale.scale((int)10);
        NonOpaquePanel panel1 = new NonOpaquePanel((LayoutManager)((Object)new TextHorizontalLayout(offset)));
        centerPanel2.add((Component)panel1);
        if (this.myMarketplace) {
            this.myDownloads = GridCellPluginComponent.createRatingLabel((JPanel)panel1, null, "", AllIcons.Plugins.Downloads, CellPluginComponent.GRAY_COLOR, false);
            this.myRating = GridCellPluginComponent.createRatingLabel((JPanel)panel1, null, "", AllIcons.Plugins.Rating, CellPluginComponent.GRAY_COLOR, false);
        }
        this.myVendor = new LinkPanel((JPanel)panel1, false, null, "fix_label");
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)new TextHorizontalLayout(this.myMarketplace ? offset : JBUIScale.scale((int)7)){

            @Override
            public void layoutContainer(Container parent) {
                int baseline;
                super.layoutContainer(parent);
                if (PluginDetailsPageComponent.this.myTagPanel != null && PluginDetailsPageComponent.this.myTagPanel.isVisible() && (baseline = PluginDetailsPageComponent.this.myTagPanel.getBaseline(-1, -1)) != -1) {
                    Rectangle versionBounds = PluginDetailsPageComponent.this.myVersion.getBounds();
                    Dimension versionSize = PluginDetailsPageComponent.this.myVersion.getPreferredSize();
                    int versionY = PluginDetailsPageComponent.this.myTagPanel.getY() + baseline - PluginDetailsPageComponent.this.myVersion.getBaseline(versionSize.width, versionSize.height);
                    PluginDetailsPageComponent.this.myVersion.setBounds(versionBounds.x, versionY, versionBounds.width, versionBounds.height);
                    if (PluginDetailsPageComponent.this.myDate.isVisible()) {
                        Rectangle dateBounds = PluginDetailsPageComponent.this.myDate.getBounds();
                        Dimension dateSize = PluginDetailsPageComponent.this.myDate.getPreferredSize();
                        int dateY = PluginDetailsPageComponent.this.myTagPanel.getY() + baseline - PluginDetailsPageComponent.this.myDate.getBaseline(dateSize.width, dateSize.height);
                        PluginDetailsPageComponent.this.myDate.setBounds(dateBounds.x - JBUIScale.scale((int)4), dateY, dateBounds.width, dateBounds.height);
                    }
                }
            }
        }));
        if (this.myMarketplace) {
            this.myTagPanel = new TagPanel(this.mySearchListener);
            panel2.add((Component)((Object)this.myTagPanel));
        }
        panel2.add(this.myVersion);
        this.myDate = GridCellPluginComponent.createRatingLabel((JPanel)panel2, "fix_label", "", null, CellPluginComponent.GRAY_COLOR, true);
        centerPanel2.add((Component)panel2);
    }

    private void createBottomPanel() {
        OpaquePanel bottomPanel = new OpaquePanel((LayoutManager)((Object)new VerticalLayout(PluginManagerConfigurableNew.offset5())), PluginManagerConfigurableNew.MAIN_BG_COLOR);
        bottomPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)15, (int)20));
        JBScrollPane scrollPane = new JBScrollPane((Component)bottomPanel);
        scrollPane.getVerticalScrollBar().setBackground(PluginManagerConfigurableNew.MAIN_BG_COLOR);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(null);
        this.myPanel.add((Component)scrollPane);
        this.myHomePage = new LinkPanel((JPanel)bottomPanel, true, null, null);
        bottomPanel.add(new JLabel());
        this.myDescriptionComponent = new JEditorPane();
        HTMLEditorKit kit = UIUtil.getHTMLEditorKit();
        StyleSheet sheet = kit.getStyleSheet();
        sheet.addRule("ul {margin-left: 16px}");
        sheet.addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor()) + "}");
        this.myDescriptionComponent.setEditable(false);
        this.myDescriptionComponent.setOpaque(false);
        this.myDescriptionComponent.setBorder(null);
        this.myDescriptionComponent.setContentType("text/html");
        this.myDescriptionComponent.setEditorKit(kit);
        this.myDescriptionComponent.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        bottomPanel.add(this.myDescriptionComponent, JBUIScale.scale((int)700), -1);
        JLabel separator = new JLabel();
        separator.setBorder((Border)JBUI.Borders.emptyTop((int)20));
        bottomPanel.add(separator);
        if (this.myMarketplace) {
            this.mySize = new JLabel();
            bottomPanel.add(this.mySize);
        }
    }

    public void showPlugin(@Nullable CellPluginComponent component, boolean multiSelection) {
        if (this.myIndicator != null) {
            MyPluginModel.removeProgress(this.myPlugin, this.myIndicator);
            this.hideProgress(false, false);
        }
        if (component == null) {
            this.myUpdateDescriptor = null;
            this.myPlugin = null;
            this.select(1, true);
            this.setEmptyState(multiSelection);
        } else {
            this.myPlugin = component.myPlugin;
            this.myUpdateDescriptor = ((NewListPluginComponent)component).myUpdateDescriptor;
            this.showPlugin();
            this.select(0, true);
        }
    }

    private void setEmptyState(boolean multiSelection) {
        StatusText text2 = this.myEmptyPanel.getEmptyText();
        text2.clear();
        if (multiSelection) {
            text2.setText("Several plugins selected.");
            text2.appendSecondaryText("Select one plugin to preview plugin details.", StatusText.DEFAULT_ATTRIBUTES, null);
        } else {
            text2.setText("Select plugin to preview details");
        }
    }

    private void showPlugin() {
        String vendor;
        String version2;
        this.myNameComponent.setText("<html><span>" + this.myPlugin.getName() + "</span></html>");
        this.updateIcon();
        if (this.myMarketplace) {
            boolean installed = InstalledPluginsState.getInstance().wasInstalled(this.myPlugin.getPluginId());
            this.myRestartButton.setVisible(installed);
            this.myInstallButton.setEnabled(PluginManager.getPlugin(this.myPlugin.getPluginId()) == null);
            this.myInstallButton.setVisible(!installed);
            this.myUpdateButton.setVisible(false);
            this.myEnableDisableButton.setVisible(false);
            this.myEnableDisableUninstallButton.setVisible(false);
            this.myUninstallButton.setVisible(false);
        } else {
            boolean restart2;
            this.myInstallButton.setVisible(false);
            boolean bl = restart2 = this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted();
            if (!restart2) {
                PluginId id;
                InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
                boolean bl2 = restart2 = pluginsState.wasInstalled(id = this.myPlugin.getPluginId()) || pluginsState.wasUpdated(id);
            }
            if (restart2) {
                this.myRestartButton.setVisible(true);
                this.myUpdateButton.setVisible(false);
                this.myEnableDisableButton.setVisible(false);
                this.myEnableDisableUninstallButton.setVisible(false);
                this.myUninstallButton.setVisible(false);
            } else {
                this.myRestartButton.setVisible(false);
                boolean bundled = this.myPlugin.isBundled();
                String title = this.myPluginModel.getEnabledTitle(this.myPlugin);
                boolean errors = this.myPluginModel.hasErrors(this.myPlugin);
                this.myUpdateButton.setVisible(this.myUpdateDescriptor != null && !errors);
                this.myEnableDisableButton.setVisible(bundled && !errors);
                this.myEnableDisableButton.setText(title);
                this.myEnableDisableUninstallButton.setVisible(!bundled && !errors);
                this.myEnableDisableUninstallButton.setText(title);
                this.myUninstallButton.setVisible(!bundled && errors);
            }
            this.updateEnableForNameAndIcon();
            this.updateErrors();
        }
        boolean bundled = this.myPlugin.isBundled() && !this.myPlugin.allowBundledUpdate();
        String string = version2 = bundled ? "bundled" : this.myPlugin.getVersion();
        if (this.myUpdateDescriptor != null) {
            version2 = this.myPlugin.getVersion() + " " + UIUtil.rightArrow() + " " + this.myUpdateDescriptor.getVersion();
        }
        this.myVersion.setText(version2);
        this.myVersionSize.setText(version2);
        this.myVersion.setPreferredSize(new Dimension(this.myVersionSize.getPreferredSize().width + JBUIScale.scale((int)4), this.myVersion.getPreferredSize().height));
        this.myVersion.setVisible(!StringUtil.isEmptyOrSpaces((String)version2));
        if (this.myMarketplace) {
            this.myTagPanel.setTags(PluginManagerConfigurableNew.getTags(this.myPlugin));
            String rating = PluginManagerConfigurableNew.getRating(this.myPlugin);
            this.myRating.setText(rating);
            this.myRating.setVisible(rating != null);
            String downloads = PluginManagerConfigurableNew.getDownloads(this.myPlugin);
            this.myDownloads.setText(downloads);
            this.myDownloads.setVisible(downloads != null);
            String size = PluginManagerConfigurableNew.getSize(this.myPlugin);
            this.mySize.setText("Size: " + size);
            this.mySize.setVisible(!StringUtil.isEmptyOrSpaces((String)size));
        }
        String string2 = vendor = this.myPlugin.isBundled() ? null : StringUtil.trim((String)this.myPlugin.getVendor());
        if (StringUtil.isEmptyOrSpaces((String)vendor)) {
            this.myVendor.hide();
        } else {
            this.myVendor.show(vendor, () -> this.mySearchListener.linkSelected(null, (Object)("/vendor:" + (vendor.indexOf(32) == -1 ? vendor : StringUtil.wrapWithDoubleQuote((String)vendor)))));
        }
        if (bundled) {
            this.myHomePage.hide();
        } else {
            this.myHomePage.show("Plugin homepage", () -> BrowserUtil.browse((String)("https://plugins.jetbrains.com/plugin/index?xmlId=" + URLUtil.encodeURIComponent((String)this.myPlugin.getPluginId().getIdString()))));
        }
        String date = PluginManagerConfigurableNew.getLastUpdatedDate(this.myUpdateDescriptor == null ? this.myPlugin : this.myUpdateDescriptor);
        this.myDate.setText(date);
        this.myDate.setVisible(date != null);
        String description = this.getDescription();
        if (description != null) {
            this.myDescriptionComponent.setText(XmlStringUtil.wrapInHtml((CharSequence)description));
            if (this.myDescriptionComponent.getCaret() != null) {
                this.myDescriptionComponent.setCaretPosition(0);
            }
        }
        this.myDescriptionComponent.setVisible(description != null);
        if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
            this.showProgress();
        } else {
            this.fullRepaint();
        }
    }

    private void updateIcon() {
        boolean jb = PluginManagerConfigurableNew.isJBPlugin(this.myPlugin);
        boolean errors = this.myPluginModel.hasErrors(this.myPlugin);
        this.myIconLabel.setEnabled(this.myPlugin instanceof PluginNode || this.myPluginModel.isEnabled(this.myPlugin));
        this.myIconLabel.setIcon(PluginLogo.getIcon(this.myPlugin, true, jb, errors, false));
        this.myIconLabel.setDisabledIcon(PluginLogo.getIcon(this.myPlugin, true, jb, errors, true));
    }

    private void updateErrors() {
        boolean errors = this.myPluginModel.hasErrors(this.myPlugin);
        if (errors) {
            Ref enableAction = new Ref();
            String message = this.myPluginModel.getErrorMessage((PluginDescriptor)this.myPlugin, (Ref<? super String>)enableAction);
            ErrorComponent.show(this.myErrorComponent, message, (String)enableAction.get(), enableAction.isNull() ? null : this::handleErrors);
        }
        this.myErrorComponent.setVisible(errors);
    }

    private void handleErrors() {
        this.myPluginModel.enableRequiredPlugins(this.myPlugin);
        this.updateIcon();
        this.updateEnabledState();
        this.fullRepaint();
    }

    public void showProgress() {
        this.myIndicator = new OneLineProgressIndicator(false);
        this.myIndicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, false, false));
        this.myNameAndButtons.setProgressComponent(null, this.myIndicator.createBaselineWrapper());
        MyPluginModel.addProgress(this.myPlugin, this.myIndicator);
        this.fullRepaint();
    }

    private void fullRepaint() {
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    public void hideProgress(boolean success) {
        this.hideProgress(success, true);
    }

    private void hideProgress(boolean success, boolean repaint) {
        this.myIndicator = null;
        this.myNameAndButtons.removeProgressComponent();
        if (success) {
            this.enableRestart();
        }
        if (repaint) {
            this.fullRepaint();
        }
    }

    private void changeEnableDisable() {
        this.myPluginModel.changeEnableDisable(this.myPlugin);
        this.updateEnabledState();
    }

    private void updateEnableForNameAndIcon() {
        boolean enabled = this.myPluginModel.isEnabled(this.myPlugin);
        this.myNameComponent.setForeground(enabled ? null : ListPluginComponent.DisabledColor);
        this.myIconLabel.setEnabled(enabled);
    }

    public void updateEnabledState() {
        if (this.myMarketplace || this.myPlugin == null) {
            return;
        }
        this.updateIcon();
        this.updateEnableForNameAndIcon();
        this.updateErrors();
        boolean bundled = this.myPlugin.isBundled();
        boolean errors = this.myPluginModel.hasErrors(this.myPlugin);
        String title = this.myPluginModel.getEnabledTitle(this.myPlugin);
        this.myEnableDisableButton.setText(title);
        this.myEnableDisableUninstallButton.setText(title);
        this.myUpdateButton.setVisible(this.myUpdateDescriptor != null && !errors);
        this.myEnableDisableButton.setVisible(bundled && !errors);
        this.myEnableDisableUninstallButton.setVisible(!bundled && !errors);
        this.myUninstallButton.setVisible(!bundled && errors);
        this.fullRepaint();
    }

    private void doUninstall() {
        if (MyPluginModel.showUninstallDialog(this.myPlugin.getName(), 1)) {
            this.myPluginModel.doUninstall(this, this.myPlugin, null);
        }
    }

    public void enableRestart() {
        this.myInstallButton.setVisible(false);
        this.myUpdateButton.setVisible(false);
        this.myEnableDisableButton.setVisible(false);
        this.myEnableDisableUninstallButton.setVisible(false);
        this.myUninstallButton.setVisible(false);
        this.myRestartButton.setVisible(true);
    }

    @Nullable
    private String getDescription() {
        String description = this.myPlugin.getDescription();
        return StringUtil.isEmptyOrSpaces((String)description) ? null : description;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginDetailsPageComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centerPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginDetailsPageComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMetricsPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

