/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.TabHeaderComponent;
import com.intellij.ide.plugins.newui.TabHeaderListener;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedPaneHeaderComponent
extends JPanel {
    private final JBValue myHeight;
    private final JBValue myGap;
    private final JBValue myYOffset;
    private final JBTabbedPane myTabbedPane;
    private final TabHeaderListener myListener;

    public TabbedPaneHeaderComponent(@NotNull DefaultActionGroup actions, @NotNull TabHeaderListener listener2) {
        if (actions == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(1);
        }
        this.myHeight = new JBValue.Float(30.0f);
        this.myGap = new JBValue.Float(10.0f);
        this.myYOffset = new JBValue.Float(3.0f);
        this.myTabbedPane = new JBTabbedPane(){

            public void setUI(TabbedPaneUI ui) {
                boolean value = UIManager.getBoolean("TabbedPane.contentOpaque");
                UIManager.getDefaults().put("TabbedPane.contentOpaque", Boolean.FALSE);
                try {
                    super.setUI(ui);
                }
                finally {
                    UIManager.getDefaults().put("TabbedPane.contentOpaque", (Object)value);
                }
            }
        };
        this.myListener = listener2;
        this.setLayout((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                assert (parent.getComponentCount() == 2);
                int width = parent.getComponent((int)0).getPreferredSize().width * 2 + TabbedPaneHeaderComponent.this.myGap.get() + parent.getComponent((int)1).getPreferredSize().width;
                return new Dimension(width, TabbedPaneHeaderComponent.this.myHeight.get());
            }

            public void layoutContainer(Container parent) {
                assert (parent.getComponentCount() == 2);
                Component tabbedPane = parent.getComponent(0);
                Component toolbar = parent.getComponent(1);
                Dimension toolbarSize = toolbar.getPreferredSize();
                int width = tabbedPane.getPreferredSize().width * 2;
                int height = parent.getHeight();
                int gap = TabbedPaneHeaderComponent.this.myGap.get();
                int x = (parent.getWidth() - width - gap - toolbarSize.width) / 2 - width / 4;
                int yOffset = TabbedPaneHeaderComponent.this.myYOffset.get();
                tabbedPane.setBounds(x, yOffset, width, height - yOffset);
                toolbar.setBounds(x + width + gap, (height - toolbarSize.height) / 2, toolbarSize.width, height);
            }
        });
        this.setOpaque(false);
        this.myTabbedPane.setOpaque(false);
        this.add((Component)this.myTabbedPane);
        this.add((Component)TabHeaderComponent.createToolbar("Manage Repositories, Configure Proxy or Install Plugin from Disk", actions), "East");
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, 0, width, height + y);
    }

    public void setListener() {
        this.myTabbedPane.addChangeListener(e -> this.myListener.selectionChanged(this.myTabbedPane.getSelectedIndex()));
    }

    public void update() {
        this.doLayout();
        this.revalidate();
        this.myTabbedPane.doLayout();
        this.myTabbedPane.revalidate();
        this.repaint();
    }

    public void addTab(@NotNull String title, @Nullable Icon icon) {
        if (title == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(2);
        }
        this.myTabbedPane.addTab(title, icon, (Component)new JLabel());
        if (icon != null) {
            Component tab = this.myTabbedPane.getTabComponentAt(this.myTabbedPane.getTabCount() - 1);
            ((JLabel)tab).setHorizontalTextPosition(2);
        }
    }

    public int getSelectionTab() {
        return this.myTabbedPane.getSelectedIndex();
    }

    public void setSelection(int index) {
        this.myTabbedPane.setSelectedIndex(index);
    }

    public void setSelectionWithEvents(int index) {
        this.setSelection(index);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Runnable action2 = () -> this.setSelectionWithEvents(this.myTabbedPane.getSelectedIndex() == 0 ? 1 : 0);
        this.addTabSelectionAction("NextTab", action2);
        this.addTabSelectionAction("PreviousTab", action2);
    }

    private void addTabSelectionAction(@NotNull String actionId, @NotNull Runnable callback2) {
        if (actionId == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(3);
        }
        if (callback2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(4);
        }
        EventHandler.addGlobalAction(this, actionId, () -> {
            if (this.myTabbedPane.getTabCount() > 0) {
                callback2.run();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/TabbedPaneHeaderComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addTab";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addTabSelectionAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

