/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeStartupScripts
implements ApplicationInitializedListener {
    private static final Logger LOG = Logger.getInstance(IdeStartupScripts.class);
    private static final String SCRIPT_DIR = "startup";

    IdeStartupScripts() {
    }

    public void componentsInitialized() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        final MessageBusConnection connection = application.getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){
            Future<List<Pair<File, IdeScriptEngine>>> future;

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.future == null) {
                    this.future = ApplicationManager.getApplication().executeOnPooledThread(() -> IdeStartupScripts.prepareScriptsAndEngines());
                }
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    if (!project.isOpen()) {
                        return;
                    }
                    connection.disconnect();
                    IdeStartupScripts.runAllScriptsImpl(project, this.future);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/script/IdeStartupScripts$1", "projectOpened"));
            }
        });
    }

    @NotNull
    private static List<Pair<File, IdeScriptEngine>> prepareScriptsAndEngines() {
        List<File> scripts = IdeStartupScripts.getScripts();
        LOG.info(scripts.size() + " startup script(s) found");
        if (scripts.isEmpty()) {
            List<Pair<File, IdeScriptEngine>> list2 = Collections.emptyList();
            if (list2 == null) {
                IdeStartupScripts.$$$reportNull$$$0(0);
            }
            return list2;
        }
        IdeScriptEngineManager scriptEngineManager = IdeScriptEngineManager.getInstance();
        ArrayList<Pair<File, IdeScriptEngine>> result2 = new ArrayList<Pair<File, IdeScriptEngine>>();
        for (File script : scripts) {
            String extension = FileUtilRt.getExtension((String)script.getName());
            IdeScriptEngine engine = extension.isEmpty() ? null : scriptEngineManager.getEngineByFileExtension(extension, null);
            result2.add((Pair<File, IdeScriptEngine>)Pair.create((Object)script, (Object)engine));
        }
        ArrayList<Pair<File, IdeScriptEngine>> arrayList = result2;
        if (arrayList == null) {
            IdeStartupScripts.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runImpl(@NotNull Project project, @NotNull File script, @NotNull IdeScriptEngine engine) throws IOException, IdeScriptException {
        if (project == null) {
            IdeStartupScripts.$$$reportNull$$$0(2);
        }
        if (script == null) {
            IdeStartupScripts.$$$reportNull$$$0(3);
        }
        if (engine == null) {
            IdeStartupScripts.$$$reportNull$$$0(4);
        }
        String scriptText = FileUtil.loadFile((File)script);
        IdeConsoleScriptBindings.ensureIdeIsBound(project, engine);
        LOG.info(script.getPath());
        long start2 = System.currentTimeMillis();
        try {
            engine.eval(scriptText);
        }
        finally {
            LOG.info("... completed in " + StringUtil.formatDuration((long)(System.currentTimeMillis() - start2)));
        }
    }

    @NotNull
    private static List<File> getScripts() {
        File directory = IdeStartupScripts.getScriptsRootDirectory();
        List scripts = JBIterable.of((Object[])(directory == null ? null : directory.listFiles())).filter(ExtensionsRootType.regularFileFilter()).toList();
        ContainerUtil.sort((List)scripts, (f1, f2) -> {
            String f1Name = f1 != null ? f1.getName() : null;
            String f2Name = f2 != null ? f2.getName() : null;
            return StringUtil.compare((String)f1Name, (String)f2Name, (boolean)false);
        });
        List list2 = scripts;
        if (list2 == null) {
            IdeStartupScripts.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    private static File getScriptsRootDirectory() {
        PluginId corePlugin = (PluginId)ObjectUtils.assertNotNull((Object)PluginId.findId((String[])new String[]{"com.intellij"}));
        try {
            return ExtensionsRootType.getInstance().findResourceDirectory(corePlugin, SCRIPT_DIR, false);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void runAllScriptsImpl(@NotNull Project project, @NotNull Future<? extends List<Pair<File, IdeScriptEngine>>> future2) {
        if (project == null) {
            IdeStartupScripts.$$$reportNull$$$0(6);
        }
        if (future2 == null) {
            IdeStartupScripts.$$$reportNull$$$0(7);
        }
        try {
            for (Pair<File, IdeScriptEngine> pair : future2.get()) {
                try {
                    if (pair.second == null) {
                        LOG.warn(((File)pair.first).getPath() + " not supported (no script engine)");
                        continue;
                    }
                    IdeStartupScripts.runImpl(project, (File)pair.first, (IdeScriptEngine)pair.second);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        catch (ProcessCanceledException e) {
            LOG.warn("... cancelled");
        }
        catch (InterruptedException e) {
            LOG.warn("... interrupted");
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/script/IdeStartupScripts";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareScriptsAndEngines";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/script/IdeStartupScripts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScripts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runAllScriptsImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

