/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameInScopeItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SynchronizedCollectConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChooseByNameItemProvider
implements ChooseByNameInScopeItemProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ChooseByNameIdea");
    private static final String UNIVERSAL_SEPARATOR = "\u0000";
    private final SmartPsiElementPointer myContext;

    public DefaultChooseByNameItemProvider(@Nullable PsiElement context) {
        this.myContext = context == null ? null : SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(3);
        }
        return this.filterElements(base, DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere), indicator, consumer);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(7);
        }
        return (Boolean)ProgressManager.getInstance().computePrioritized(() -> DefaultChooseByNameItemProvider.filterElements((ChooseByNameViewModel)base, indicator, this.myContext == null ? null : this.myContext.getElement(), () -> base.getNames(parameters.isSearchInLibraries()), consumer, parameters));
    }

    public static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @NotNull Processor<Object> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(8);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(11);
        }
        return DefaultChooseByNameItemProvider.filterElements(base, indicator, context, null, consumer, DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere));
    }

    private static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @Nullable Supplier<String[]> allNamesProducer, @NotNull Processor<Object> consumer, @NotNull FindSymbolParameters parameters) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(14);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(15);
        }
        boolean everywhere = parameters.isSearchInLibraries();
        String pattern = parameters.getCompletePattern();
        if (base.getProject() != null) {
            base.getProject().putUserData(ChooseByNamePopup.CURRENT_SEARCH_PATTERN, (Object)pattern);
        }
        String namePattern = DefaultChooseByNameItemProvider.getNamePattern(base, pattern);
        boolean preferStartMatches = !pattern.startsWith("*");
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getSortedNamesForAllWildcards(base, parameters, indicator, allNamesProducer, namePattern, preferStartMatches);
        indicator.checkCanceled();
        return DefaultChooseByNameItemProvider.processByNames(base, everywhere, indicator, context, consumer, preferStartMatches, namesList, parameters);
    }

    @NotNull
    private static List<MatchResult> getSortedNamesForAllWildcards(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        String matchingPattern;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(16);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(18);
        }
        if ((matchingPattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern)).isEmpty() && !base.canShowListForEmptyPattern()) {
            List<MatchResult> list2 = Collections.emptyList();
            if (list2 == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(19);
            }
            return list2;
        }
        List<MatchResult> result2 = DefaultChooseByNameItemProvider.getSortedNames(base, parameters, indicator, allNamesProducer, matchingPattern, preferStartMatches);
        if (!namePattern.contains("*")) {
            List<MatchResult> list3 = result2;
            if (list3 == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(20);
            }
            return list3;
        }
        HashSet<String> allNames = new HashSet<String>(ContainerUtil.map(result2, mr -> mr.elementName));
        for (int i = 1; i < namePattern.length() - 1; ++i) {
            if (namePattern.charAt(i) != '*') continue;
            List<MatchResult> namesForSuffix = DefaultChooseByNameItemProvider.getSortedNames(base, parameters, indicator, allNamesProducer, DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern.substring(i + 1)), preferStartMatches);
            for (MatchResult mr2 : namesForSuffix) {
                if (!allNames.add(mr2.elementName)) continue;
                result2.add(mr2);
            }
        }
        List<MatchResult> list4 = result2;
        if (list4 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(21);
        }
        return list4;
    }

    @NotNull
    private static List<MatchResult> getSortedNames(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(22);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(23);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(24);
        }
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getAllNames(base, parameters, indicator, allNamesProducer, namePattern);
        indicator.checkCanceled();
        String pattern = parameters.getCompletePattern();
        long started = System.currentTimeMillis();
        Collections.sort(namesList, Comparator.comparing(mr -> !pattern.equalsIgnoreCase(mr.elementName)).thenComparing(mr -> !namePattern.equalsIgnoreCase(mr.elementName)).thenComparing((mr1, mr2) -> mr1.compareWith((MatchResult)mr2, preferStartMatches)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted:" + (System.currentTimeMillis() - started) + ",results:" + namesList.size());
        }
        List<MatchResult> list2 = namesList;
        if (list2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(25);
        }
        return list2;
    }

    @NotNull
    private static List<MatchResult> getAllNames(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, String namePattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(26);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(27);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(28);
        }
        ArrayList<MatchResult> namesList = new ArrayList<MatchResult>();
        SynchronizedCollectConsumer collect = new SynchronizedCollectConsumer(namesList);
        ChooseByNameModel model2 = base.getModel();
        if (model2 instanceof ChooseByNameModelEx) {
            indicator.checkCanceled();
            long started = System.currentTimeMillis();
            String fullPattern = parameters.getCompletePattern();
            MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(namePattern);
            ((ChooseByNameModelEx)model2).processNames((Processor<? super String>)((Processor)arg_0 -> DefaultChooseByNameItemProvider.lambda$getAllNames$6(indicator, base, fullPattern, matcher, (CollectConsumer)collect, arg_0)), parameters);
            if (LOG.isDebugEnabled()) {
                LOG.debug("loaded + matched:" + (System.currentTimeMillis() - started) + "," + collect.getResult().size());
            }
        } else {
            if (allNamesProducer == null) {
                throw new IllegalArgumentException("Need to specify allNamesProducer when using a model which isn't a ChooseByNameModelEx");
            }
            String[] names2 = allNamesProducer.get();
            long started = System.currentTimeMillis();
            DefaultChooseByNameItemProvider.processNamesByPattern(base, names2, namePattern, indicator, (Consumer<? super MatchResult>)collect);
            if (LOG.isDebugEnabled()) {
                LOG.debug("matched:" + (System.currentTimeMillis() - started) + "," + names2.length);
            }
        }
        ArrayList<MatchResult> arrayList = namesList;
        if (arrayList == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @NotNull
    private static FindSymbolParameters createParameters(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere) {
        ChooseByNameModel model2;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(30);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(31);
        }
        IdFilter idFilter = (model2 = base.getModel()) instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model2).getIdFilter(everywhere) : null;
        GlobalSearchScope searchScope = FindSymbolParameters.searchScopeFor(base.getProject(), everywhere);
        FindSymbolParameters findSymbolParameters = new FindSymbolParameters(pattern, DefaultChooseByNameItemProvider.getNamePattern(base, pattern), searchScope, idFilter);
        if (findSymbolParameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(32);
        }
        return findSymbolParameters;
    }

    private static boolean processByNames(@NotNull ChooseByNameViewModel base, boolean everywhere, @NotNull ProgressIndicator indicator, final @Nullable PsiElement context, @NotNull Processor<Object> consumer, boolean preferStartMatches, List<? extends MatchResult> namesList, FindSymbolParameters parameters) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(33);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(34);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(35);
        }
        SmartList sameNameElements = new SmartList();
        THashMap qualifierMatchResults = ContainerUtil.newIdentityTroveMap();
        final ChooseByNameModel model2 = base.getModel();
        Comparator<Object> weightComparator = new Comparator<Object>((Map)qualifierMatchResults, preferStartMatches){
            final Comparator<Object> modelComparator;
            final /* synthetic */ Map val$qualifierMatchResults;
            final /* synthetic */ boolean val$preferStartMatches;
            {
                this.val$qualifierMatchResults = map2;
                this.val$preferStartMatches = bl;
                this.modelComparator = model2 instanceof Comparator ? (Comparator)model2 : new PathProximityComparator(context);
            }

            @Override
            public int compare(Object o1, Object o2) {
                int result2 = this.modelComparator.compare(o1, o2);
                return result2 != 0 ? result2 : ((MatchResult)this.val$qualifierMatchResults.get(o1)).compareWith((MatchResult)this.val$qualifierMatchResults.get(o2), this.val$preferStartMatches);
            }
        };
        MinusculeMatcher fullMatcher = DefaultChooseByNameItemProvider.getFullMatcher(parameters, base);
        for (MatchResult matchResult : namesList) {
            Object[] elements2;
            indicator.checkCanceled();
            String name = matchResult.elementName;
            Object[] objectArray = elements2 = model2 instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model2).getElementsByName(name, parameters, indicator) : model2.getElementsByName(name, everywhere, DefaultChooseByNameItemProvider.getNamePattern(base, parameters.getCompletePattern()));
            if (elements2.length > 1) {
                sameNameElements.clear();
                qualifierMatchResults.clear();
                for (Object element : elements2) {
                    indicator.checkCanceled();
                    MatchResult qualifierResult = DefaultChooseByNameItemProvider.matchQualifiedName(model2, fullMatcher, element);
                    if (qualifierResult == null) continue;
                    sameNameElements.add(element);
                    qualifierMatchResults.put(element, qualifierResult);
                }
                Collections.sort(sameNameElements, weightComparator);
                if (ContainerUtil.process((List)sameNameElements, consumer)) continue;
                return false;
            }
            if (elements2.length != 1 || DefaultChooseByNameItemProvider.matchQualifiedName(model2, fullMatcher, elements2[0]) == null || consumer.process(elements2[0])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected PathProximityComparator getPathProximityComparator() {
        PathProximityComparator pathProximityComparator = new PathProximityComparator(this.myContext == null ? null : this.myContext.getElement());
        if (pathProximityComparator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(36);
        }
        return pathProximityComparator;
    }

    @NotNull
    private static MinusculeMatcher getFullMatcher(FindSymbolParameters parameters, ChooseByNameViewModel base) {
        String fullRawPattern = DefaultChooseByNameItemProvider.buildFullPattern(base, parameters.getCompletePattern());
        String fullNamePattern = DefaultChooseByNameItemProvider.buildFullPattern(base, base.transformPattern(parameters.getCompletePattern()));
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcherWithFallback((String)fullRawPattern, (String)fullNamePattern, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        if (minusculeMatcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(37);
        }
        return minusculeMatcher;
    }

    @NotNull
    private static String buildFullPattern(ChooseByNameViewModel base, String pattern) {
        String fullPattern = "*" + DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern);
        for (String separator : base.getModel().getSeparators()) {
            fullPattern = StringUtil.replace((String)fullPattern, (String)separator, (String)"*\u0000*");
        }
        String string = fullPattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(39);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(40);
        }
        String transformedPattern = base.transformPattern(pattern);
        String string = DefaultChooseByNameItemProvider.getNamePattern(base.getModel(), transformedPattern);
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(41);
        }
        return string;
    }

    private static String getNamePattern(ChooseByNameModel model2, String pattern) {
        String[] separators = model2.getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx == -1 ? idx : idx + separator.length());
        }
        return pattern.substring(lastSeparatorOccurrence);
    }

    @Nullable
    private static MatchResult matchQualifiedName(ChooseByNameModel model2, MinusculeMatcher fullMatcher, @NotNull Object element) {
        String fullName;
        if (element == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(42);
        }
        if ((fullName = model2.getFullName(element)) == null) {
            return null;
        }
        for (String separator : model2.getSeparators()) {
            fullName = StringUtil.replace((String)fullName, (String)separator, (String)UNIVERSAL_SEPARATOR);
        }
        return DefaultChooseByNameItemProvider.matchName(fullMatcher, fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, @NotNull String[] names2, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(43);
        }
        if (names2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(44);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(45);
        }
        if ((pattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, pattern)).isEmpty() && !base.canShowListForEmptyPattern()) {
            List<String> list2 = Collections.emptyList();
            if (list2 != null) return list2;
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(46);
            return list2;
        }
        ArrayList<String> filtered2 = new ArrayList<String>();
        DefaultChooseByNameItemProvider.processNamesByPattern(base, names2, pattern, ProgressIndicatorProvider.getGlobalProgressIndicator(), (Consumer<? super MatchResult>)((Consumer)result2 -> {
            List list2 = filtered2;
            synchronized (list2) {
                filtered2.add(result2.elementName);
            }
        }));
        ArrayList<String> arrayList2 = filtered2;
        // MONITORENTER : arrayList2
        ArrayList<String> arrayList = filtered2;
        // MONITOREXIT : arrayList2
        if (arrayList != null) return arrayList;
        DefaultChooseByNameItemProvider.$$$reportNull$$$0(47);
        return arrayList;
    }

    private static void processNamesByPattern(@NotNull ChooseByNameViewModel base, @NotNull String[] names2, @NotNull String pattern, ProgressIndicator indicator, @NotNull Consumer<? super MatchResult> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(48);
        }
        if (names2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(49);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(50);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(51);
        }
        MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(pattern);
        Processor processor2 = name -> {
            ProgressManager.checkCanceled();
            MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, name);
            if (result2 != null) {
                consumer.consume((Object)result2);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(names2), indicator, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private static String convertToMatchingPattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(52);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(53);
        }
        String string = DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern));
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    private static String addSearchAnywherePatternDecorationIfNeeded(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        String trimmedPattern;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(55);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(56);
        }
        if (base.isSearchInAnyPlace() && !(trimmedPattern = pattern.trim()).isEmpty() && trimmedPattern.length() > 1) {
            pattern = "*" + pattern;
        }
        String string = pattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(57);
        }
        return string;
    }

    @NotNull
    private static String removeModelSpecificMarkup(@NotNull ChooseByNameModel model2, @NotNull String pattern) {
        if (model2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(58);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(59);
        }
        if (model2 instanceof ContributorsBasedGotoByModel) {
            pattern = ((ContributorsBasedGotoByModel)model2).removeModelSpecificMarkup(pattern);
        }
        String string = pattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(60);
        }
        return string;
    }

    @Nullable
    protected static MatchResult matches(@NotNull ChooseByNameViewModel base, @NotNull String pattern, @NotNull MinusculeMatcher matcher, @Nullable String name) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(61);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(62);
        }
        if (matcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(63);
        }
        if (name == null) {
            return null;
        }
        if (base.getModel() instanceof CustomMatcherModel) {
            try {
                return ((CustomMatcherModel)base.getModel()).matches(name, pattern) ? new MatchResult(name, 0, true) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return DefaultChooseByNameItemProvider.matchName(matcher, name);
    }

    @Nullable
    private static MatchResult matchName(@NotNull MinusculeMatcher matcher, @NotNull String name) {
        FList fragments;
        if (matcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(64);
        }
        if (name == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(65);
        }
        return (fragments = matcher.matchingFragments(name)) != null ? new MatchResult(name, matcher.matchingDegree(name, false, fragments), MinusculeMatcher.isStartMatch((Iterable)fragments)) : null;
    }

    @NotNull
    private static MinusculeMatcher buildPatternMatcher(@NotNull String pattern) {
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(66);
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        if (minusculeMatcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(67);
        }
        return minusculeMatcher;
    }

    private static /* synthetic */ boolean lambda$getAllNames$6(ProgressIndicator indicator, ChooseByNameViewModel base, String fullPattern, MinusculeMatcher matcher, CollectConsumer collect, String sequence) {
        indicator.checkCanceled();
        MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, fullPattern, matcher, sequence);
        if (result2 != null) {
            collect.consume((Object)result2);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 46: 
            case 47: 
            case 54: 
            case 57: 
            case 60: 
            case 67: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 46: 
            case 47: 
            case 54: 
            case 57: 
            case 60: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 9: 
            case 31: 
            case 40: 
            case 45: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 18: 
            case 24: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 35: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 15: 
            case 17: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 46: 
            case 47: 
            case 54: 
            case 57: 
            case 60: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedNamesForAllWildcards";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedNames";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameters";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathProximityComparator";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullMatcher";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFullPattern";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePattern";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToMatchingPattern";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "addSearchAnywherePatternDecorationIfNeeded";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatternMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSortedNamesForAllWildcards";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 46: 
            case 47: 
            case 54: 
            case 57: 
            case 60: 
            case 67: {
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSortedNames";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAllNames";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createParameters";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processByNames";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getNamePattern";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "matchQualifiedName";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processNamesByPattern";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "convertToMatchingPattern";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addSearchAnywherePatternDecorationIfNeeded";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "matchName";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "buildPatternMatcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 46: 
            case 47: 
            case 54: 
            case 57: 
            case 60: 
            case 67: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PathProximityComparator
    implements Comparator<Object> {
        @NotNull
        private final PsiProximityComparator myProximityComparator;

        private PathProximityComparator(@Nullable PsiElement context) {
            this.myProximityComparator = new PsiProximityComparator(context);
        }

        private static boolean isCompiledWithoutSource(Object o) {
            return o instanceof PsiCompiledElement && ((PsiCompiledElement)o).getNavigationElement() == o;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int rc = this.myProximityComparator.compare(o1, o2);
            if (rc != 0) {
                return rc;
            }
            int o1Weight = PathProximityComparator.isCompiledWithoutSource(o1) ? 1 : 0;
            int o2Weight = PathProximityComparator.isCompiledWithoutSource(o2) ? 1 : 0;
            return o1Weight - o2Weight;
        }
    }
}

