/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.NotNull;

public class StatisticsEventLogFileAppender
extends FileAppender {
    protected long maxFileAge;
    protected long maxFileSize;
    private long nextRollover;
    protected long oldestExistingFile;
    private final Path myLogDirectory;
    private final Supplier<List<File>> myFilesProducer;

    public StatisticsEventLogFileAppender(@NotNull Path path, @NotNull List<File> files2) {
        if (path == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(1);
        }
        this.maxFileAge = 1209600000L;
        this.maxFileSize = 0xA00000L;
        this.nextRollover = 0L;
        this.oldestExistingFile = -1L;
        this.myLogDirectory = path;
        this.myFilesProducer = () -> files2;
    }

    public StatisticsEventLogFileAppender(@NotNull Layout layout, @NotNull Path dir, @NotNull String filename) throws IOException {
        if (layout == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(2);
        }
        if (dir == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(3);
        }
        if (filename == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(4);
        }
        super(layout, filename);
        this.maxFileAge = 1209600000L;
        this.maxFileSize = 0xA00000L;
        this.nextRollover = 0L;
        this.oldestExistingFile = -1L;
        this.myLogDirectory = dir;
        this.myFilesProducer = () -> {
            Object[] files2 = dir.toFile().listFiles();
            return files2 == null || files2.length == 0 ? ContainerUtil.emptyList() : ContainerUtil.newArrayList((Object[])files2);
        };
        this.cleanUpOldFiles();
    }

    public static StatisticsEventLogFileAppender create(@NotNull Layout layout, @NotNull Path dir) throws IOException {
        if (layout == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(5);
        }
        if (dir == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(6);
        }
        File file2 = StatisticsEventLogFileAppender.nextFile(dir);
        return new StatisticsEventLogFileAppender(layout, dir, file2.getPath());
    }

    @NotNull
    public String getActiveLogName() {
        String string = StringUtil.isNotEmpty((String)this.fileName) ? PathUtil.getFileName((String)this.fileName) : "";
        if (string == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setMaxFileAge(long maxAge) {
        this.maxFileAge = maxAge;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    @NotNull
    protected CountingQuietWriter getQuietWriter() {
        CountingQuietWriter countingQuietWriter = (CountingQuietWriter)this.qw;
        if (countingQuietWriter == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(8);
        }
        return countingQuietWriter;
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    public synchronized void setFile(String fileName2, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName2, append, bufferedIO, bufferSize);
        if (append && this.qw instanceof CountingQuietWriter) {
            File f = new File(fileName2);
            this.getQuietWriter().setCount(f.length());
        }
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (this.fileName != null && this.qw != null && (size = this.getQuietWriter().getCount()) >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOver();
            this.cleanUpOldFiles();
        }
    }

    public void rollOver() {
        this.nextRollover = this.getQuietWriter().getCount() + this.maxFileSize;
        try {
            File file2 = StatisticsEventLogFileAppender.nextFile(this.myLogDirectory);
            this.setFile(file2.getPath(), false, this.bufferedIO, this.bufferSize);
            this.nextRollover = 0L;
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    protected void cleanUpOldFiles() {
        long oldestAcceptable = System.currentTimeMillis() - this.maxFileAge;
        if (this.oldestExistingFile != -1L && oldestAcceptable < this.oldestExistingFile) {
            return;
        }
        this.cleanUpOldFiles(oldestAcceptable);
    }

    protected void cleanUpOldFiles(long oldestAcceptable) {
        List<File> logs = this.myFilesProducer.get();
        if (logs == null || logs.isEmpty()) {
            return;
        }
        String activeLog = this.getActiveLogName();
        long oldestFile = -1L;
        for (File file2 : logs) {
            if (StringUtil.equals((CharSequence)file2.getName(), (CharSequence)activeLog)) continue;
            long lastModified = file2.lastModified();
            if (lastModified < oldestAcceptable) {
                if (file2.delete()) continue;
                LogLog.error((String)("Failed deleting old file " + file2));
                continue;
            }
            if (lastModified >= oldestFile && oldestFile != -1L) continue;
            oldestFile = lastModified;
        }
        this.oldestExistingFile = oldestFile;
    }

    public void cleanUp() {
        List<File> logs = this.myFilesProducer.get();
        if (logs == null || logs.isEmpty()) {
            return;
        }
        for (File file2 : logs) {
            if (file2.delete()) continue;
            LogLog.error((String)("Failed deleting old file " + file2));
        }
        this.rollOver();
    }

    @NotNull
    private static File nextFile(@NotNull Path dir) {
        if (dir == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(9);
        }
        File file2 = dir.resolve(UUID.randomUUID() + ".log").toFile();
        while (file2.exists()) {
            file2 = dir.resolve(UUID.randomUUID() + ".log").toFile();
        }
        File file3 = file2;
        if (file3 == null) {
            StatisticsEventLogFileAppender.$$$reportNull$$$0(10);
        }
        return file3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/StatisticsEventLogFileAppender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/StatisticsEventLogFileAppender";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveLogName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuietWriter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "nextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "nextFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

