/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStateUsagesLogger
implements UsagesCollectorConsumer {
    private static final String INVOKED = "invoked";

    public static FUStateUsagesLogger create() {
        return new FUStateUsagesLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logProjectStates(@NotNull Project project) {
        if (project == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(0);
        }
        Object object = StatisticsUploadAssistant.LOCK;
        synchronized (object) {
            for (ProjectUsagesCollector usagesCollector : ProjectUsagesCollector.getExtensions(this)) {
                EventLogGroup group = new EventLogGroup(usagesCollector.getGroupId(), usagesCollector.getVersion());
                FUStateUsagesLogger.logUsagesAsStateEvents(project, group, usagesCollector.getData(project), usagesCollector.getMetrics(project));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logApplicationStates() {
        Object object = StatisticsUploadAssistant.LOCK;
        synchronized (object) {
            for (ApplicationUsagesCollector usagesCollector : ApplicationUsagesCollector.getExtensions(this)) {
                EventLogGroup group = new EventLogGroup(usagesCollector.getGroupId(), usagesCollector.getVersion());
                FUStateUsagesLogger.logUsagesAsStateEvents(null, group, usagesCollector.getData(), usagesCollector.getMetrics());
            }
        }
    }

    private static void logUsagesAsStateEvents(@Nullable Project project, @NotNull EventLogGroup group, @Nullable FeatureUsageData context, @NotNull Set<MetricEvent> metrics) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(1);
        }
        if (metrics == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(2);
        }
        FeatureUsageLogger logger = FeatureUsageLogger.INSTANCE;
        if (!metrics.isEmpty()) {
            FeatureUsageData groupData = FUStateUsagesLogger.addProject(project, context);
            for (MetricEvent metric : metrics) {
                FeatureUsageData data = FUStateUsagesLogger.mergeWithEventData(groupData, metric.getData());
                Map<Object, Object> eventData = data != null ? data.build() : Collections.emptyMap();
                logger.logState(group, metric.getEventId(), eventData);
            }
        }
        logger.logState(group, INVOKED, new FeatureUsageData().addProject(project).build());
    }

    @Nullable
    private static FeatureUsageData addProject(@Nullable Project project, @Nullable FeatureUsageData context) {
        if (project == null && context == null) {
            return null;
        }
        return context != null ? context.addProject(project) : new FeatureUsageData().addProject(project);
    }

    @Nullable
    public static FeatureUsageData mergeWithEventData(@Nullable FeatureUsageData groupData, @Nullable FeatureUsageData data) {
        if (data == null) {
            return groupData;
        }
        FeatureUsageData newData = groupData == null ? new FeatureUsageData() : groupData.copy();
        newData.merge(data, "event_");
        return newData;
    }

    public static void logStateEvent(@NotNull EventLogGroup group, @NotNull String event, @NotNull FeatureUsageData data) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(3);
        }
        if (event == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(4);
        }
        if (data == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(5);
        }
        FeatureUsageLogger.INSTANCE.logState(group, event, data.build());
        FeatureUsageLogger.INSTANCE.logState(group, INVOKED);
    }

    public static void logStateEvents(@NotNull EventLogGroup group, @NotNull Collection<MetricEvent> events) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(6);
        }
        if (events == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(7);
        }
        for (MetricEvent event : events) {
            FeatureUsageLogger.INSTANCE.logState(group, event.getEventId(), event.getData().build());
        }
        FeatureUsageLogger.INSTANCE.logState(group, INVOKED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUStateUsagesLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logProjectStates";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "logUsagesAsStateEvents";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logStateEvent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "logStateEvents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

