/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import org.jetbrains.annotations.Nullable;

public class DeleteSelectionHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public DeleteSelectionHandler(EditorActionHandler handler2) {
        this.myOriginalHandler = handler2;
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (caret == null ? editor.getSelectionModel().hasSelection(true) : caret.hasSelection()) {
            EditorUIUtil.hideCursorInEditor(editor);
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            CopyPasteManager.getInstance().stopKillRings();
            CaretAction action2 = c2 -> EditorModificationUtil.deleteSelectedText((Editor)editor);
            if (caret == null) {
                editor.getCaretModel().runForEachCaret(action2);
            } else {
                action2.perform(caret);
            }
        } else {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }
}

