/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.ProjectTopics;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.AsyncFileChangeListenerBase;
import com.intellij.openapi.externalSystem.service.project.autoimport.ConfigurationFileCrcFactory;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.CompoundParallelOperationTrace;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProjectsWatcherImpl
extends ExternalSystemTaskNotificationListenerAdapter
implements ExternalSystemProjectsWatcher,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalSystemProjectsWatcherImpl.class);
    private static final ExtensionPointName<Contributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalProjectWatcherContributor");
    private static final Key<Long> CRC_WITHOUT_SPACES_CURRENT = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_CURRENT");
    private static final Key<Long> CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT");
    private static final int DOCUMENT_SAVE_DELAY = 1000;
    private static final int REFRESH_MERGING_TIME_SPAN = 2000;
    private final Project myProject;
    private final MergingUpdateQueue myChangedDocumentsQueue;
    private final List<ExternalSystemAutoImportAware> myImportAwareManagers;
    private final MergingUpdateQueue myUpdatesQueue;
    private final Map<ProjectSystemId, MyNotification> myNotificationMap;
    private final MultiMap<String, String> myKnownAffectedFiles = MultiMap.createConcurrentSet();
    private final MultiMap<VirtualFilePointer, String> myFilesPointers = MultiMap.createConcurrentSet();
    private final List<LocalFileSystem.WatchRequest> myWatchedRoots = new ArrayList<LocalFileSystem.WatchRequest>();
    private final MergingUpdateQueue myRefreshRequestsQueue;
    private final Map<ExternalSystemTaskId, String> myProjectsInSync = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, ProjectStatus> myWatchedProjects = Collections.synchronizedMap(new LinkedHashMap());
    private final CompoundParallelOperationTrace<ExternalSystemTaskId> syncTrace = new CompoundParallelOperationTrace();

    public ExternalSystemProjectsWatcherImpl(Project project) {
        this.syncTrace.onOperationCompleted(() -> ExternalSystemProjectsWatcherImpl.debug("Auto update enabled"));
        this.myProject = project;
        this.myChangedDocumentsQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Document changes queue", 1000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myRefreshRequestsQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Refresh requests queue", 2000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject, null, false);
        this.myImportAwareManagers = new ArrayList<ExternalSystemAutoImportAware>();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(manager instanceof ExternalSystemAutoImportAware)) continue;
            this.myImportAwareManagers.add((ExternalSystemAutoImportAware)manager);
            NotificationsConfiguration.getNotificationsConfiguration().register(manager.getSystemId().getReadableName() + " Import", NotificationDisplayType.STICKY_BALLOON, false);
        }
        this.myUpdatesQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Notifier queue", 500, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myNotificationMap = ContainerUtil.newConcurrentMap();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){

            @Override
            public void batchChangeStarted(@NotNull Project project, @Nullable String activityName) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExternalSystemProjectsWatcherImpl.this.myRefreshRequestsQueue.suspend();
            }

            @Override
            public void batchChangeCompleted(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExternalSystemProjectsWatcherImpl.this.myRefreshRequestsQueue.resume();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void markDirtyAllExternalProjects() {
        this.findLinkedProjectsSettings().forEach(linkedProject -> {
            String projectPath = ExternalSystemProjectsWatcherImpl.getExternalProjectPath((Pair<ExternalSystemManager, ExternalProjectSettings>)linkedProject);
            this.updateProjectStatus(projectPath, it -> it.markDirty(LocalTimeCounter.currentTime()));
            this.scheduleUpdate((Pair<ExternalSystemManager, ExternalProjectSettings>)linkedProject);
        });
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirtyAllExternalProjects(this.myProject);
        }
    }

    public void markDirty(Module module) {
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        this.updateProjectStatus(projectPath, it -> it.markDirty(LocalTimeCounter.currentTime()));
        this.scheduleUpdate(projectPath);
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirty(module);
        }
    }

    public void markDirty(String projectPath) {
        this.updateProjectStatus(projectPath, it -> it.markDirty(LocalTimeCounter.currentTime()));
        this.scheduleUpdate(projectPath);
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirty(projectPath);
        }
    }

    public synchronized void start() {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        this.myUpdatesQueue.activate();
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new FileChangeListener(this), (Disposable)this);
        ExternalSystemProjectsWatcherImpl.makeUserAware(this.myChangedDocumentsQueue, this.myProject);
        this.myChangedDocumentsQueue.activate();
        this.myRefreshRequestsQueue.activate();
        DocumentListener myDocumentListener = new DocumentListener(){
            private final Map<Document, Pair<String, VirtualFile>> myChangedDocuments = new THashMap();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                Document doc = event.getDocument();
                VirtualFile file2 = FileDocumentManager.getInstance().getFile(doc);
                if (file2 == null) {
                    return;
                }
                String externalProjectPath = ExternalSystemProjectsWatcherImpl.this.getRelatedExternalProjectPath(file2);
                if (externalProjectPath == null) {
                    return;
                }
                ExternalSystemProjectsWatcherImpl.debug("Document changed '" + file2.getPath() + "' from '" + event.getOldFragment() + "' to '" + event.getNewFragment() + "'");
                Map<Document, Pair<String, VirtualFile>> map2 = this.myChangedDocuments;
                synchronized (map2) {
                    this.myChangedDocuments.put(doc, (Pair<String, VirtualFile>)Pair.create((Object)externalProjectPath, (Object)file2));
                }
                ExternalSystemProjectsWatcherImpl.this.myChangedDocumentsQueue.queue(new Update((Object)ExternalSystemProjectsWatcherImpl.this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        THashMap copy;
                        Map map2 = myChangedDocuments;
                        synchronized (map2) {
                            copy = new THashMap(myChangedDocuments);
                            myChangedDocuments.clear();
                        }
                        ExternalSystemUtil.invokeLater(ExternalSystemProjectsWatcherImpl.this.myProject, () -> this.lambda$run$2((Map)copy));
                    }

                    private /* synthetic */ void lambda$run$2(Map copy) {
                        WriteAction.run(() -> copy.forEach((document, pair) -> this.handleDocumentChange(document, (String)pair.first, (VirtualFile)pair.second)));
                    }
                });
            }

            private void handleDocumentChange(Document document, String externalProjectPath, VirtualFile file2) {
                if (!file2.isValid()) {
                    return;
                }
                ExternalSystemProjectsWatcherImpl.refreshFileCrcInfo(file2);
                if (ExternalSystemProjectsWatcherImpl.fileWasChanged(file2)) {
                    ExternalSystemProjectsWatcherImpl.this.updateProjectStatus(externalProjectPath, it -> it.markModified(document.getModificationStamp()));
                } else if (!ExternalSystemProjectsWatcherImpl.this.projectWasChanged(externalProjectPath)) {
                    ExternalSystemProjectsWatcherImpl.this.updateProjectStatus(externalProjectPath, it -> it.markReverted(document.getModificationStamp()));
                }
                if (ExternalSystemProjectsWatcherImpl.this.isUpToDate(externalProjectPath)) {
                    ExternalSystemProjectsWatcherImpl.this.handleRevertedChanges(externalProjectPath);
                } else {
                    ExternalSystemProjectsWatcherImpl.this.scheduleUpdate(externalProjectPath, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$2", "documentChanged"));
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(myDocumentListener, (Disposable)this.myChangedDocumentsQueue);
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).addNotificationListener((ExternalSystemTaskNotificationListener)this);
        this.updateWatchedRoots(true);
        Disposer.register((Disposable)this.myChangedDocumentsQueue, () -> this.myFilesPointers.clear());
    }

    public void dispose() {
        this.stop();
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myChangedDocumentsQueue);
        Disposer.dispose((Disposable)this.myUpdatesQueue);
        Disposer.dispose((Disposable)this.myRefreshRequestsQueue);
        this.myNotificationMap.clear();
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).removeNotificationListener((ExternalSystemTaskNotificationListener)this);
    }

    public void disableAutoUpdate() {
        ExternalSystemProjectsWatcherImpl.debug("Auto update disabled");
        this.syncTrace.startOperation();
        this.closeAllNotifications();
    }

    private boolean isEnabledAutoUpdate() {
        return this.syncTrace.isOperationCompleted();
    }

    public void onStart(@NotNull ExternalSystemTaskId id, final String workingDir) {
        if (id == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(0);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            ExternalSystemProjectsWatcherImpl.debug("Refresh started for '" + workingDir + "'");
            this.myProjectsInSync.put(id, workingDir);
            this.updateProjectStatus(workingDir, it -> it.markSynchronized(LocalTimeCounter.currentTime()));
            this.syncTrace.startTask(id);
            final ProjectSystemId systemId = id.getProjectSystemId();
            for (String filePath : new ArrayList(this.myKnownAffectedFiles.get((Object)workingDir))) {
                VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(filePath), (boolean)false);
                if (file2 == null || file2.isDirectory()) continue;
                file2.putUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT, file2.getUserData(CRC_WITHOUT_SPACES_CURRENT));
            }
            this.myUpdatesQueue.queue(new Update(Pair.create((Object)systemId, (Object)workingDir)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.doUpdateNotifications(true, systemId, workingDir);
                }
            });
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(1);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            ExternalSystemProjectsWatcherImpl.debug("Refresh finished");
            this.syncTrace.finishTask(id);
            this.updateWatchedRoots(false);
        }
    }

    public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
        if (id == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(3);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            ExternalSystemProjectsWatcherImpl.debug("Refresh failed");
            this.syncTrace.finishTask(id);
            String projectPath = this.myProjectsInSync.get(id);
            this.updateProjectStatus(projectPath, it -> it.markDirty(LocalTimeCounter.currentTime()));
        }
        super.onFailure(id, e);
    }

    public void onCancel(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(4);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            ExternalSystemProjectsWatcherImpl.debug("Refresh cancel");
            this.syncTrace.finishTask(id);
            String projectPath = this.myProjectsInSync.get(id);
            this.updateProjectStatus(projectPath, it -> it.markDirty(LocalTimeCounter.currentTime()));
        }
        super.onCancel(id);
    }

    public void onEnd(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(5);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            this.myProjectsInSync.remove(id);
        }
        super.onEnd(id);
    }

    @Nullable
    private static String getExternalProjectPath(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject) {
        if (linkedProject == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(6);
        }
        return ((ExternalProjectSettings)linkedProject.second).getExternalProjectPath();
    }

    private void scheduleUpdate(@Nullable String projectPath) {
        this.scheduleUpdate(projectPath, true);
    }

    private void scheduleUpdate(@Nullable String projectPath, boolean reportRefreshError) {
        if (projectPath == null || ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject = this.findLinkedProjectSettings(projectPath);
        if (linkedProject == null) {
            return;
        }
        this.scheduleUpdate(linkedProject, reportRefreshError);
    }

    private void scheduleUpdate(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject) {
        if (linkedProject == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(7);
        }
        this.scheduleUpdate(linkedProject, true);
    }

    private void scheduleUpdate(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject, final boolean reportRefreshError) {
        if (linkedProject == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(8);
        }
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        ExternalSystemManager manager = (ExternalSystemManager)linkedProject.first;
        final String projectPath = ((ExternalProjectSettings)linkedProject.second).getExternalProjectPath();
        final ProjectSystemId systemId = manager.getSystemId();
        boolean useAutoImport = ((ExternalProjectSettings)linkedProject.second).isUseAutoImport();
        if (!this.isEnabledAutoUpdate()) {
            ExternalSystemProjectsWatcherImpl.debug("Update disabled for '" + projectPath + "'");
            return;
        }
        if (this.isUpToDate(projectPath)) {
            ExternalSystemProjectsWatcherImpl.debug("Update skipped for '" + projectPath + "'");
            return;
        }
        ExternalSystemProjectsWatcherImpl.debug("Schedule update for '" + projectPath + "'");
        if (useAutoImport) {
            ExternalSystemTaskState taskState;
            ExternalSystemTask resolveTask = ((ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, systemId, projectPath);
            ExternalSystemTaskState externalSystemTaskState = taskState = resolveTask == null ? null : resolveTask.getState();
            if (taskState == null || taskState.isStopped()) {
                this.addToRefreshQueue(projectPath, systemId, reportRefreshError);
            } else if (taskState != ExternalSystemTaskState.NOT_STARTED) {
                Long lastTimestamp;
                if (manager instanceof ExternalSystemAutoImportAware && (lastTimestamp = (Long)((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject)).getExternalConfigModificationStamps().get(projectPath)) != null) {
                    List affectedFiles = ((ExternalSystemAutoImportAware)manager).getAffectedExternalProjectFiles(projectPath, this.myProject);
                    long currentTimeStamp = affectedFiles.stream().mapToLong(File::lastModified).sum();
                    if (lastTimestamp != currentTimeStamp) {
                        return;
                    }
                }
                final ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
                ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter(){

                    public void onEnd(@NotNull ExternalSystemTaskId id) {
                        if (id == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
                        ExternalSystemProjectsWatcherImpl.this.addToRefreshQueue(projectPath, systemId, reportRefreshError);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$4", "onEnd"));
                    }
                };
                progressManager.addNotificationListener(resolveTask.getId(), (ExternalSystemTaskNotificationListener)taskListener);
            }
        } else {
            LOG.debug("Scheduling new external project update notification", new Throwable("Schedule update call trace"));
            this.myUpdatesQueue.queue(new Update(Pair.create((Object)systemId, (Object)projectPath)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.doUpdateNotifications(false, systemId, projectPath);
                }
            });
        }
    }

    private void handleRevertedChanges(final @NotNull String externalProjectPath) {
        if (externalProjectPath == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(9);
        }
        ExternalSystemProjectsWatcherImpl.debug("Handle reverted changes for '" + externalProjectPath + "'");
        final ProjectSystemId systemId = this.getProjectSystemId(externalProjectPath);
        if (systemId == null) {
            return;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)systemId);
        if (manager instanceof ExternalSystemAutoImportAware) {
            AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)this.myProject, (ProjectSystemId)systemId);
            Map modificationStamps = localSettings.getExternalConfigModificationStamps();
            long timeStamp = this.calculateModificationHash((ExternalSystemAutoImportAware)manager, externalProjectPath);
            modificationStamps.put(externalProjectPath, timeStamp);
        }
        this.myUpdatesQueue.queue(new Update(Pair.create((Object)systemId, (Object)externalProjectPath)){

            public void run() {
                ExternalSystemProjectsWatcherImpl.this.doUpdateNotifications(true, systemId, externalProjectPath);
            }
        });
    }

    private static boolean fileWasChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(10);
        }
        if (!file2.isValid()) {
            return true;
        }
        Long currentCrc = (Long)file2.getUserData(CRC_WITHOUT_SPACES_CURRENT);
        Long oldCrc = (Long)file2.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT);
        return currentCrc == null || !currentCrc.equals(oldCrc);
    }

    private boolean projectWasChanged(@NotNull String externalProjectPath) {
        if (externalProjectPath == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(11);
        }
        for (String filePath : new ArrayList(this.myKnownAffectedFiles.get((Object)externalProjectPath))) {
            VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(filePath), (boolean)false);
            if (file2 != null && !ExternalSystemProjectsWatcherImpl.fileWasChanged(file2)) continue;
            return true;
        }
        return false;
    }

    private static void refreshFileCrcInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(12);
        }
        if (!file2.isValid()) {
            return;
        }
        Long crc = ExternalSystemProjectsWatcherImpl.calculateCrc(file2);
        file2.putUserData(CRC_WITHOUT_SPACES_CURRENT, (Object)crc);
    }

    private boolean isUpToDate(@NotNull String projectPath) {
        if (projectPath == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(13);
        }
        return this.myWatchedProjects.getOrDefault(projectPath, new ProjectStatus()).isUpToDate();
    }

    private void updateProjectStatus(@Nullable String projectPath, @NotNull Consumer<ProjectStatus> update2) {
        if (update2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(14);
        }
        if (projectPath == null) {
            return;
        }
        this.myWatchedProjects.compute(projectPath, (path, status) -> {
            status = status == null ? new ProjectStatus() : status;
            update2.accept((ProjectStatus)status);
            return status;
        });
    }

    private void addToRefreshQueue(final String projectPath, final ProjectSystemId systemId, final boolean reportRefreshError) {
        this.myRefreshRequestsQueue.queue(new Update(Pair.create((Object)systemId, (Object)projectPath)){

            public void run() {
                ExternalSystemProjectsWatcherImpl.scheduleRefresh(ExternalSystemProjectsWatcherImpl.this.myProject, projectPath, systemId, reportRefreshError);
            }
        });
    }

    private void updateWatchedRoots(boolean isProjectOpen) {
        SmartList pathsToWatch = new SmartList();
        this.myFilesPointers.clear();
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchedRoots);
        HashMap<String, VirtualFilePointer> pointerMap = new HashMap<String, VirtualFilePointer>();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(manager instanceof ExternalSystemAutoImportAware)) continue;
            ExternalSystemAutoImportAware importAware = (ExternalSystemAutoImportAware)manager;
            for (ExternalProjectSettings settings : ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings()) {
                Long affectedFilesTimestamp;
                ExternalSystemProjectsWatcherImpl.debug("Update watched roots for '" + settings.getExternalProjectPath() + "'");
                List files2 = importAware.getAffectedExternalProjectFiles(settings.getExternalProjectPath(), this.myProject);
                long timeStamp = this.calculateModificationHash(importAware, settings.getExternalProjectPath());
                Map modificationStamps = ((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject)).getExternalConfigModificationStamps();
                if (isProjectOpen && !ExternalSystemUtil.isNewProject(this.myProject) && timeStamp != (affectedFilesTimestamp = Long.valueOf((affectedFilesTimestamp = (Long)modificationStamps.get(settings.getExternalProjectPath())) == null ? -1L : affectedFilesTimestamp))) {
                    String paths = Arrays.toString(files2.stream().map(it -> it.toPath()).toArray());
                    ExternalSystemProjectsWatcherImpl.debug(String.format("Project info is out of date (timeStamp=%d, affectedFilesTimestamp=%d, files=%s)", timeStamp, affectedFilesTimestamp, paths));
                    this.scheduleUpdate(settings.getExternalProjectPath());
                }
                modificationStamps.put(settings.getExternalProjectPath(), timeStamp);
                for (File file2 : files2) {
                    String path;
                    if (file2 == null || (path = ExternalSystemProjectsWatcherImpl.getNormalizedPath(file2)) == null) continue;
                    pathsToWatch.add(path);
                    String url = VfsUtilCore.pathToUrl((String)path);
                    VirtualFilePointer pointer = (VirtualFilePointer)pointerMap.get(url);
                    if (pointer == null) {
                        pointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this.myChangedDocumentsQueue, null);
                        pointerMap.put(url, pointer);
                        VirtualFile virtualFile = pointer.getFile();
                        if (virtualFile != null) {
                            Long crc = (Long)virtualFile.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT);
                            if (crc != null) {
                                modificationStamps.put(path, crc);
                            } else {
                                UIUtil.invokeLaterIfNeeded(() -> {
                                    Long newCrc = ExternalSystemProjectsWatcherImpl.calculateCrc(virtualFile);
                                    virtualFile.putUserData(CRC_WITHOUT_SPACES_CURRENT, (Object)newCrc);
                                    virtualFile.putUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT, (Object)newCrc);
                                    modificationStamps.put(path, newCrc);
                                });
                            }
                        }
                    }
                    this.myFilesPointers.putValue((Object)pointer, (Object)settings.getExternalProjectPath());
                }
            }
        }
        this.myWatchedRoots.addAll(LocalFileSystem.getInstance().addRootsToWatch((Collection)pathsToWatch, false));
    }

    private ProjectSystemId getProjectSystemId(@NotNull String externalProjectPath) {
        if (externalProjectPath == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(15);
        }
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            if (((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectSettings(externalProjectPath) == null) continue;
            return manager.getSystemId();
        }
        return null;
    }

    private long calculateModificationHash(@NotNull ExternalSystemAutoImportAware importAware, @NotNull String externalProjectPath) {
        if (importAware == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(16);
        }
        if (externalProjectPath == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(17);
        }
        List affectedFiles = importAware.getAffectedExternalProjectFiles(externalProjectPath, this.myProject);
        return affectedFiles.stream().map(it -> it.lastModified()).reduce(0L, (a, b) -> a + b);
    }

    @Nullable
    private String getRelatedExternalProjectPath(VirtualFile file2) {
        String path = file2.getPath();
        return this.getRelatedExternalProjectPath(path);
    }

    @Nullable
    private String getRelatedExternalProjectPath(String path) {
        ExternalSystemAutoImportAware importAware;
        String externalProjectPath = null;
        Iterator<ExternalSystemAutoImportAware> iterator = this.myImportAwareManagers.iterator();
        while (iterator.hasNext() && (externalProjectPath = (importAware = iterator.next()).getAffectedExternalProjectPath(path, this.myProject)) == null) {
        }
        if (externalProjectPath != null) {
            this.myKnownAffectedFiles.putValue(externalProjectPath, (Object)path);
        }
        return externalProjectPath;
    }

    private void closeAllNotifications() {
        for (MyNotification notification : this.myNotificationMap.values()) {
            notification.expire();
        }
        this.myNotificationMap.clear();
    }

    private void doUpdateNotifications(boolean close2, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        if (systemId == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(18);
        }
        if (projectPath == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(19);
        }
        MyNotification notification = this.myNotificationMap.get(systemId);
        if (close2) {
            ExternalSystemProjectsWatcherImpl.debug("Close notification for '" + projectPath + "'");
            if (notification == null) {
                return;
            }
            notification.projectPaths.remove(projectPath);
            if (notification.projectPaths.isEmpty()) {
                notification.expire();
            }
        } else {
            ExternalSystemProjectsWatcherImpl.debug("Create notification for '" + projectPath + "'");
            if (notification != null && !notification.isExpired()) {
                notification.projectPaths.add(projectPath);
                return;
            }
            notification = new MyNotification(this.myProject, this.myNotificationMap, systemId, projectPath);
            this.myNotificationMap.put(systemId, notification);
            Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        }
    }

    private static void scheduleRefresh(final @NotNull Project project, String projectPath, ProjectSystemId systemId, boolean reportRefreshError) {
        if (project == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(20);
        }
        ExternalSystemUtil.refreshProject(project, systemId, projectPath, new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject != null) {
                    ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project, true);
                }
            }
        }, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, reportRefreshError);
    }

    private static void makeUserAware(final MergingUpdateQueue mergingUpdateQueue, Project project) {
        ApplicationManager.getApplication().runReadAction(() -> {
            EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
            multicaster.addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    mergingUpdateQueue.restartTimer();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$9", "caretPositionChanged"));
                }
            }, (Disposable)mergingUpdateQueue);
            multicaster.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    mergingUpdateQueue.restartTimer();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$10", "documentChanged"));
                }
            }, (Disposable)mergingUpdateQueue);
            project.getMessageBus().connect((Disposable)mergingUpdateQueue).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
                int beforeCalled;

                public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    if (this.beforeCalled++ == 0) {
                        mergingUpdateQueue.suspend();
                    }
                }

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        11.$$$reportNull$$$0(1);
                    }
                    if (this.beforeCalled == 0) {
                        return;
                    }
                    if (--this.beforeCalled == 0) {
                        mergingUpdateQueue.resume();
                        mergingUpdateQueue.restartTimer();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$11";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeRootsChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "rootsChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
    }

    @Nullable
    private Pair<ExternalSystemManager, ExternalProjectSettings> findLinkedProjectSettings(String projectPath) {
        ExternalProjectSettings[] linkedProjectSettings = new ExternalProjectSettings[1];
        Optional<ExternalSystemManager> systemManager = ExternalSystemApiUtil.getAllManagers().stream().filter(m -> {
            linkedProjectSettings[0] = ((AbstractExternalSystemSettings)m.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectSettings(projectPath);
            return linkedProjectSettings[0] != null;
        }).findAny();
        if (!systemManager.isPresent()) {
            return null;
        }
        ExternalSystemManager manager = systemManager.get();
        return Pair.create((Object)manager, (Object)linkedProjectSettings[0]);
    }

    @NotNull
    private List<Pair<ExternalSystemManager, ExternalProjectSettings>> findLinkedProjectsSettings() {
        List<Pair<ExternalSystemManager, ExternalProjectSettings>> list2 = ExternalSystemApiUtil.getAllManagers().stream().flatMap(manager -> ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings().stream().map(settings -> Pair.create((Object)manager, (Object)settings))).collect(Collectors.toList());
        if (list2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @Nullable
    private static String getNormalizedPath(@NotNull File file2) {
        String canonized;
        if (file2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(22);
        }
        return (canonized = PathUtil.getCanonicalPath((String)file2.getAbsolutePath())) == null ? null : FileUtil.toSystemIndependentName((String)canonized);
    }

    private static long calculateCrc(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(23);
        }
        return new ConfigurationFileCrcFactory(file2).create();
    }

    private static void debug(@NotNull String message) {
        if (message == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(24);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProject";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 10: 
            case 12: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importAware";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findLinkedProjectsSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onFailure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onCancel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onEnd";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleRevertedChanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fileWasChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "projectWasChanged";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "refreshFileCrcInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectStatus";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSystemId";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calculateModificationHash";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateNotifications";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRefresh";
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedPath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "calculateCrc";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static interface Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project var1);

        public void markDirty(@NotNull Module var1);

        default public void markDirty(@NotNull String projectPath) {
            if (projectPath == null) {
                Contributor.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$Contributor", "markDirty"));
        }
    }

    private class FileChangeListener
    extends AsyncFileChangeListenerBase {
        private final ExternalSystemProjectsWatcherImpl myWatcher;
        private final MultiMap<String, String> myKnownFiles = MultiMap.createSet();
        private List<VirtualFile> filesToUpdate;
        private List<VirtualFile> filesToRemove;

        FileChangeListener(ExternalSystemProjectsWatcherImpl watcher) {
            this.myWatcher = watcher;
        }

        @Override
        protected boolean isRelevant(String path) {
            if (!this.myKnownFiles.get((Object)path).isEmpty()) {
                return true;
            }
            for (VirtualFilePointer pointer : ExternalSystemProjectsWatcherImpl.this.myFilesPointers.keySet()) {
                String filePath = VfsUtilCore.urlToPath((String)pointer.getUrl());
                if (StringUtil.isNotEmpty((String)filePath) && FileUtil.namesEqual((String)path, (String)filePath)) {
                    for (String projectPath : ExternalSystemProjectsWatcherImpl.this.myFilesPointers.get((Object)pointer)) {
                        this.myKnownFiles.putValue((Object)path, (Object)projectPath);
                        ExternalSystemProjectsWatcherImpl.this.myKnownAffectedFiles.putValue((Object)projectPath, (Object)path);
                    }
                    return true;
                }
                if (!LOG.isDebugEnabled() || !StringUtil.isNotEmpty((String)filePath) || !FileUtil.namesEqual((String)FileUtil.toCanonicalPath((String)path), (String)FileUtil.toCanonicalPath((String)filePath))) continue;
                LOG.debug("Changes were ignored: " + path + ". Related FW: " + filePath);
            }
            String affectedProjectPath = ExternalSystemProjectsWatcherImpl.this.getRelatedExternalProjectPath(path);
            if (affectedProjectPath != null) {
                this.myKnownFiles.putValue((Object)path, (Object)affectedProjectPath);
            }
            return affectedProjectPath != null;
        }

        @Override
        protected void updateFile(VirtualFile file2, VFileEvent event) {
            this.init();
            ExternalSystemProjectsWatcherImpl.debug("File changed '" + file2.getPath() + "'");
            ExternalSystemProjectsWatcherImpl.refreshFileCrcInfo(file2);
            if (event instanceof VFileContentChangeEvent && ExternalSystemProjectsWatcherImpl.fileWasChanged(file2)) {
                for (String externalProjectPath : this.myKnownFiles.get((Object)file2.getPath())) {
                    ExternalSystemProjectsWatcherImpl.this.updateProjectStatus(externalProjectPath, it -> it.markModified(file2.getModificationStamp()));
                }
                this.filesToUpdate.add(file2);
            } else {
                for (String externalProjectPath : this.myKnownFiles.get((Object)file2.getPath())) {
                    if (ExternalSystemProjectsWatcherImpl.this.projectWasChanged(externalProjectPath)) continue;
                    ExternalSystemProjectsWatcherImpl.this.updateProjectStatus(externalProjectPath, it -> it.markReverted(file2.getModificationStamp()));
                    if (!ExternalSystemProjectsWatcherImpl.this.isUpToDate(externalProjectPath)) continue;
                    ExternalSystemProjectsWatcherImpl.this.handleRevertedChanges(externalProjectPath);
                }
            }
        }

        @Override
        protected void prepareFileDeletion(VirtualFile file2) {
            for (String externalProjectPath : this.myKnownFiles.get((Object)file2.getPath())) {
                ExternalSystemProjectsWatcherImpl.this.updateProjectStatus(externalProjectPath, it -> it.markModified(file2.getModificationStamp()));
            }
            this.init();
            ExternalSystemProjectsWatcherImpl.debug("File removed '" + file2.getPath() + "'");
            this.filesToRemove.add(file2);
        }

        @Override
        protected void apply() {
            if (this.areFileSetsInitialised()) {
                this.filesToUpdate.removeAll(this.filesToRemove);
                this.scheduleUpdate(ContainerUtil.concat(this.filesToUpdate, this.filesToRemove));
            }
            this.reset();
        }

        private boolean areFileSetsInitialised() {
            return this.filesToUpdate != null;
        }

        private void scheduleUpdate(List<VirtualFile> filesToUpdate) {
            filesToUpdate.stream().flatMap(f -> this.myKnownFiles.get((Object)f.getPath()).stream()).distinct().forEach(path -> this.myWatcher.scheduleUpdate(path, false));
        }

        private void init() {
            if (this.areFileSetsInitialised()) {
                return;
            }
            this.filesToUpdate = new ArrayList<VirtualFile>();
            this.filesToRemove = Collections.synchronizedList(new ArrayList());
        }

        @Override
        protected void reset() {
            this.filesToUpdate = null;
            this.filesToRemove = null;
            this.myKnownFiles.clear();
        }
    }

    private static class MyNotification
    extends Notification {
        private final ProjectSystemId mySystemId;
        private final Map<ProjectSystemId, MyNotification> myNotificationMap;
        private final Set<String> projectPaths;

        MyNotification(final Project project, Map<ProjectSystemId, MyNotification> notificationMap, final ProjectSystemId systemId, String projectPath) {
            super(systemId.getReadableName() + " Import", ExternalSystemBundle.message((String)"import.needed", (Object[])new Object[]{systemId.getReadableName()}), "", NotificationType.INFORMATION, null);
            this.mySystemId = systemId;
            this.myNotificationMap = notificationMap;
            this.projectPaths = ContainerUtil.newHashSet((Object[])new String[]{projectPath});
            this.addAction((AnAction)new NotificationAction(ExternalSystemBundle.message((String)"import.importChanged", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.doAction(notification, project, systemId, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.addAction((AnAction)new NotificationAction(ExternalSystemBundle.message((String)"import.enableAutoImport", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    this.doAction(notification, project, systemId, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public void expire() {
            super.expire();
            this.projectPaths.clear();
            this.myNotificationMap.remove(this.mySystemId);
        }

        private void doAction(@NotNull Notification notification, Project project, ProjectSystemId systemId, boolean isAutoImport) {
            if (notification == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            this.projectPaths.stream().map(path -> ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)systemId).getLinkedProjectSettings(path)).distinct().filter(Objects::nonNull).forEach(settings -> {
                if (isAutoImport) {
                    settings.setUseAutoImport(true);
                }
                ExternalSystemProjectsWatcherImpl.scheduleRefresh(project, settings.getExternalProjectPath(), systemId, !isAutoImport);
            });
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification", "doAction"));
        }
    }
}

