/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowHeadlessManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolWindowManager {
    public static void handle(final @NotNull Project project) {
        if (project == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(0);
        }
        for (final ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            final AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
            settings.subscribe((ExternalSystemSettingsListener)new ExternalSystemSettingsListenerAdapter(){

                public void onProjectsLinked(@NotNull Collection linked) {
                    if (linked == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Consumer activate = toolWindow -> toolWindow.setAvailable(true, () -> {
                        boolean shouldShow;
                        boolean bl = shouldShow = settings.getLinkedProjectsSettings().size() == 1;
                        if (shouldShow) {
                            toolWindow.show(null);
                        }
                    });
                    ToolWindow toolWindow2 = ExternalToolWindowManager.getToolWindow(project, manager.getSystemId());
                    if (toolWindow2 != null) {
                        activate.consume((Object)toolWindow2);
                    } else {
                        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
                            if (project.isDisposed()) {
                                return;
                            }
                            ExternalSystemUtil.ensureToolWindowInitialized(project, manager.getSystemId());
                            ToolWindowManager.getInstance((Project)project).invokeLater(() -> {
                                if (project.isDisposed()) {
                                    return;
                                }
                                ToolWindow toolWindow1 = ExternalToolWindowManager.getToolWindow(project, manager.getSystemId());
                                if (toolWindow1 != null) {
                                    activate.consume((Object)toolWindow1);
                                }
                            });
                        }));
                    }
                }

                public void onProjectsUnlinked(@NotNull Set linkedProjectPaths) {
                    if (linkedProjectPaths == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!settings.getLinkedProjectsSettings().isEmpty()) {
                        return;
                    }
                    ToolWindow toolWindow = ExternalToolWindowManager.getToolWindow(project, manager.getSystemId());
                    if (toolWindow != null) {
                        UIUtil.invokeLaterIfNeeded(() -> toolWindow.setAvailable(false, null));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "linked";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "linkedProjectPaths";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onProjectsLinked";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onProjectsUnlinked";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Nullable
    public static ToolWindow getToolWindow(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        ToolWindowManager toolWindowManager;
        if (project == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(1);
        }
        if (externalSystemId == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(2);
        }
        if ((toolWindowManager = ToolWindowManager.getInstance((Project)project)) == null) {
            return null;
        }
        ToolWindow result2 = toolWindowManager.getToolWindow(externalSystemId.getReadableName());
        if (result2 instanceof ToolWindowImpl) {
            ((ToolWindowImpl)result2).ensureContentInitialized();
        }
        if (result2 == null && ApplicationManager.getApplication().isUnitTestMode()) {
            result2 = new ToolWindowHeadlessManagerImpl.MockToolWindow(project);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolWindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

