/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.actions.CtrlYActionChooser;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapImplKt;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.WeakKeymapManagerListener;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeymapManager", storages={@Storage(value="keymap.xml", roamingType=RoamingType.PER_OS)}, additionalExportFile="keymaps")
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 :2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001:B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0012\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u0011H\u0002J\u0016\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\tJ\u0012\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010!\u001a\u00020\u0011H\u0016J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#H\u0016\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0&H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00112\u0006\u0010(\u001a\u00020\tH\u0016J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010+J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0003H\u0016J\b\u00100\u001a\u00020\u0013H\u0002J\u0010\u00101\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\fH\u0016J\u0010\u00104\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J.\u00105\u001a\u00020\u00132\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\b\u00107\u001a\u0004\u0018\u00010\u00112\u000e\u00108\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010+J\u0010\u00109\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\tH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\n\u001a$\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapManagerImpl;", "Lcom/intellij/openapi/keymap/ex/KeymapManagerEx;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "factory", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "(Lcom/intellij/openapi/options/SchemeManagerFactory;)V", "boundShortcuts", "Lgnu/trove/THashMap;", "", "listeners", "", "Lcom/intellij/openapi/keymap/KeymapManagerListener;", "kotlin.jvm.PlatformType", "", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/openapi/keymap/Keymap;", "addKeymapManagerListener", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addWeakListener", "bindShortcuts", "sourceActionId", "targetActionId", "fireActiveKeymapChanged", "newScheme", "fireShortcutChanged", "keymap", "actionId", "getActionBinding", "getActiveKeymap", "getAllKeymaps", "", "()[Lcom/intellij/openapi/keymap/Keymap;", "getBoundActions", "", "getKeymap", "name", "getKeymaps", "additionalFilter", "Ljava/util/function/Predicate;", "getSchemeManager", "getState", "loadState", "state", "pollQueue", "removeKeymapManagerListener", "removeWeakListener", "listenerToRemove", "setActiveKeymap", "setKeymaps", "keymaps", "active", "removeCondition", "unbindShortcuts", "Companion", "intellij.platform.ide.impl"})
public final class KeymapManagerImpl
extends KeymapManagerEx
implements PersistentStateComponent<Element> {
    private final List<KeymapManagerListener> listeners;
    private final THashMap<String, String> boundShortcuts;
    private final SchemeManager<Keymap> schemeManager;
    private static boolean isKeymapManagerInitialized;
    public static final Companion Companion;

    private final void fireActiveKeymapChanged(Keymap newScheme) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ((KeymapManagerListener)application.getMessageBus().syncPublisher(KeymapManagerListener.TOPIC)).activeKeymapChanged(this.getActiveKeymap());
        for (KeymapManagerListener listener2 : this.listeners) {
            listener2.activeKeymapChanged(newScheme);
        }
    }

    @Override
    @NotNull
    public Keymap[] getAllKeymaps() {
        Collection $this$toTypedArray$iv = this.getKeymaps(null);
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Keymap[] keymapArray = thisCollection$iv.toArray(new Keymap[0]);
        if (keymapArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return keymapArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Keymap> getKeymaps(@Nullable Predicate<Keymap> additionalFilter) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.schemeManager.getAllSchemes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Keymap it = (Keymap)element$iv$iv;
            boolean bl = false;
            String string = it.getPresentableName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.presentableName");
            if (!(!StringsKt.startsWith$default((String)string, (String)"$", (boolean)false, (int)2, null) && (additionalFilter == null || additionalFilter.test(it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Keymap getKeymap(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.schemeManager.findSchemeByName(name);
    }

    @NotNull
    public Keymap getActiveKeymap() {
        Keymap keymap;
        Keymap keymap2 = this.schemeManager.getActiveScheme();
        if (keymap2 == null) {
            keymap2 = keymap = this.schemeManager.findSchemeByName(DefaultKeymap.Companion.getInstance().getDefaultKeymapName());
        }
        if (keymap2 == null) {
            Keymap keymap3 = this.schemeManager.findSchemeByName("$default");
            if (keymap3 == null) {
                Intrinsics.throwNpe();
            }
            keymap = keymap3;
        }
        return keymap;
    }

    @Override
    public void setActiveKeymap(@NotNull Keymap keymap) {
        Intrinsics.checkParameterIsNotNull((Object)keymap, (String)"keymap");
        SchemeManager.setCurrent$default(this.schemeManager, keymap, false, 2, null);
    }

    @Override
    public void bindShortcuts(@NotNull String sourceActionId, @NotNull String targetActionId) {
        Intrinsics.checkParameterIsNotNull((Object)sourceActionId, (String)"sourceActionId");
        Intrinsics.checkParameterIsNotNull((Object)targetActionId, (String)"targetActionId");
        this.boundShortcuts.put((Object)targetActionId, (Object)sourceActionId);
    }

    @Override
    public void unbindShortcuts(@NotNull String targetActionId) {
        Intrinsics.checkParameterIsNotNull((Object)targetActionId, (String)"targetActionId");
        this.boundShortcuts.remove((Object)targetActionId);
    }

    @Override
    @NotNull
    public Set<String> getBoundActions() {
        Set set = this.boundShortcuts.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"boundShortcuts.keys");
        return set;
    }

    @Override
    @Nullable
    public String getActionBinding(@NotNull String actionId) {
        String next;
        Intrinsics.checkParameterIsNotNull((Object)actionId, (String)"actionId");
        Set visited = null;
        String id = actionId;
        do {
            if ((String)this.boundShortcuts.get((Object)id) == null) {
                break;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)next, (String)"boundShortcuts.get(id) ?: break");
            if (visited != null) continue;
            visited = (Set)new SmartHashSet();
        } while (visited.add(id = next));
        return Intrinsics.areEqual((Object)id, (Object)actionId) ? null : id;
    }

    @Override
    @NotNull
    public SchemeManager<Keymap> getSchemeManager() {
        return this.schemeManager;
    }

    public final void setKeymaps(@NotNull List<? extends Keymap> keymaps, @Nullable Keymap active, @Nullable Predicate<Keymap> removeCondition) {
        Intrinsics.checkParameterIsNotNull(keymaps, (String)"keymaps");
        this.schemeManager.setSchemes(keymaps, active, removeCondition);
        this.fireActiveKeymapChanged(active);
    }

    @NotNull
    public Element getState() {
        Element result2;
        block1: {
            result2 = new Element("state");
            Keymap keymap = this.schemeManager.getActiveScheme();
            if (keymap == null) break block1;
            Keymap keymap2 = keymap;
            boolean bl = false;
            boolean bl2 = false;
            Keymap it = keymap2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)DefaultKeymap.Companion.getInstance().getDefaultKeymapName()) ^ true) {
                Element e = new Element("active_keymap");
                e.setAttribute("name", it.getName());
                result2.addContent(e);
            }
        }
        return result2;
    }

    public void loadState(@NotNull Element state) {
        Element child2;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Element element = child2 = state.getChild("active_keymap");
        String activeKeymapName = element != null ? element.getAttributeValue("name") : null;
        CharSequence charSequence = activeKeymapName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.schemeManager.setCurrentSchemeName(activeKeymapName);
        }
    }

    public void addKeymapManagerListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.add(listener2);
    }

    public void addKeymapManagerListener(@NotNull KeymapManagerListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.pollQueue();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect(parentDisposable).subscribe(KeymapManagerListener.TOPIC, (Object)listener2);
    }

    private final void pollQueue() {
        CollectionsKt.removeAll(this.listeners, (Function1)pollQueue.1.INSTANCE);
    }

    public void removeKeymapManagerListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.remove(listener2);
    }

    @Override
    public void addWeakListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.add(new WeakKeymapManagerListener(this, listener2));
    }

    @Override
    public void removeWeakListener(@NotNull KeymapManagerListener listenerToRemove) {
        Intrinsics.checkParameterIsNotNull((Object)listenerToRemove, (String)"listenerToRemove");
        CollectionsKt.removeAll(this.listeners, (Function1)((Function1)new Function1<KeymapManagerListener, Boolean>(listenerToRemove){
            final /* synthetic */ KeymapManagerListener $listenerToRemove;

            public final boolean invoke(KeymapManagerListener it) {
                return it instanceof WeakKeymapManagerListener && ((WeakKeymapManagerListener)it).isWrapped(this.$listenerToRemove);
            }
            {
                this.$listenerToRemove = keymapManagerListener;
                super(1);
            }
        }));
    }

    public final void fireShortcutChanged(@NotNull Keymap keymap, @NotNull String actionId) {
        Intrinsics.checkParameterIsNotNull((Object)keymap, (String)"keymap");
        Intrinsics.checkParameterIsNotNull((Object)actionId, (String)"actionId");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ((KeymapManagerListener)application.getMessageBus().syncPublisher(KeymapManagerListener.TOPIC)).shortcutChanged(keymap, actionId);
    }

    public KeymapManagerImpl(@NotNull SchemeManagerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ContainerUtil.createLock\u2026<KeymapManagerListener>()");
        this.listeners = list2;
        this.boundShortcuts = new THashMap();
        final DefaultKeymap defaultKeymapManager = DefaultKeymap.Companion.getInstance();
        this.schemeManager = SchemeManagerFactory.create$default(factory, "keymaps", new LazySchemeProcessor<Keymap, KeymapImpl>(){

            @Override
            @NotNull
            public KeymapImpl createScheme(@NotNull SchemeDataHolder<? super KeymapImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                Intrinsics.checkParameterIsNotNull(dataHolder, (String)"dataHolder");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull(attributeProvider, (String)"attributeProvider");
                return KeymapImplKt.KeymapImpl(name, dataHolder);
            }

            @Override
            public void onCurrentSchemeSwitched(@Nullable Keymap oldScheme, @Nullable Keymap newScheme) {
                this.fireActiveKeymapChanged(newScheme);
            }

            @Override
            public void reloaded(@NotNull SchemeManager<Keymap> schemeManager2, @NotNull Collection<? extends Keymap> schemes) {
                Intrinsics.checkParameterIsNotNull(schemeManager2, (String)"schemeManager");
                Intrinsics.checkParameterIsNotNull(schemes, (String)"schemes");
                if (schemeManager2.getActiveScheme() == null) {
                    AppUIUtil.invokeOnEdt(new Runnable(this, schemeManager2){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ SchemeManager $schemeManager;

                        public final void run() {
                            this.$schemeManager.setCurrentSchemeName(this.this$0.defaultKeymapManager.getDefaultKeymapName(), true);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$schemeManager = schemeManager2;
                        }
                    });
                }
            }
        }, null, null, 12, null);
        String systemDefaultKeymap = WelcomeWizardUtil.getWizardMacKeymap() == null ? defaultKeymapManager.getDefaultKeymapName() : WelcomeWizardUtil.getWizardMacKeymap();
        for (Keymap keymap : defaultKeymapManager.getKeymaps()) {
            this.schemeManager.addScheme(keymap);
            if (!Intrinsics.areEqual((Object)keymap.getName(), (Object)systemDefaultKeymap)) continue;
            SchemeManager.setCurrent$default(this.schemeManager, keymap, false, 2, null);
        }
        this.schemeManager.loadSchemes();
        isKeymapManagerInitialized = true;
        if (ConfigImportHelper.isFirstSession() && !ConfigImportHelper.isConfigImported()) {
            CtrlYActionChooser.askAboutShortcut();
        }
    }

    static {
        Companion = new Companion(null);
    }

    public static final boolean isKeymapManagerInitialized() {
        Companion companion = Companion;
        return isKeymapManagerInitialized;
    }

    private static final void setKeymapManagerInitialized(boolean bl) {
        Companion companion = Companion;
        isKeymapManagerInitialized = bl;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R,\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapManagerImpl$Companion;", "", "()V", "<set-?>", "", "isKeymapManagerInitialized", "isKeymapManagerInitialized$annotations", "()Z", "setKeymapManagerInitialized", "(Z)V", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void isKeymapManagerInitialized$annotations() {
        }

        public final boolean isKeymapManagerInitialized() {
            return isKeymapManagerInitialized;
        }

        private final void setKeymapManagerInitialized(boolean bl) {
            isKeymapManagerInitialized = bl;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isKeymapManagerInitialized$p(Companion $this) {
            return $this.isKeymapManagerInitialized();
        }

        public static final /* synthetic */ void access$setKeymapManagerInitialized$p(Companion $this, boolean bl) {
            $this.setKeymapManagerInitialized(bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

