/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderEnumeratorSettings;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OrderEnumeratorBase
extends OrderEnumerator
implements OrderEnumeratorSettings {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.OrderEnumeratorBase");
    private boolean myProductionOnly;
    private boolean myCompileOnly;
    private boolean myRuntimeOnly;
    private boolean myWithoutJdk;
    private boolean myWithoutLibraries;
    boolean myWithoutDepModules;
    private boolean myWithoutModuleSourceEntries;
    boolean myRecursively;
    boolean myRecursivelyExportedOnly;
    private boolean myExportedOnly;
    private Condition<? super OrderEntry> myCondition;
    RootModelProvider myModulesProvider;
    private final OrderRootsCache myCache;

    OrderEnumeratorBase(@Nullable OrderRootsCache cache) {
        this.myCache = cache;
    }

    @NotNull
    static List<OrderEnumerationHandler> getCustomHandlers(@NotNull Module module) {
        if (module == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(0);
        }
        SmartList customHandlers = null;
        for (OrderEnumerationHandler.Factory handlerFactory : (OrderEnumerationHandler.Factory[])OrderEnumerationHandler.EP_NAME.getExtensions()) {
            if (!handlerFactory.isApplicable(module)) continue;
            if (customHandlers == null) {
                customHandlers = new SmartList();
            }
            customHandlers.add(handlerFactory.createHandler(module));
        }
        List<Object> list2 = customHandlers == null ? Collections.emptyList() : customHandlers;
        if (list2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public OrderEnumerator productionOnly() {
        this.myProductionOnly = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(2);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator compileOnly() {
        this.myCompileOnly = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(3);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator runtimeOnly() {
        this.myRuntimeOnly = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(4);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator withoutSdk() {
        this.myWithoutJdk = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(5);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator withoutLibraries() {
        this.myWithoutLibraries = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(6);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator withoutDepModules() {
        this.myWithoutDepModules = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(7);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator withoutModuleSourceEntries() {
        this.myWithoutModuleSourceEntries = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(8);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator recursively() {
        this.myRecursively = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(9);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator exportedOnly() {
        if (this.myRecursively) {
            this.myRecursivelyExportedOnly = true;
        } else {
            this.myExportedOnly = true;
        }
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(10);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator satisfying(@NotNull Condition<? super OrderEntry> condition) {
        if (condition == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(11);
        }
        this.myCondition = condition;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(12);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator using(@NotNull RootModelProvider provider) {
        if (provider == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(13);
        }
        this.myModulesProvider = provider;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(14);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderRootsEnumerator classes() {
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = new OrderRootsEnumeratorImpl(this, OrderRootType.CLASSES);
        if (orderRootsEnumeratorImpl == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(15);
        }
        return orderRootsEnumeratorImpl;
    }

    @NotNull
    public OrderRootsEnumerator sources() {
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = new OrderRootsEnumeratorImpl(this, OrderRootType.SOURCES);
        if (orderRootsEnumeratorImpl == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(16);
        }
        return orderRootsEnumeratorImpl;
    }

    @NotNull
    public OrderRootsEnumerator roots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(17);
        }
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = new OrderRootsEnumeratorImpl(this, rootType);
        if (orderRootsEnumeratorImpl == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(18);
        }
        return orderRootsEnumeratorImpl;
    }

    @NotNull
    public OrderRootsEnumerator roots(@NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> rootTypeProvider) {
        if (rootTypeProvider == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(19);
        }
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = new OrderRootsEnumeratorImpl(this, rootTypeProvider);
        if (orderRootsEnumeratorImpl == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(20);
        }
        return orderRootsEnumeratorImpl;
    }

    ModuleRootModel getRootModel(@NotNull Module module) {
        if (module == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(21);
        }
        if (this.myModulesProvider != null) {
            return this.myModulesProvider.getRootModel(module);
        }
        return ModuleRootManager.getInstance((Module)module);
    }

    @NotNull
    OrderRootsCache getCache() {
        LOG.assertTrue(this.myCache != null, (Object)"Caching is not supported for ModifiableRootModel");
        LOG.assertTrue(this.myCondition == null, (Object)"Caching not supported for OrderEnumerator with 'satisfying(Condition)' option");
        LOG.assertTrue(this.myModulesProvider == null, (Object)"Caching not supported for OrderEnumerator with 'using(ModulesProvider)' option");
        OrderRootsCache orderRootsCache = this.myCache;
        if (orderRootsCache == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(22);
        }
        return orderRootsCache;
    }

    public int getFlags() {
        int flags = 0;
        if (this.myProductionOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myCompileOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRuntimeOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutJdk) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutLibraries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutDepModules) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutModuleSourceEntries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursively) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursivelyExportedOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myExportedOnly) {
            flags |= 1;
        }
        return flags;
    }

    public boolean shouldRecurse(@NotNull ModuleOrderEntry entry, @NotNull List<? extends OrderEnumerationHandler> handlers) {
        if (entry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(23);
        }
        if (handlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(24);
        }
        ProcessEntryAction action2 = this.shouldAddOrRecurse((OrderEntry)entry, true, handlers);
        return action2.type == ProcessEntryActionType.RECURSE;
    }

    @NotNull
    private ProcessEntryAction shouldAddOrRecurse(@NotNull OrderEntry entry, boolean firstLevel, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        ModuleOrderEntry moduleOrderEntry;
        Module depModule;
        boolean exported;
        OrderEnumerationHandler handler2;
        if (entry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(25);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(26);
        }
        if (this.myCondition != null && !this.myCondition.value((Object)entry)) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(27);
            }
            return processEntryAction;
        }
        if (entry instanceof JdkOrderEntry && (this.myWithoutJdk || !firstLevel)) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(28);
            }
            return processEntryAction;
        }
        if (this.myWithoutLibraries && entry instanceof LibraryOrderEntry) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(29);
            }
            return processEntryAction;
        }
        if (this.myWithoutDepModules) {
            if (!this.myRecursively && entry instanceof ModuleOrderEntry) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(30);
                }
                return processEntryAction;
            }
            if (entry instanceof ModuleSourceOrderEntry && !this.isRootModuleModel(((ModuleSourceOrderEntry)entry).getRootModel())) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(31);
                }
                return processEntryAction;
            }
        }
        if (this.myWithoutModuleSourceEntries && entry instanceof ModuleSourceOrderEntry) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(32);
            }
            return processEntryAction;
        }
        OrderEnumerationHandler.AddDependencyType shouldAdd = OrderEnumerationHandler.AddDependencyType.DEFAULT;
        Iterator<? extends OrderEnumerationHandler> iterator = customHandlers.iterator();
        while (iterator.hasNext() && (shouldAdd = (handler2 = iterator.next()).shouldAddDependency(entry, (OrderEnumeratorSettings)this)) == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
        }
        if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(33);
            }
            return processEntryAction;
        }
        boolean bl = exported = !(entry instanceof JdkOrderEntry);
        if (entry instanceof ExportableOrderEntry) {
            ExportableOrderEntry exportableEntry = (ExportableOrderEntry)entry;
            if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
                boolean forTestCompile;
                DependencyScope scope = exportableEntry.getScope();
                boolean bl2 = forTestCompile = scope.isForTestCompile() || scope == DependencyScope.RUNTIME && OrderEnumeratorBase.shouldAddRuntimeDependenciesToTestCompilationClasspath(customHandlers);
                if (this.myCompileOnly && !scope.isForProductionCompile() && !forTestCompile) {
                    ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                    if (processEntryAction == null) {
                        OrderEnumeratorBase.$$$reportNull$$$0(34);
                    }
                    return processEntryAction;
                }
                if (this.myRuntimeOnly && !scope.isForProductionRuntime() && !scope.isForTestRuntime()) {
                    ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                    if (processEntryAction == null) {
                        OrderEnumeratorBase.$$$reportNull$$$0(35);
                    }
                    return processEntryAction;
                }
                if (this.myProductionOnly && (!scope.isForProductionCompile() && !scope.isForProductionRuntime() || this.myCompileOnly && !scope.isForProductionCompile() || this.myRuntimeOnly && !scope.isForProductionRuntime())) {
                    ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                    if (processEntryAction == null) {
                        OrderEnumeratorBase.$$$reportNull$$$0(36);
                    }
                    return processEntryAction;
                }
            }
            exported = exportableEntry.isExported();
        }
        if (!exported) {
            if (this.myExportedOnly) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(37);
                }
                return processEntryAction;
            }
            if (this.myRecursivelyExportedOnly && !firstLevel) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(38);
                }
                return processEntryAction;
            }
        }
        if (this.myRecursively && entry instanceof ModuleOrderEntry && (depModule = (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) != null && OrderEnumeratorBase.shouldProcessRecursively(customHandlers)) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.RECURSE(depModule);
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(39);
            }
            return processEntryAction;
        }
        if (this.myWithoutDepModules && entry instanceof ModuleOrderEntry) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(40);
            }
            return processEntryAction;
        }
        ProcessEntryAction processEntryAction = ProcessEntryAction.PROCESS;
        if (processEntryAction == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(41);
        }
        return processEntryAction;
    }

    protected void processEntries(@NotNull ModuleRootModel rootModel, @NotNull PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>> processor2, @Nullable Set<? super Module> processed2, boolean firstLevel, @NotNull List<OrderEnumerationHandler> customHandlers) {
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(42);
        }
        if (processor2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(43);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(44);
        }
        if (processed2 != null && !processed2.add((Module)rootModel.getModule())) {
            return;
        }
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            ProcessEntryAction action2 = this.shouldAddOrRecurse(entry, firstLevel, customHandlers);
            if (action2.type == ProcessEntryActionType.SKIP) continue;
            if (action2.type == ProcessEntryActionType.RECURSE) {
                this.processEntries(this.getRootModel(action2.recurseOnModule), processor2, processed2, false, customHandlers);
                continue;
            }
            assert (action2.type == ProcessEntryActionType.PROCESS);
            if (processor2.process((Object)entry, customHandlers)) continue;
            return;
        }
    }

    private static boolean shouldAddRuntimeDependenciesToTestCompilationClasspath(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(45);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (!orderEnumerationHandler.shouldAddRuntimeDependenciesToTestCompilationClasspath()) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldProcessRecursively(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(46);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (orderEnumerationHandler.shouldProcessDependenciesRecursively()) continue;
            return false;
        }
        return true;
    }

    public void forEach(@NotNull Processor<? super OrderEntry> processor2) {
        if (processor2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(47);
        }
        this.forEach((PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>>)((PairProcessor)(entry, handlers) -> processor2.process(entry)));
    }

    protected abstract void forEach(@NotNull PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>> var1);

    public void forEachLibrary(@NotNull Processor<? super Library> processor2) {
        if (processor2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(48);
        }
        this.forEach((PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>>)((PairProcessor)(entry, handlers) -> {
            Library library;
            if (entry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)entry).getLibrary()) != null) {
                return processor2.process((Object)library);
            }
            return true;
        }));
    }

    public void forEachModule(@NotNull Processor<? super Module> processor2) {
        if (processor2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(49);
        }
        this.forEach((PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>>)((PairProcessor)(orderEntry, customHandlers) -> {
            Module module;
            if (this.myRecursively && orderEntry instanceof ModuleSourceOrderEntry) {
                Module module2 = ((ModuleSourceOrderEntry)orderEntry).getRootModel().getModule();
                return processor2.process((Object)module2);
            }
            if (!(!(orderEntry instanceof ModuleOrderEntry) || this.myRecursively && OrderEnumeratorBase.shouldProcessRecursively(customHandlers) || (module = ((ModuleOrderEntry)orderEntry).getModule()) == null)) {
                return processor2.process((Object)module);
            }
            return true;
        }));
    }

    public <R> R process(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(50);
        }
        OrderEntryProcessor processor2 = new OrderEntryProcessor(policy, initialValue);
        this.forEach(processor2);
        return (R)processor2.myValue;
    }

    static boolean shouldIncludeTestsFromDependentModulesToTestClasspath(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(51);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (orderEnumerationHandler.shouldIncludeTestsFromDependentModulesToTestClasspath()) continue;
            return false;
        }
        return true;
    }

    static boolean addCustomRootsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<? super VirtualFile> result2, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (forOrderEntry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(52);
        }
        if (type == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(53);
        }
        if (result2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(54);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(55);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList urls = new ArrayList();
            boolean added = orderEnumerationHandler.addCustomRootsForLibrary(forOrderEntry, type, urls);
            for (String url : urls) {
                ContainerUtil.addIfNotNull(result2, (Object)VirtualFileManager.getInstance().findFileByUrl(url));
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    static boolean addCustomRootUrlsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<? super String> result2, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (forOrderEntry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(56);
        }
        if (type == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(57);
        }
        if (result2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(58);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(59);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList urls = new ArrayList();
            boolean added = orderEnumerationHandler.addCustomRootsForLibrary(forOrderEntry, type, urls);
            result2.addAll(urls);
            if (!added) continue;
            return true;
        }
        return false;
    }

    static boolean addCustomRootsForModule(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<? super VirtualFile> result2, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (type == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(60);
        }
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(61);
        }
        if (result2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(62);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(63);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList urls = new ArrayList();
            boolean added = orderEnumerationHandler.addCustomModuleRoots(type, rootModel, urls, includeProduction, includeTests);
            for (String url : urls) {
                ContainerUtil.addIfNotNull(result2, (Object)VirtualFileManager.getInstance().findFileByUrl(url));
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    public boolean isRuntimeOnly() {
        return this.myRuntimeOnly;
    }

    public boolean isCompileOnly() {
        return this.myCompileOnly;
    }

    public boolean isProductionOnly() {
        return this.myProductionOnly;
    }

    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(64);
        }
        return false;
    }

    public abstract void processRootModules(@NotNull Processor<? super Module> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypeProvider";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 26: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 55: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHandlers";
                break;
            }
            case 42: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 43: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forOrderEntry";
                break;
            }
            case 53: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 54: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHandlers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "productionOnly";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compileOnly";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeOnly";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutSdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutLibraries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutDepModules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutModuleSourceEntries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "recursively";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "exportedOnly";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "satisfying";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "using";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "classes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sources";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "roots";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldAddOrRecurse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomHandlers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "satisfying";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "using";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "roots";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRootModel";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecurse";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddOrRecurse";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processEntries";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddRuntimeDependenciesToTestCompilationClasspath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessRecursively";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "forEachLibrary";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "forEachModule";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "shouldIncludeTestsFromDependentModulesToTestClasspath";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsForLibrary";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootUrlsForLibrary";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsForModule";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isRootModuleModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OrderEntryProcessor<R>
    implements PairProcessor<OrderEntry, List<OrderEnumerationHandler>> {
        private R myValue;
        private final RootPolicy<R> myPolicy;

        private OrderEntryProcessor(@NotNull RootPolicy<R> policy, R initialValue) {
            if (policy == null) {
                OrderEntryProcessor.$$$reportNull$$$0(0);
            }
            this.myPolicy = policy;
            this.myValue = initialValue;
        }

        public boolean process(OrderEntry orderEntry, List<OrderEnumerationHandler> customHandlers) {
            this.myValue = orderEntry.accept(this.myPolicy, this.myValue);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/openapi/roots/impl/OrderEnumeratorBase$OrderEntryProcessor", "<init>"));
        }
    }

    protected static class ProcessEntryAction {
        @NotNull
        public ProcessEntryActionType type;
        @Nullable
        Module recurseOnModule;
        public static final ProcessEntryAction SKIP = new ProcessEntryAction(ProcessEntryActionType.SKIP);
        public static final ProcessEntryAction PROCESS = new ProcessEntryAction(ProcessEntryActionType.PROCESS);

        private ProcessEntryAction(@NotNull ProcessEntryActionType type) {
            if (type == null) {
                ProcessEntryAction.$$$reportNull$$$0(0);
            }
            this.type = type;
        }

        @NotNull
        static ProcessEntryAction RECURSE(@NotNull Module module) {
            if (module == null) {
                ProcessEntryAction.$$$reportNull$$$0(1);
            }
            ProcessEntryAction result2 = new ProcessEntryAction(ProcessEntryActionType.RECURSE);
            result2.recurseOnModule = module;
            ProcessEntryAction processEntryAction = result2;
            if (processEntryAction == null) {
                ProcessEntryAction.$$$reportNull$$$0(2);
            }
            return processEntryAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase$ProcessEntryAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase$ProcessEntryAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "RECURSE";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "RECURSE";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static enum ProcessEntryActionType {
        SKIP,
        RECURSE,
        PROCESS;

    }
}

