/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.libraries.ui.impl.LibraryRootsDetectorImpl;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryRootsComponentDescriptor {
    @Nullable
    public abstract OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType var1);

    @NotNull
    public abstract List<? extends RootDetector> getRootDetectors();

    @NotNull
    public LibraryRootsDetector getRootsDetector() {
        List<? extends RootDetector> detectors = this.getRootDetectors();
        if (detectors.isEmpty()) {
            throw new IllegalStateException("Detectors list is empty for " + this);
        }
        LibraryRootsDetectorImpl libraryRootsDetectorImpl = new LibraryRootsDetectorImpl(detectors);
        if (libraryRootsDetectorImpl == null) {
            LibraryRootsComponentDescriptor.$$$reportNull$$$0(0);
        }
        return libraryRootsDetectorImpl;
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String libraryName) {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
        descriptor2.setTitle(StringUtil.isEmpty((String)libraryName) ? ProjectBundle.message((String)"library.attach.files.action", (Object[])new Object[0]) : ProjectBundle.message((String)"library.attach.files.to.library.action", (Object[])new Object[]{libraryName}));
        descriptor2.setDescription(ProjectBundle.message((String)"library.attach.files.description", (Object[])new Object[0]));
        FileChooserDescriptor fileChooserDescriptor = descriptor2;
        if (fileChooserDescriptor == null) {
            LibraryRootsComponentDescriptor.$$$reportNull$$$0(1);
        }
        return fileChooserDescriptor;
    }

    @NotNull
    public abstract List<? extends AttachRootButtonDescriptor> createAttachButtons();

    public OrderRootType[] getRootTypes() {
        return OrderRootType.getAllTypes();
    }

    public String getAttachFilesActionName() {
        return ProjectBundle.message((String)"button.text.attach.files", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/roots/libraries/ui/LibraryRootsComponentDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachFilesChooserDescriptor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

