/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class JBListUpdater
implements ListComponentUpdater {
    private final JBList myComponent;

    public JBListUpdater(JBList component) {
        this.myComponent = component;
    }

    public void paintBusy(boolean paintBusy) {
        Runnable runnable2 = () -> this.myComponent.setPaintBusy(paintBusy);
        SwingUtilities.invokeLater(runnable2);
    }

    public JBList getJBList() {
        return this.myComponent;
    }

    public void replaceModel(@NotNull List<? extends PsiElement> data) {
        if (data == null) {
            JBListUpdater.$$$reportNull$$$0(0);
        }
        Object selectedValue = this.myComponent.getSelectedValue();
        int index = this.myComponent.getSelectedIndex();
        ListModel model2 = this.myComponent.getModel();
        if (model2 instanceof NameFilteringListModel) {
            ((NameFilteringListModel)model2).replaceAll(data);
        } else if (model2 instanceof CollectionListModel) {
            ((CollectionListModel)model2).replaceAll(data);
        } else {
            throw new UnsupportedOperationException("JList model of class " + model2.getClass() + " is not supported by JBListUpdater");
        }
        if (index == 0) {
            this.myComponent.setSelectedIndex(0);
        } else {
            this.myComponent.setSelectedValue(selectedValue, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/ui/JBListUpdater", "replaceModel"));
    }
}

