/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RefreshSessionImpl
extends RefreshSession {
    private static final Logger LOG = Logger.getInstance(RefreshSession.class);
    private static final AtomicLong ID_COUNTER = new AtomicLong(0L);
    private final long myId;
    private final boolean myIsAsync;
    private final boolean myIsRecursive;
    private final Runnable myFinishRunnable;
    private final Throwable myStartTrace;
    private final Semaphore mySemaphore;
    private List<VirtualFile> myWorkQueue;
    private final List<VFileEvent> myEvents;
    private volatile RefreshWorker myWorker;
    private volatile boolean myCancelled;
    private final TransactionId myTransaction;
    private boolean myLaunched;

    RefreshSessionImpl(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState context) {
        if (context == null) {
            RefreshSessionImpl.$$$reportNull$$$0(0);
        }
        this.myId = ID_COUNTER.incrementAndGet();
        this.mySemaphore = new Semaphore();
        this.myWorkQueue = new ArrayList<VirtualFile>();
        this.myEvents = new ArrayList<VFileEvent>();
        this.myIsAsync = async;
        this.myIsRecursive = recursive;
        this.myFinishRunnable = finishRunnable;
        this.myTransaction = ((TransactionGuardImpl)TransactionGuard.getInstance()).getModalityTransaction(context);
        LOG.assertTrue(context == ModalityState.NON_MODAL || context != ModalityState.any(), (Object)"Refresh session should have a specific modality");
        this.myStartTrace = this.rememberStartTrace();
    }

    private Throwable rememberStartTrace() {
        if (ApplicationManager.getApplication().isUnitTestMode() && (this.myIsAsync || !ApplicationManager.getApplication().isDispatchThread())) {
            return new Throwable();
        }
        return null;
    }

    RefreshSessionImpl(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            RefreshSessionImpl.$$$reportNull$$$0(1);
        }
        this(false, false, null, ModalityState.defaultModalityState());
        this.myEvents.addAll(events);
    }

    public long getId() {
        return this.myId;
    }

    public void addAllFiles(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            RefreshSessionImpl.$$$reportNull$$$0(2);
        }
        for (VirtualFile virtualFile : files2) {
            if (virtualFile == null) {
                LOG.error("null passed among " + files2);
                continue;
            }
            this.addFile(virtualFile);
        }
    }

    public void addFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RefreshSessionImpl.$$$reportNull$$$0(3);
        }
        if (this.myLaunched) {
            throw new IllegalStateException("Adding files is only allowed before launch");
        }
        if (file2 instanceof NewVirtualFile) {
            this.myWorkQueue.add(file2);
        } else {
            LOG.debug("skipped: " + file2 + " / " + file2.getClass());
        }
    }

    public boolean isAsynchronous() {
        return this.myIsAsync;
    }

    public void launch() {
        if (this.myLaunched) {
            throw new IllegalStateException("launch() can be called only once");
        }
        this.myLaunched = true;
        this.mySemaphore.down();
        ((RefreshQueueImpl)RefreshQueue.getInstance()).execute(this);
    }

    void scan() {
        boolean forceRefresh;
        List<VirtualFile> workQueue = this.myWorkQueue;
        this.myWorkQueue = new ArrayList<VirtualFile>();
        boolean bl = forceRefresh = !this.myIsRecursive && !this.myIsAsync;
        if (!workQueue.isEmpty()) {
            LocalFileSystem fs = LocalFileSystem.getInstance();
            if (!forceRefresh && fs instanceof LocalFileSystemImpl) {
                ((LocalFileSystemImpl)fs).markSuspiciousFilesDirty(workQueue);
            }
            long t = 0L;
            if (LOG.isTraceEnabled()) {
                LOG.trace("scanning " + workQueue);
                t = System.currentTimeMillis();
            }
            int count = 0;
            block0: do {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("try=" + count);
                }
                for (VirtualFile file2 : workQueue) {
                    RefreshWorker worker;
                    if (this.myCancelled) break block0;
                    NewVirtualFile nvf = (NewVirtualFile)file2;
                    if (forceRefresh) {
                        nvf.markDirty();
                    } else if (!nvf.isDirty()) continue;
                    this.myWorker = worker = new RefreshWorker(nvf, this.myIsRecursive);
                    worker.scan();
                    this.myEvents.addAll(worker.getEvents());
                }
                ++count;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("events=" + this.myEvents.size());
            } while (!this.myCancelled && this.myIsRecursive && count < 3 && ContainerUtil.exists(workQueue, f -> ((NewVirtualFile)f).isDirty()));
            if (t != 0L) {
                t = System.currentTimeMillis() - t;
                LOG.trace((this.myCancelled ? "cancelled, " : "done, ") + t + " ms, events " + this.myEvents);
            }
        }
        this.myWorker = null;
    }

    void cancel() {
        this.myCancelled = true;
        RefreshWorker worker = this.myWorker;
        if (worker != null) {
            worker.cancel();
        }
    }

    void fireEvents(List<? extends VFileEvent> events, @Nullable List<AsyncFileListener.ChangeApplier> appliers) {
        try {
            if (!(this.myFinishRunnable == null && events.isEmpty() || ApplicationManager.getApplication().isDisposed())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("events are about to fire: " + events);
                }
                WriteAction.run(() -> this.fireEventsInWriteAction(events, appliers));
            }
        }
        finally {
            this.mySemaphore.up();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventsInWriteAction(List<? extends VFileEvent> events, @Nullable List<AsyncFileListener.ChangeApplier> appliers) {
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        manager.fireBeforeRefreshStart(this.myIsAsync);
        try {
            AsyncEventSupport.processEvents(events, appliers);
        }
        catch (AssertionError e) {
            if ("PSI/document/model changes are not allowed during highlighting".equals(((Throwable)((Object)e)).getMessage())) {
                throw new AssertionError("VFS changes are not allowed during highlighting", this.myStartTrace);
            }
            throw e;
        }
        finally {
            try {
                manager.fireAfterRefreshFinish(this.myIsAsync);
            }
            finally {
                if (this.myFinishRunnable != null) {
                    this.myFinishRunnable.run();
                }
            }
        }
    }

    void waitFor() {
        this.mySemaphore.waitFor();
    }

    @Nullable
    TransactionId getTransaction() {
        return this.myTransaction;
    }

    public String toString() {
        return this.myWorkQueue.size() <= 1 ? "" : this.myWorkQueue.size() + " roots in queue.";
    }

    @NotNull
    List<? extends VFileEvent> getEvents() {
        ArrayList<VFileEvent> arrayList = new ArrayList<VFileEvent>(new LinkedHashSet<VFileEvent>(this.myEvents));
        if (arrayList == null) {
            RefreshSessionImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/RefreshSessionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/RefreshSessionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAllFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

