/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.EngravedTextGraphics;
import com.intellij.ui.JBColor;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WatermarkIcon;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class BaseLabel
extends JLabel {
    protected ToolWindowContentUi myUi;
    private Color myActiveFg;
    private Color myPassiveFg;
    private boolean myBold;

    public BaseLabel(ToolWindowContentUi ui, boolean bold) {
        this.myUi = ui;
        this.setOpaque(false);
        this.myBold = bold;
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseLabel.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BaseLabel.this.repaint();
            }
        });
    }

    @Override
    public void updateUI() {
        this.setActiveFg(JBColor.foreground());
        this.setPassiveFg(JBColor.foreground());
        super.updateUI();
    }

    @Override
    public Font getFont() {
        Font font = BaseLabel.getLabelFont();
        if (this.myBold) {
            font = font.deriveFont(1);
        }
        return font;
    }

    public static Font getLabelFont() {
        return TabsUtil.getLabelFont();
    }

    public void setActiveFg(Color fg) {
        this.myActiveFg = fg;
    }

    public void setPassiveFg(Color passiveFg) {
        this.myPassiveFg = passiveFg;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color fore = this.myUi.myWindow.isActive() ? this.myActiveFg : this.myPassiveFg;
        this.setForeground(fore);
        GraphicsUtil.setAntialiasingType((JComponent)this, (Object)AntialiasingType.getAAHintForSwingComponent());
        super.paintComponent(this._getGraphics((Graphics2D)g));
        if (this.isFocusOwner()) {
            UIUtil.drawLabelDottedRectangle((JLabel)this, (Graphics)g);
        }
    }

    protected Graphics _getGraphics(Graphics2D g) {
        if (!this.allowEngravement()) {
            return g;
        }
        Color foreground = this.getForeground();
        if (Color.BLACK.equals(foreground)) {
            return new EngravedTextGraphics(g);
        }
        return g;
    }

    protected boolean allowEngravement() {
        return true;
    }

    protected Color getActiveFg(boolean selected2) {
        return this.myActiveFg;
    }

    protected Color getPassiveFg(boolean selected2) {
        return this.myPassiveFg;
    }

    protected void updateTextAndIcon(Content content2, boolean isSelected) {
        if (content2 == null) {
            this.setText(null);
            this.setIcon(null);
        } else {
            this.setText(content2.getDisplayName());
            this.setActiveFg(this.getActiveFg(isSelected));
            this.setPassiveFg(this.getPassiveFg(isSelected));
            this.setToolTipText(content2.getDescription());
            boolean show = Boolean.TRUE.equals(content2.getUserData(ToolWindow.SHOW_CONTENT_ICON));
            if (show) {
                ComponentOrientation componentOrientation = (ComponentOrientation)content2.getUserData(Content.TAB_LABEL_ORIENTATION_KEY);
                if (componentOrientation != null) {
                    this.setComponentOrientation(componentOrientation);
                }
                Icon icon = OffsetIcon.getOriginalIcon((Icon)content2.getIcon());
                if (isSelected) {
                    this.setIcon(icon);
                } else {
                    this.setIcon((Icon)(icon != null ? new WatermarkIcon(icon, 0.5f) : null));
                }
            } else {
                this.setIcon(null);
            }
            this.myBold = false;
        }
    }

    public Content getContent() {
        return null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleBaseLabel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleBaseLabel
    extends JLabel.AccessibleJLabel {
        protected AccessibleBaseLabel() {
            super(BaseLabel.this);
        }
    }
}

