/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectsWelcomeScreenActionBase;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.util.IconUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewRecentProjectPanel
extends RecentProjectPanel {
    public NewRecentProjectPanel(@NotNull Disposable parentDisposable) {
        ListWithFilter panel2;
        if (parentDisposable == null) {
            NewRecentProjectPanel.$$$reportNull$$$0(0);
        }
        super(parentDisposable);
        this.setBorder(null);
        this.setBackground(FlatWelcomeFrame.getProjectsBackground());
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)this, JScrollPane.class);
        if (scrollPane != null) {
            scrollPane.setBackground(FlatWelcomeFrame.getProjectsBackground());
            JBDimension size = JBUI.size((int)300, (int)460);
            scrollPane.setSize((Dimension)size);
            scrollPane.setMinimumSize((Dimension)size);
            scrollPane.setPreferredSize((Dimension)size);
        }
        if ((panel2 = (ListWithFilter)UIUtil.findComponentOfType((JComponent)this, ListWithFilter.class)) != null) {
            panel2.setBackground(FlatWelcomeFrame.getProjectsBackground());
        }
    }

    @Override
    protected Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JList list2 = (JList)UIUtil.findComponentOfType((JComponent)this, JList.class);
        if (list2 != null) {
            list2.updateUI();
        }
    }

    @Override
    protected JBList createList(AnAction[] recentProjectActions, Dimension size) {
        final JBList list2 = super.createList(recentProjectActions, size);
        list2.setBackground(FlatWelcomeFrame.getProjectsBackground());
        list2.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object selected2 = list2.getSelectedValue();
                ProjectGroup group = selected2 instanceof ProjectGroupActionGroup ? ((ProjectGroupActionGroup)((Object)selected2)).getGroup() : null;
                int keyCode = e.getKeyCode();
                if (keyCode == 39) {
                    if (group != null) {
                        if (!group.isExpanded()) {
                            group.setExpanded(true);
                            ListModel model2 = ((NameFilteringListModel)list2.getModel()).getOriginalModel();
                            int index = list2.getSelectedIndex();
                            RecentProjectsWelcomeScreenActionBase.rebuildRecentProjectDataModel((DefaultListModel)model2);
                            list2.setSelectedIndex(group.getProjects().isEmpty() ? index : index + 1);
                        }
                    } else {
                        Component next;
                        FocusTraversalPolicy policy;
                        FlatWelcomeFrame frame = (FlatWelcomeFrame)ComponentUtil.getParentOfType(FlatWelcomeFrame.class, (Component)list2);
                        if (frame != null && (policy = frame.getFocusTraversalPolicy()) != null && (next = policy.getComponentAfter(frame, (Component)list2)) != null) {
                            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(next, true));
                        }
                    }
                } else if (keyCode == 37 && group != null && group.isExpanded()) {
                    group.setExpanded(false);
                    int index = list2.getSelectedIndex();
                    ListModel model3 = ((NameFilteringListModel)list2.getModel()).getOriginalModel();
                    RecentProjectsWelcomeScreenActionBase.rebuildRecentProjectDataModel((DefaultListModel)model3);
                    list2.setSelectedIndex(index);
                }
            }
        });
        list2.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group;
                int index = list2.locationToIndex(new Point(x, y));
                if (index != -1 && Arrays.binarySearch(list2.getSelectedIndices(), index) < 0) {
                    list2.setSelectedIndex(index);
                }
                if ((group = (ActionGroup)ActionManager.getInstance().getAction("WelcomeScreenRecentProjectActionGroup")) != null) {
                    ActionManager.getInstance().createActionPopupMenu("WelcomeScreen", group).getComponent().show(comp, x, y);
                }
            }
        });
        return list2;
    }

    @Override
    protected boolean isUseGroups() {
        return FlatWelcomeFrame.isUseProjectGroups();
    }

    @Override
    protected ListCellRenderer createRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
        return new RecentProjectPanel.RecentProjectItemRenderer(this.myPathShortener){
            private GridBagConstraints nameCell;
            private GridBagConstraints pathCell;
            private GridBagConstraints closeButtonCell;
            final JComponent spacer;
            {
                this.spacer = new NonOpaquePanel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(JBUIScale.scale((int)22), super.getPreferredSize().height);
                    }
                };
            }

            private void initConstraints() {
                this.nameCell = new GridBagConstraints();
                this.pathCell = new GridBagConstraints();
                this.closeButtonCell = new GridBagConstraints();
                this.nameCell.gridx = 0;
                this.nameCell.gridy = 0;
                this.nameCell.weightx = 1.0;
                this.nameCell.weighty = 1.0;
                this.nameCell.anchor = 23;
                this.nameCell.insets = JBUI.insets((int)6, (int)5, (int)1, (int)5);
                this.pathCell.gridx = 0;
                this.pathCell.gridy = 1;
                this.pathCell.insets = JBUI.insets((int)1, (int)5, (int)6, (int)5);
                this.pathCell.anchor = 25;
                this.closeButtonCell.gridx = 1;
                this.closeButtonCell.gridy = 0;
                this.closeButtonCell.anchor = 24;
                this.closeButtonCell.insets = JBUI.insets((int)7, (int)7, (int)7, (int)7);
                this.closeButtonCell.gridheight = 2;
            }

            @Override
            protected Color getListBackground(boolean isSelected, boolean hasFocus) {
                return isSelected ? FlatWelcomeFrame.getListSelectionColor(hasFocus) : FlatWelcomeFrame.getProjectsBackground();
            }

            @Override
            protected Color getListForeground(boolean isSelected, boolean hasFocus) {
                return UIUtil.getListForeground((isSelected && hasFocus ? 1 : 0) != 0);
            }

            @Override
            protected void layoutComponents() {
                this.setLayout(new GridBagLayout());
                this.initConstraints();
                this.add((Component)this.myName, this.nameCell);
                this.add((Component)this.myPath, this.pathCell);
            }

            @Override
            public Component getListCellRendererComponent(JList list2, final Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Color fore = this.getListForeground(isSelected, list2.hasFocus());
                final Color back = this.getListBackground(isSelected, list2.hasFocus());
                final JLabel name = new JLabel();
                final JLabel path = new JLabel();
                name.setForeground(fore);
                path.setForeground(isSelected ? fore : UIUtil.getInactiveTextColor());
                this.setBackground(back);
                return new JPanel(){
                    {
                        this.setLayout(new BorderLayout());
                        this.setBackground(back);
                        boolean isGroup = value instanceof ProjectGroupActionGroup;
                        boolean isInsideGroup = false;
                        if (value instanceof ReopenProjectAction) {
                            String path2 = ((ReopenProjectAction)((Object)value)).getProjectPath();
                            for (ProjectGroup group : RecentProjectsManager.getInstance().getGroups()) {
                                List projects = group.getProjects();
                                if (!projects.contains(path2)) continue;
                                isInsideGroup = true;
                                break;
                            }
                        }
                        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)7));
                        if (isInsideGroup) {
                            this.add((Component)spacer, "West");
                        }
                        if (isGroup) {
                            ProjectGroup group = ((ProjectGroupActionGroup)((Object)value)).getGroup();
                            name.setText(" " + group.getName());
                            name.setIcon(IconUtil.toSize((Icon)(group.isExpanded() ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon()), (int)JBUIScale.scale((int)16), (int)JBUIScale.scale((int)16)));
                            name.setFont(name.getFont().deriveFont(1));
                            this.add(name);
                        } else if (value instanceof ReopenProjectAction) {
                            NonOpaquePanel p = new NonOpaquePanel((LayoutManager)new BorderLayout());
                            name.setText(((ReopenProjectAction)((Object)value)).getProjectName());
                            String realPath = PathUtil.toSystemDependentName((String)((ReopenProjectAction)((Object)value)).getProjectPath());
                            int i = isInsideGroup ? 80 : 60;
                            path.setText(this.getTitle2Text((ReopenProjectAction)((Object)value), path, JBUIScale.scale((int)i)));
                            if (!realPath.equals(path.getText())) {
                                NewRecentProjectPanel.this.projectsWithLongPathes.add((ReopenProjectAction)((Object)value));
                            }
                            if (!NewRecentProjectPanel.this.isPathValid(((ReopenProjectAction)((Object)value)).getProjectPath())) {
                                path.setForeground(ColorUtil.mix((Color)path.getForeground(), (Color)JBColor.red, (double)0.5));
                            }
                            p.add((Component)name, (Object)"North");
                            p.add((Component)path, (Object)"South");
                            p.setBorder((Border)JBUI.Borders.emptyRight((int)30));
                            String projectPath = ((ReopenProjectAction)((Object)value)).getProjectPath();
                            RecentProjectsManagerBase recentProjectsManage = RecentProjectsManagerBase.getInstanceEx();
                            Icon icon = recentProjectsManage.getProjectIcon(projectPath, UIUtil.isUnderDarcula());
                            if (icon == null && UIUtil.isUnderDarcula()) {
                                icon = recentProjectsManage.getProjectIcon(projectPath, false);
                            }
                            if (icon == null) {
                                icon = EmptyIcon.ICON_16;
                            }
                            JLabel projectIcon = new JLabel("", icon, 2){

                                @Override
                                protected void paintComponent(Graphics g) {
                                    this.getIcon().paintIcon(this, g, 0, (this.getHeight() - this.getIcon().getIconHeight()) / 2);
                                }
                            };
                            projectIcon.setBorder((Border)JBUI.Borders.emptyRight((int)8));
                            projectIcon.setVerticalAlignment(0);
                            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
                            panel2.add((Component)p);
                            panel2.add((Component)projectIcon, (Object)"West");
                            this.add((Component)panel2);
                        }
                        AccessibleContextUtil.setCombinedName((Component)this, (Component)name, (String)" - ", (Component)path);
                        AccessibleContextUtil.setCombinedDescription((Component)this, (Component)name, (String)" - ", (Component)path);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, JBUIScale.scale((int)44));
                    }
                };
            }
        };
    }

    @Override
    @Nullable
    protected JPanel createTitle() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/welcomeScreen/NewRecentProjectPanel", "<init>"));
    }
}

