/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShredImpl
implements PsiLanguageInjectionHost.Shred {
    private final SmartPsiFileRange relevantRangeInHost;
    private final SmartPsiElementPointer<PsiLanguageInjectionHost> hostElementPointer;
    private final TextRange rangeInDecodedPSI;
    private final String prefix;
    private final String suffix;
    private final boolean usePsiRange;
    private final boolean isOneLine;

    ShredImpl(@NotNull SmartPsiFileRange relevantRangeInHost, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> hostElementPointer, @NotNull String prefix, @NotNull String suffix, @NotNull TextRange rangeInDecodedPSI, boolean usePsiRange, boolean isOneLine) {
        if (relevantRangeInHost == null) {
            ShredImpl.$$$reportNull$$$0(0);
        }
        if (hostElementPointer == null) {
            ShredImpl.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            ShredImpl.$$$reportNull$$$0(2);
        }
        if (suffix == null) {
            ShredImpl.$$$reportNull$$$0(3);
        }
        if (rangeInDecodedPSI == null) {
            ShredImpl.$$$reportNull$$$0(4);
        }
        this.hostElementPointer = hostElementPointer;
        this.relevantRangeInHost = relevantRangeInHost;
        this.prefix = prefix;
        this.suffix = suffix;
        this.rangeInDecodedPSI = rangeInDecodedPSI;
        this.usePsiRange = usePsiRange;
        this.isOneLine = isOneLine;
        this.assertValid();
    }

    private void assertValid() {
        Segment hostRange = this.relevantRangeInHost.getPsiRange();
        assert (hostRange != null) : "invalid host range: " + this.relevantRangeInHost;
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)this.hostElementPointer.getElement();
        assert (host != null && host.isValid()) : "no host: " + this.hostElementPointer;
    }

    @NotNull
    ShredImpl withPsiRange() {
        ShredImpl shredImpl = new ShredImpl(this.relevantRangeInHost, this.hostElementPointer, this.prefix, this.suffix, this.rangeInDecodedPSI, true, this.isOneLine);
        if (shredImpl == null) {
            ShredImpl.$$$reportNull$$$0(5);
        }
        return shredImpl;
    }

    @NotNull
    ShredImpl withRange(@NotNull TextRange rangeInDecodedPSI, @NotNull TextRange rangeInHostElementPSI, @NotNull PsiLanguageInjectionHost newHost) {
        if (rangeInDecodedPSI == null) {
            ShredImpl.$$$reportNull$$$0(6);
        }
        if (rangeInHostElementPSI == null) {
            ShredImpl.$$$reportNull$$$0(7);
        }
        if (newHost == null) {
            ShredImpl.$$$reportNull$$$0(8);
        }
        SmartPsiFileRange rangeMarker = this.relevantRangeInHost;
        TextRange oldRangeInHostElementPSI = this.calcRangeInsideHostElement(false);
        SmartPointerManagerImpl pointerManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)rangeMarker.getProject());
        SmartPsiElementPointer<PsiLanguageInjectionHost> newHostPointer = pointerManager.createSmartPsiElementPointer(newHost, newHost.getContainingFile(), true);
        if (!rangeInHostElementPSI.equals((Object)TextRange.create((Segment)oldRangeInHostElementPSI))) {
            Segment hostElementRange = newHostPointer.getRange();
            rangeMarker = pointerManager.createSmartPsiFileRangePointer(rangeMarker.getContainingFile(), rangeInHostElementPSI.shiftRight(hostElementRange.getStartOffset()), true);
        }
        ShredImpl shredImpl = new ShredImpl(rangeMarker, newHostPointer, this.prefix, this.suffix, rangeInDecodedPSI, this.usePsiRange, this.isOneLine);
        if (shredImpl == null) {
            ShredImpl.$$$reportNull$$$0(9);
        }
        return shredImpl;
    }

    @NotNull
    SmartPsiElementPointer<PsiLanguageInjectionHost> getSmartPointer() {
        SmartPsiElementPointer<PsiLanguageInjectionHost> smartPsiElementPointer = this.hostElementPointer;
        if (smartPsiElementPointer == null) {
            ShredImpl.$$$reportNull$$$0(10);
        }
        return smartPsiElementPointer;
    }

    @Nullable(value="returns null when the host document marker is invalid")
    public Segment getHostRangeMarker() {
        return this.usePsiRange ? this.relevantRangeInHost.getPsiRange() : this.relevantRangeInHost.getRange();
    }

    @NotNull
    public TextRange getRangeInsideHost() {
        TextRange textRange = this.calcRangeInsideHostElement(true);
        if (textRange == null) {
            ShredImpl.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    @NotNull
    private TextRange calcRangeInsideHostElement(boolean usePsiRange) {
        TextRange textRange;
        PsiLanguageInjectionHost host = this.getHost();
        Segment psiRange = usePsiRange ? this.relevantRangeInHost.getPsiRange() : this.relevantRangeInHost.getRange();
        TextRange textRange2 = textRange = psiRange == null ? null : TextRange.create((Segment)psiRange);
        if (host == null) {
            Segment fromSP;
            if (textRange != null) {
                TextRange textRange3 = textRange;
                if (textRange3 == null) {
                    ShredImpl.$$$reportNull$$$0(12);
                }
                return textRange3;
            }
            Segment segment = fromSP = usePsiRange ? this.hostElementPointer.getPsiRange() : this.hostElementPointer.getRange();
            if (fromSP != null) {
                TextRange textRange4 = TextRange.create((Segment)fromSP);
                if (textRange4 == null) {
                    ShredImpl.$$$reportNull$$$0(13);
                }
                return textRange4;
            }
            TextRange textRange5 = new TextRange(0, 0);
            if (textRange5 == null) {
                ShredImpl.$$$reportNull$$$0(14);
            }
            return textRange5;
        }
        TextRange hostTextRange = host.getTextRange();
        TextRange textRange6 = textRange = textRange == null ? null : textRange.intersection(hostTextRange);
        if (textRange == null) {
            ProperTextRange properTextRange = new ProperTextRange(0, hostTextRange.getLength());
            if (properTextRange == null) {
                ShredImpl.$$$reportNull$$$0(15);
            }
            return properTextRange;
        }
        TextRange textRange7 = textRange.shiftLeft(hostTextRange.getStartOffset());
        if (textRange7 == null) {
            ShredImpl.$$$reportNull$$$0(16);
        }
        return textRange7;
    }

    public String toString() {
        PsiLanguageInjectionHost host = this.getHost();
        Segment hostRange = this.getHostRangeMarker();
        return "Shred " + (host == null ? null : host.getTextRange()) + ": " + host + " In host range: " + (hostRange != null ? "(" + hostRange.getStartOffset() + "," + hostRange.getEndOffset() + ");" : "invalid;") + " PSI range: " + this.rangeInDecodedPSI;
    }

    public boolean isValid() {
        return this.getHostRangeMarker() != null && this.getHost() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)o;
        PsiLanguageInjectionHost host = this.getHost();
        Segment hostRangeMarker = this.getHostRangeMarker();
        Segment hostRangeMarker2 = shred.getHostRangeMarker();
        return host != null && host.equals(shred.getHost()) && this.prefix.equals(shred.getPrefix()) && this.suffix.equals(shred.getSuffix()) && this.rangeInDecodedPSI.equals((Object)shred.getRange()) && hostRangeMarker != null && hostRangeMarker2 != null && TextRange.areSegmentsEqual((Segment)hostRangeMarker, (Segment)hostRangeMarker2);
    }

    public int hashCode() {
        return this.rangeInDecodedPSI.hashCode();
    }

    public void dispose() {
    }

    @Nullable
    public PsiLanguageInjectionHost getHost() {
        return (PsiLanguageInjectionHost)this.hostElementPointer.getElement();
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.rangeInDecodedPSI;
        if (textRange == null) {
            ShredImpl.$$$reportNull$$$0(17);
        }
        return textRange;
    }

    @NotNull
    public String getPrefix() {
        String string = this.prefix;
        if (string == null) {
            ShredImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public String getSuffix() {
        String string = this.suffix;
        if (string == null) {
            ShredImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    boolean isOneLine() {
        return this.isOneLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relevantRangeInHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostElementPointer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInDecodedPSI";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/ShredImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInHostElementPSI";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/ShredImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withPsiRange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withRange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmartPointer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInsideHost";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRangeInsideHostElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

