/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ext.SshCredentialsHandler;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import com.intellij.remote.ext.UnknownTypeRemoteCredentialHandler;
import com.intellij.remote.ext.VagrantCredentialsHandler;
import com.intellij.remote.ext.WebDeploymentCredentialsHandler;
import org.jetbrains.annotations.Nls;

public abstract class CredentialsType<T> {
    public static final String VAGRANT_PREFIX = "vagrant://";
    public static final String SFTP_DEPLOYMENT_PREFIX = "sftp://";
    public static final Key<VagrantBasedCredentialsHolder> VAGRANT_BASED_CREDENTIALS = Key.create((String)"VAGRANT_BASED_CREDENTIALS");
    public static final Key<WebDeploymentCredentialsHolder> WEB_DEPLOYMENT_BASED_CREDENTIALS = Key.create((String)"WEB_DEPLOYMENT_BASED_CREDENTIALS");
    public static final Key<RemoteCredentialsHolder> PLAIN_SSH_CREDENTIALS = Key.create((String)"PLAIN_SSH_CREDENTIALS");
    public static final Key<UnknownCredentialsHolder> UNKNOWN_CREDENTIALS = Key.create((String)"UNKNOWN_CREDENTIALS");
    public static final CredentialsType<RemoteCredentialsHolder> SSH_HOST = new CredentialsType<RemoteCredentialsHolder>("SSH Credentials", "ssh://"){

        @Override
        public Key<RemoteCredentialsHolder> getCredentialsKey() {
            return PLAIN_SSH_CREDENTIALS;
        }

        @Override
        public RemoteCredentialsHandler getHandler(RemoteCredentialsHolder credentials) {
            return new SshCredentialsHandler(credentials);
        }

        @Override
        public RemoteCredentialsHolder createCredentials() {
            return new RemoteCredentialsHolder();
        }
    };
    public static final CredentialsType<VagrantBasedCredentialsHolder> VAGRANT = new CredentialsType<VagrantBasedCredentialsHolder>("Vagrant", "vagrant://"){

        @Override
        public Key<VagrantBasedCredentialsHolder> getCredentialsKey() {
            return VAGRANT_BASED_CREDENTIALS;
        }

        @Override
        public RemoteCredentialsHandler getHandler(VagrantBasedCredentialsHolder credentials) {
            return new VagrantCredentialsHandler(credentials);
        }

        @Override
        public VagrantBasedCredentialsHolder createCredentials() {
            return new VagrantBasedCredentialsHolder();
        }
    };
    public static final CredentialsType<WebDeploymentCredentialsHolder> WEB_DEPLOYMENT = new CredentialsType<WebDeploymentCredentialsHolder>("Web Deployment", "sftp://"){

        @Override
        public Key<WebDeploymentCredentialsHolder> getCredentialsKey() {
            return WEB_DEPLOYMENT_BASED_CREDENTIALS;
        }

        @Override
        public RemoteCredentialsHandler getHandler(WebDeploymentCredentialsHolder credentials) {
            return new WebDeploymentCredentialsHandler(credentials);
        }

        @Override
        public WebDeploymentCredentialsHolder createCredentials() {
            return new WebDeploymentCredentialsHolder();
        }
    };
    public static final CredentialsType<UnknownCredentialsHolder> UNKNOWN = new CredentialsType<UnknownCredentialsHolder>("Unknown", ""){

        @Override
        public Key<UnknownCredentialsHolder> getCredentialsKey() {
            return UNKNOWN_CREDENTIALS;
        }

        @Override
        public RemoteCredentialsHandler getHandler(UnknownCredentialsHolder credentials) {
            return new UnknownTypeRemoteCredentialHandler(credentials);
        }

        @Override
        public UnknownCredentialsHolder createCredentials() {
            return new UnknownCredentialsHolder();
        }
    };
    private final String myName;
    private final String myPrefix;

    protected CredentialsType(@Nls(capitalization=Nls.Capitalization.Title) String name, String prefix) {
        this.myName = name;
        this.myPrefix = prefix;
    }

    public String getName() {
        return this.myName;
    }

    public T getCredentials(UserDataHolderBase dataHolder) {
        return (T)dataHolder.getUserData(this.getCredentialsKey());
    }

    public void putCredentials(UserDataHolderBase dataHolder, T credentials) {
        dataHolder.putUserData(this.getCredentialsKey(), credentials);
    }

    public abstract Key<T> getCredentialsKey();

    public abstract RemoteCredentialsHandler getHandler(T var1);

    public boolean hasPrefix(String path) {
        return path.startsWith(this.myPrefix);
    }

    public abstract T createCredentials();

    public void saveCredentials(RemoteSdkAdditionalData data, CredentialsCase ... cases) {
        for (CredentialsCase credentialsCase : cases) {
            if (credentialsCase.getType() != this) continue;
            T credentials = this.createCredentials();
            credentialsCase.process(credentials);
            data.setCredentials(this.getCredentialsKey(), credentials);
        }
    }
}

