/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TreeAction
extends AbstractAction
implements UIResource {
    private static final List<TreeAction> ACTIONS = Arrays.asList(new TreeAction("selectFirst", new KeyStroke[]{KeyStroke.getKeyStroke(36, 0)}){

        @Override
        void actionPerformed(@NotNull JTree tree, @Nullable TreePath path) {
            if (tree == null) {
                1.$$$reportNull$$$0(0);
            }
            1.scrollAndSetSelection(tree, 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/tree/ui/TreeAction$1", "actionPerformed"));
        }
    }, new TreeAction("selectLast", new KeyStroke[]{KeyStroke.getKeyStroke(35, 0)}){

        @Override
        void actionPerformed(@NotNull JTree tree, @Nullable TreePath path) {
            if (tree == null) {
                2.$$$reportNull$$$0(0);
            }
            2.scrollAndSetSelection(tree, tree.getRowCount() - 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/tree/ui/TreeAction$2", "actionPerformed"));
        }
    }, new TreeAction("selectPrevious", new KeyStroke[]{KeyStroke.getKeyStroke(38, 0), KeyStroke.getKeyStroke(224, 0)}){

        @Override
        void actionPerformed(@NotNull JTree tree, @Nullable TreePath path) {
            if (tree == null) {
                3.$$$reportNull$$$0(0);
            }
            int row = tree.getRowForPath(path);
            if (path == null || row < 0) {
                3.scrollAndSetSelection(tree, 0);
            } else {
                if (row == 0 && 3.isCycleScrollingAllowed()) {
                    row = tree.getRowCount();
                }
                3.scrollAndSetSelection(tree, --row);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/tree/ui/TreeAction$3", "actionPerformed"));
        }
    }, new TreeAction("selectNext", new KeyStroke[]{KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(225, 0)}){

        @Override
        void actionPerformed(@NotNull JTree tree, @Nullable TreePath path) {
            if (tree == null) {
                4.$$$reportNull$$$0(0);
            }
            int row = tree.getRowForPath(path);
            if (path == null || row < 0) {
                4.scrollAndSetSelection(tree, 0);
            } else {
                if (4.isCycleScrollingAllowed() && ++row == tree.getRowCount()) {
                    row = 0;
                }
                4.scrollAndSetSelection(tree, row);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/tree/ui/TreeAction$4", "actionPerformed"));
        }
    }, new TreeAction("selectParent", new KeyStroke[]{KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(226, 0)}){

        @Override
        void actionPerformed(@NotNull JTree tree, @Nullable TreePath path) {
            if (tree == null) {
                5.$$$reportNull$$$0(0);
            }
            int row = tree.getRowForPath(path);
            if (path == null || row < 0) {
                5.scrollAndSetSelection(tree, 0);
            } else if (tree.isExpanded(path)) {
                tree.collapsePath(path);
            } else {
                TreePath parent = path.getParentPath();
                if (parent != null) {
                    if (tree.isRootVisible() || null != parent.getParentPath()) {
                        5.scrollAndSetSelection(tree, parent);
                    } else if (row > 0) {
                        5.scrollAndSetSelection(tree, row - 1);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/tree/ui/TreeAction$5", "actionPerformed"));
        }
    }, new TreeAction("selectChild", new KeyStroke[]{KeyStroke.getKeyStroke(39, 0), KeyStroke.getKeyStroke(227, 0)}){

        @Override
        void actionPerformed(@NotNull JTree tree, @Nullable TreePath path) {
            if (tree == null) {
                6.$$$reportNull$$$0(0);
            }
            int row = tree.getRowForPath(path);
            if (path == null || row < 0) {
                6.scrollAndSetSelection(tree, 0);
            } else if (tree.isExpanded(path) || tree.getModel().isLeaf(path.getLastPathComponent())) {
                6.scrollAndSetSelection(tree, row + 1);
            } else {
                tree.expandPath(path);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/tree/ui/TreeAction$6", "actionPerformed"));
        }
    }, new TreeAction("scrollUpChangeSelection", new KeyStroke[]{KeyStroke.getKeyStroke(33, 0)}){

        @Override
        void actionPerformed(@NotNull JTree tree, @Nullable TreePath path) {
            if (tree == null) {
                7.$$$reportNull$$$0(0);
            }
            Rectangle bounds2 = tree.getPathBounds(path);
            if (path == null || bounds2 == null) {
                7.scrollAndSetSelection(tree, 0);
            } else {
                int height = Math.max(tree.getVisibleRect().height - bounds2.height, 1);
                TreePath next = tree.getClosestPathForLocation(bounds2.x, bounds2.y - height);
                if (next != null && !next.equals(path)) {
                    7.scrollAndSetSelection(tree, next);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/tree/ui/TreeAction$7", "actionPerformed"));
        }
    }, new TreeAction("scrollDownChangeSelection", new KeyStroke[]{KeyStroke.getKeyStroke(34, 0)}){

        @Override
        void actionPerformed(@NotNull JTree tree, @Nullable TreePath path) {
            if (tree == null) {
                8.$$$reportNull$$$0(0);
            }
            Rectangle bounds2 = tree.getPathBounds(path);
            if (path == null || bounds2 == null) {
                8.scrollAndSetSelection(tree, tree.getRowCount() - 1);
            } else {
                int height = Math.max(tree.getVisibleRect().height - bounds2.height, 1);
                TreePath next = tree.getClosestPathForLocation(bounds2.x, bounds2.y + bounds2.height + height);
                if (next != null && !next.equals(path)) {
                    8.scrollAndSetSelection(tree, next);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/tree/ui/TreeAction$8", "actionPerformed"));
        }
    });
    private final String name;
    private final List<KeyStroke> keys;

    TreeAction(@NotNull String name, KeyStroke ... keys) {
        if (name == null) {
            TreeAction.$$$reportNull$$$0(0);
        }
        if (keys == null) {
            TreeAction.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.keys = Arrays.asList(keys);
    }

    abstract void actionPerformed(@NotNull JTree var1, @Nullable TreePath var2);

    @Override
    public final void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source instanceof JTree) {
            JTree tree = (JTree)source;
            this.actionPerformed(tree, tree.getLeadSelectionPath());
        }
    }

    static void installTo(@NotNull ActionMap map2) {
        Object[] keys;
        if (map2 == null) {
            TreeAction.$$$reportNull$$$0(2);
        }
        if ((keys = map2.keys()) != null && keys.length != 0) {
            return;
        }
        for (TreeAction action2 : ACTIONS) {
            map2.put(action2.name, action2);
        }
    }

    static void installTo(@NotNull InputMap map2) {
        KeyStroke[] keys;
        if (map2 == null) {
            TreeAction.$$$reportNull$$$0(3);
        }
        if ((keys = map2.keys()) != null && keys.length != 0) {
            return;
        }
        for (TreeAction action2 : ACTIONS) {
            for (KeyStroke key : action2.keys) {
                map2.put(key, action2.name);
            }
        }
    }

    static void scrollAndSetSelection(@NotNull JTree tree, int row) {
        if (tree == null) {
            TreeAction.$$$reportNull$$$0(4);
        }
        TreeAction.scrollAndSetSelection(tree, tree.getPathForRow(row));
    }

    static void scrollAndSetSelection(@NotNull JTree tree, @Nullable TreePath path) {
        if (tree == null) {
            TreeAction.$$$reportNull$$$0(5);
        }
        if (path != null && TreeUtil.scrollToVisible((JTree)tree, (TreePath)path, (boolean)false)) {
            tree.setSelectionPath(path);
        }
    }

    static boolean isCycleScrollingAllowed() {
        if (!Registry.is((String)"ide.tree.ui.cyclic.scrolling.allowed")) {
            return false;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        return settings != null && settings.getCycleScrolling();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/ui/TreeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installTo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollAndSetSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

