/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.Consumer;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldCompletionProvider
implements TextCompletionProvider {
    protected boolean myCaseInsensitivity;

    protected TextFieldCompletionProvider() {
        this(false);
    }

    protected TextFieldCompletionProvider(boolean caseInsensitivity) {
        this.myCaseInsensitivity = caseInsensitivity;
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text2, int offset) {
        if (text2 == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(0);
        }
        return this.getPrefix(text2.substring(0, offset));
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        CompletionResultSet activeResult;
        if (result2 == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!(activeResult = result2).getPrefixMatcher().getPrefix().equals(prefix)) {
            activeResult = activeResult.withPrefixMatcher(prefix);
        }
        if (this.isCaseInsensitivity()) {
            activeResult = activeResult.caseInsensitive();
        }
        CompletionResultSet completionResultSet = activeResult;
        if (completionResultSet == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(3);
        }
        return completionResultSet;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c2) {
        return null;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(6);
        }
        this.addCompletionVariants(parameters.getOriginalFile().getText(), parameters.getOffset(), prefix, result2);
        result2.stopHere();
    }

    public void apply(@NotNull EditorTextField field, @NotNull String text2) {
        Project project;
        if (field == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(8);
        }
        if ((project = field.getProject()) != null) {
            field.setDocument(this.createDocument(project, text2));
        }
    }

    public void apply(@NotNull EditorTextField field) {
        if (field == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(9);
        }
        this.apply(field, "");
    }

    private Document createDocument(Project project, @NotNull String text2) {
        if (text2 == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(10);
        }
        return LanguageTextField.createDocument(text2, PlainTextLanguage.INSTANCE, project, new TextCompletionUtil.DocumentWithCompletionCreator(this, true));
    }

    public boolean isCaseInsensitivity() {
        return this.myCaseInsensitivity;
    }

    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        if (currentTextPrefix == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(11);
        }
        String string = currentTextPrefix;
        if (string == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        return null;
    }

    protected abstract void addCompletionVariants(@NotNull String var1, int var2, @NotNull String var3, @NotNull CompletionResultSet var4);

    @NotNull
    public EditorTextField createEditor(Project project) {
        EditorTextField editorTextField = this.createEditor(project, true, null);
        if (editorTextField == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(13);
        }
        return editorTextField;
    }

    @NotNull
    public EditorTextField createEditor(Project project, final boolean shouldHaveBorder, final @Nullable Consumer<Editor> editorConstructionCallback) {
        EditorTextField editorTextField = new EditorTextField(this.createDocument(project, ""), project, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType()){

            @Override
            protected boolean shouldHaveBorder() {
                return shouldHaveBorder;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (shouldHaveBorder) {
                    super.updateBorder(editor);
                } else {
                    editor.setBorder(null);
                }
            }

            @Override
            protected EditorEx createEditor() {
                EditorEx result2 = super.createEditor();
                if (editorConstructionCallback != null) {
                    editorConstructionCallback.consume((Object)result2);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/util/TextFieldCompletionProvider$1", "updateBorder"));
            }
        };
        if (editorTextField == null) {
            TextFieldCompletionProvider.$$$reportNull$$$0(14);
        }
        return editorTextField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/TextFieldCompletionProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTextPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/TextFieldCompletionProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPrefixMatcher";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyPrefixMatcher";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

