/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.ByteSequenceDataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedMapForwardIndex
implements ForwardIndex {
    private static final Logger LOG = Logger.getInstance(SharedMapForwardIndex.class);
    private final ID<?, ?> myIndexId;
    @Nullable
    private final PersistentMapBasedForwardIndex mySanityVerificationIndex;
    @Nullable
    private final AbstractForwardIndexAccessor<?, ?, ?> myAccessor;

    public SharedMapForwardIndex(@NotNull IndexExtension<?, ?, ?> extension, @Nullable AbstractForwardIndexAccessor<?, ?, ?> accessor, @Nullable File verificationIndexStorageFile, boolean verificationIndexHasChunks) throws IOException {
        if (extension == null) {
            SharedMapForwardIndex.$$$reportNull$$$0(0);
        }
        this.myIndexId = (ID)extension.getName();
        if (verificationIndexStorageFile != null && (!SharedIndicesData.ourFileSharedIndicesEnabled || SharedIndicesData.DO_CHECKS)) {
            Boolean old = (Boolean)PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.get();
            try {
                PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(!verificationIndexHasChunks);
                this.mySanityVerificationIndex = new PersistentMapBasedForwardIndex(verificationIndexStorageFile);
            }
            catch (IOException e) {
                IOUtil.deleteAllFilesStartingWith((File)verificationIndexStorageFile);
                throw e;
            }
            finally {
                PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(old);
            }
        } else {
            this.mySanityVerificationIndex = null;
        }
        this.myAccessor = accessor;
    }

    @Nullable
    public ByteArraySequence get(@NotNull Integer inputId) throws IOException {
        ByteArraySequence verificationData;
        if (inputId == null) {
            SharedMapForwardIndex.$$$reportNull$$$0(1);
        }
        if (!SharedIndicesData.ourFileSharedIndicesEnabled) {
            assert (this.mySanityVerificationIndex != null);
            return this.mySanityVerificationIndex.get(inputId);
        }
        ByteArraySequence data = (ByteArraySequence)SharedIndicesData.recallFileData(inputId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
        if (this.mySanityVerificationIndex != null && !Comparing.equal((Object)(verificationData = this.mySanityVerificationIndex.get(inputId)), (Object)data)) {
            if (verificationData != null) {
                SharedIndicesData.associateFileData(inputId, this.myIndexId, verificationData, ByteSequenceDataExternalizer.INSTANCE);
                if (data != null) {
                    LOG.error("Unexpected indexing diff with hash id " + this.myIndexId + ", file:" + IndexInfrastructure.findFileById(PersistentFS.getInstance(), inputId) + "," + this.deserializeOrRawString(verificationData) + "," + this.deserializeOrRawString(data));
                }
            }
            data = verificationData;
        }
        return data;
    }

    public void put(@NotNull Integer inputId, @Nullable ByteArraySequence value) throws IOException {
        if (inputId == null) {
            SharedMapForwardIndex.$$$reportNull$$$0(2);
        }
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            SharedIndicesData.associateFileData(inputId, this.myIndexId, value, ByteSequenceDataExternalizer.INSTANCE);
        }
        if (this.mySanityVerificationIndex != null) {
            this.mySanityVerificationIndex.put(inputId, value);
        }
    }

    public void force() {
        if (this.mySanityVerificationIndex != null) {
            this.mySanityVerificationIndex.force();
        }
    }

    public void clear() throws IOException {
        if (this.mySanityVerificationIndex != null) {
            this.mySanityVerificationIndex.clear();
        }
    }

    public void close() throws IOException {
        if (this.mySanityVerificationIndex != null) {
            this.mySanityVerificationIndex.close();
        }
    }

    private Object deserializeOrRawString(ByteArraySequence seq) throws IOException {
        if (this.myAccessor != null) {
            return this.myAccessor.deserializeData(seq);
        }
        if (seq == null) {
            return null;
        }
        return Arrays.toString(seq.getBytes());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/SharedMapForwardIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

