/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.sh.shellcheck.ShShellcheckExternalAnnotator;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.IncorrectOperationException;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class QuickFixIntention
implements IntentionAction {
    private static final String FEATURE_ACTION_ID = "QuickFixUsed";
    private final ShShellcheckExternalAnnotator.Fix fix;
    private final long timestamp;
    private final String message;

    public QuickFixIntention(String message, ShShellcheckExternalAnnotator.Fix fix, long timestamp) {
        this.timestamp = timestamp;
        this.message = message;
        this.fix = fix;
    }

    @NotNull
    public String getFamilyName() {
        if ("Shell script" == null) {
            QuickFixIntention.$$$reportNull$$$0(0);
        }
        return "Shell script";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            QuickFixIntention.$$$reportNull$$$0(1);
        }
        return this.timestamp == file.getModificationStamp();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        String string = this.message;
        if (string == null) {
            QuickFixIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        class Replacement {
            final String replacement;
            final int startOffset;
            final int endOffset;

            Replacement(int startOffset, int endOffset, String replacement) {
                this.replacement = replacement;
                this.startOffset = startOffset;
                this.endOffset = endOffset;
            }
        }
        if (project == null) {
            QuickFixIntention.$$$reportNull$$$0(3);
        }
        Document document = editor.getDocument();
        Stream.of(this.fix.replacements).map(it -> {
            int startOffset = QuickFixIntention.calcOffset(document, it.line, it.column);
            int endOffset = QuickFixIntention.calcOffset(document, it.endLine, it.endColumn);
            return new Replacement(startOffset, endOffset, it.replacement);
        }).sorted(Comparator.comparingInt(it -> -it.endOffset)).forEach(it -> document.replaceString(it.startOffset, it.endOffset, (CharSequence)it.replacement));
        ShFeatureUsagesCollector.logFeatureUsage(FEATURE_ACTION_ID);
    }

    private static int calcOffset(Document document, int line, int column) {
        return ShShellcheckUtil.calcOffset(document.getCharsSequence(), document.getLineStartOffset(line - 1), column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/shellcheck/QuickFixIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/shellcheck/QuickFixIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

