/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BatchConsumer;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionService {
    public static final Key<CompletionStatistician> STATISTICS_KEY = Key.create((String)"completion");
    public static final Key<CompletionWeigher> RELEVANCE_KEY = Key.create((String)"completion");

    public static CompletionService getCompletionService() {
        return ServiceManager.getService(CompletionService.class);
    }

    @Deprecated
    public abstract void setAdvertisementText(@Nullable String var1);

    public void getVariantsFromContributors(CompletionParameters parameters, @Nullable CompletionContributor from, Consumer<? super CompletionResult> consumer) {
        this.getVariantsFromContributors(parameters, from, this.createMatcher(this.suggestPrefix(parameters), false), consumer);
    }

    protected void getVariantsFromContributors(CompletionParameters parameters, @Nullable CompletionContributor from, PrefixMatcher matcher, Consumer<? super CompletionResult> consumer) {
        List<CompletionContributor> contributors = CompletionContributor.forParameters(parameters);
        for (int i = contributors.indexOf(from) + 1; i < contributors.size(); ++i) {
            ProgressManager.checkCanceled();
            CompletionContributor contributor = contributors.get(i);
            CompletionResultSet result = this.createResultSet(parameters, consumer, contributor, matcher);
            contributor.fillCompletionVariants(parameters, result);
            if (!result.isStopped()) continue;
            return;
        }
    }

    protected abstract CompletionResultSet createResultSet(CompletionParameters var1, Consumer<? super CompletionResult> var2, @NotNull CompletionContributor var3, PrefixMatcher var4);

    protected abstract String suggestPrefix(CompletionParameters var1);

    @NotNull
    protected abstract PrefixMatcher createMatcher(String var1, boolean var2);

    @Nullable
    public abstract CompletionProcess getCurrentCompletion();

    public void performCompletion(CompletionParameters parameters, final Consumer<? super CompletionResult> consumer) {
        final Set lookupSet = ContainerUtil.newConcurrentSet();
        final AtomicBoolean typoTolerant = new AtomicBoolean();
        BatchConsumer<CompletionResult> batchConsumer = new BatchConsumer<CompletionResult>(){

            @Override
            public void startBatch() {
                if (consumer instanceof BatchConsumer) {
                    ((BatchConsumer)consumer).startBatch();
                }
            }

            @Override
            public void endBatch() {
                if (consumer instanceof BatchConsumer) {
                    ((BatchConsumer)consumer).endBatch();
                }
            }

            public void consume(CompletionResult result) {
                if (typoTolerant.get() && result.getLookupElement().getAutoCompletionPolicy() != AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                    result = result.withLookupElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(result.getLookupElement()));
                }
                if (lookupSet.add(result.getLookupElement())) {
                    consumer.consume((Object)result);
                }
            }
        };
        String prefix = this.suggestPrefix(parameters);
        this.getVariantsFromContributors(parameters, null, this.createMatcher(prefix, false), (Consumer<? super CompletionResult>)batchConsumer);
        if (lookupSet.isEmpty() && prefix.length() > 2) {
            typoTolerant.set(true);
            this.getVariantsFromContributors(parameters, null, this.createMatcher(prefix, true), (Consumer<? super CompletionResult>)batchConsumer);
        }
    }

    public abstract CompletionSorter defaultSorter(CompletionParameters var1, PrefixMatcher var2);

    public abstract CompletionSorter emptySorter();
}

