/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class CloseAction
extends AnAction
implements DumbAware {
    private RunContentDescriptor myContentDescriptor;
    private final Project myProject;
    private Executor myExecutor;

    public CloseAction(Executor executor, RunContentDescriptor contentDescriptor, Project project) {
        this.myExecutor = executor;
        this.myContentDescriptor = contentDescriptor;
        this.myProject = project;
        ActionUtil.copyFrom(this, "CloseContent");
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setIcon(AllIcons.Actions.Cancel);
        templatePresentation.setText(ExecutionBundle.message("close.tab.action.name", new Object[0]));
        templatePresentation.setDescription(null);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloseAction.$$$reportNull$$$0(0);
        }
        this.perform();
    }

    public void perform() {
        RunContentDescriptor contentDescriptor = this.getContentDescriptor();
        if (contentDescriptor == null) {
            return;
        }
        boolean removedOk = ExecutionManager.getInstance(this.myProject).getContentManager().removeRunContent(this.getExecutor(), contentDescriptor);
        if (removedOk) {
            this.myContentDescriptor = null;
            this.myExecutor = null;
        }
    }

    public RunContentDescriptor getContentDescriptor() {
        return this.myContentDescriptor;
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CloseAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.myContentDescriptor != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/execution/ui/actions/CloseAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

