/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.firefox;

import com.intellij.ide.browsers.firefox.FirefoxProfile;
import com.intellij.ide.browsers.firefox.FirefoxSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirefoxUtil {
    private static final Logger LOG = Logger.getInstance(FirefoxUtil.class);
    @NonNls
    public static final String PROFILES_INI_FILE = "profiles.ini";

    private FirefoxUtil() {
    }

    @Nullable
    public static File getDefaultProfileIniPath() {
        File[] roots;
        for (File profilesDir : roots = FirefoxUtil.getProfilesDirs()) {
            File profilesFile = new File(profilesDir, PROFILES_INI_FILE);
            if (!profilesFile.isFile()) continue;
            return profilesFile;
        }
        return null;
    }

    @Nullable
    public static File getFirefoxExtensionsDir(FirefoxSettings settings) {
        File profilesFile = settings.getProfilesIniFile();
        if (profilesFile != null && profilesFile.exists()) {
            File profileDir;
            List<FirefoxProfile> profiles = FirefoxUtil.computeProfiles(profilesFile);
            FirefoxProfile profile = FirefoxUtil.findProfileByNameOrDefault(settings.getProfile(), profiles);
            if (profile != null && (profileDir = profile.getProfileDirectory(profilesFile)).isDirectory()) {
                return new File(profileDir, "extensions");
            }
        }
        return null;
    }

    @Nullable
    public static FirefoxProfile findProfileByNameOrDefault(@Nullable String name, @NotNull List<? extends FirefoxProfile> profiles) {
        if (profiles == null) {
            FirefoxUtil.$$$reportNull$$$0(0);
        }
        for (FirefoxProfile firefoxProfile : profiles) {
            if (!firefoxProfile.getName().equals(name)) continue;
            return firefoxProfile;
        }
        return FirefoxUtil.getDefaultProfile(profiles);
    }

    @Nullable
    public static FirefoxProfile getDefaultProfile(List<? extends FirefoxProfile> profiles) {
        if (profiles.isEmpty()) {
            return null;
        }
        for (FirefoxProfile firefoxProfile : profiles) {
            if (!firefoxProfile.isDefault()) continue;
            return firefoxProfile;
        }
        return profiles.get(0);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static List<FirefoxProfile> computeProfiles(@Nullable File profilesFile) {
        SmartList smartList;
        Throwable throwable;
        BufferedReader reader;
        block26: {
            block27: {
                if (profilesFile == null || !profilesFile.isFile()) {
                    List<FirefoxProfile> list = Collections.emptyList();
                    if (list == null) {
                        FirefoxUtil.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                reader = new BufferedReader(new FileReader(profilesFile));
                throwable = null;
                SmartList profiles = new SmartList();
                boolean insideProfile = false;
                String currentName = null;
                String currentPath = null;
                boolean isDefault = false;
                boolean isRelative = false;
                boolean eof = false;
                while (!eof) {
                    String line = reader.readLine();
                    if (line == null) {
                        eof = true;
                        line = "[]";
                    } else {
                        line = line.trim();
                    }
                    if (line.startsWith("[") && line.endsWith("]")) {
                        if (!StringUtil.isEmpty(currentPath) && !StringUtil.isEmpty(currentName)) {
                            profiles.add(new FirefoxProfile(currentName, currentPath, isDefault, isRelative));
                        }
                        currentName = null;
                        currentPath = null;
                        isDefault = false;
                        isRelative = false;
                        insideProfile = StringUtil.startsWithIgnoreCase((String)line, (String)"[Profile");
                        continue;
                    }
                    int i = line.indexOf(61);
                    if (i == -1 || !insideProfile) continue;
                    String name = line.substring(0, i).trim();
                    String value = line.substring(i + 1).trim();
                    if (name.equalsIgnoreCase("path")) {
                        currentPath = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("name")) {
                        currentName = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("default") && value.equals("1")) {
                        isDefault = true;
                        continue;
                    }
                    if (!name.equalsIgnoreCase("isrelative") || !value.equals("1")) continue;
                    isRelative = true;
                }
                smartList = profiles;
                if (reader == null) break block26;
                if (throwable == null) break block27;
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block26;
            }
            reader.close();
        }
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            FirefoxUtil.$$$reportNull$$$0(2);
        }
        return smartList2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    List<FirefoxProfile> list = Collections.emptyList();
                    if (list == null) {
                        FirefoxUtil.$$$reportNull$$$0(3);
                    }
                    return list;
                }
            }
        }
    }

    private static File[] getProfilesDirs() {
        String userHome = SystemProperties.getUserHome();
        if (SystemInfo.isMac) {
            return new File[]{new File(userHome, "Library" + File.separator + "Mozilla" + File.separator + "Firefox"), new File(userHome, "Library" + File.separator + "Application Support" + File.separator + "Firefox")};
        }
        if (SystemInfo.isUnix) {
            return new File[]{new File(userHome, ".mozilla" + File.separator + "firefox")};
        }
        String localPath = "Mozilla" + File.separator + "Firefox";
        return new File[]{new File(System.getenv("APPDATA"), localPath), new File(userHome, "AppData" + File.separator + "Roaming" + File.separator + localPath), new File(userHome, "Application Data" + File.separator + localPath)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/firefox/FirefoxUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/firefox/FirefoxUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findProfileByNameOrDefault";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

